/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.DataWindowView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitor;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.FirstUniqueByPropertyViewFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FirstUniqueByPropertyView
extends ViewSupport
implements CloneableView,
DataWindowView {
    private final FirstUniqueByPropertyViewFactory viewFactory;
    protected final ExprEvaluator[] uniqueCriteriaEval;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected final Map<Object, EventBean> firstEvents = new HashMap<Object, EventBean>();
    protected final AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext;

    public FirstUniqueByPropertyView(FirstUniqueByPropertyViewFactory viewFactory, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.viewFactory = viewFactory;
        this.uniqueCriteriaEval = ExprNodeUtility.getEvaluators(viewFactory.criteriaExpressions);
        this.agentInstanceViewFactoryContext = agentInstanceViewFactoryContext;
    }

    @Override
    public View cloneView() {
        return this.viewFactory.makeView(this.agentInstanceViewFactoryContext);
    }

    public final ExprNode[] getUniqueCriteria() {
        return this.viewFactory.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        Object key;
        EventBean[] newDataToPost = null;
        EventBean[] oldDataToPost = null;
        if (oldData != null) {
            for (EventBean oldEvent : oldData) {
                key = this.getUniqueKey(oldEvent);
                EventBean lastValue = this.firstEvents.get(key);
                if (lastValue != oldEvent) continue;
                oldDataToPost = oldDataToPost == null ? new EventBean[]{oldEvent} : EventBeanUtility.addToArray(oldDataToPost, oldEvent);
                this.firstEvents.remove(key);
                this.internalHandleRemoved(key, lastValue);
            }
        }
        if (newData != null) {
            for (EventBean newEvent : newData) {
                key = this.getUniqueKey(newEvent);
                if (this.firstEvents.containsKey(key)) continue;
                this.firstEvents.put(key, newEvent);
                this.internalHandleAdded(key, newEvent);
                newDataToPost = newDataToPost == null ? new EventBean[]{newEvent} : EventBeanUtility.addToArray(newDataToPost, newEvent);
            }
        }
        if (this.hasViews() && (newDataToPost != null || oldDataToPost != null)) {
            this.updateChildren(newDataToPost, oldDataToPost);
        }
    }

    public void internalHandleRemoved(Object key, EventBean lastValue) {
    }

    public void internalHandleAdded(Object key, EventBean newEvent) {
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.firstEvents.values().iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " uniqueCriteria=" + Arrays.toString(this.viewFactory.criteriaExpressions);
    }

    protected Object getUniqueKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.uniqueCriteriaEval.length == 1) {
            return this.uniqueCriteriaEval[0].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        Object[] values = new Object[this.uniqueCriteriaEval.length];
        for (int i = 0; i < this.uniqueCriteriaEval.length; ++i) {
            values[i] = this.uniqueCriteriaEval[i].evaluate(this.eventsPerStream, true, this.agentInstanceViewFactoryContext);
        }
        return new MultiKeyUntyped(values);
    }

    public boolean isEmpty() {
        return this.firstEvents.isEmpty();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.firstEvents, true, "First-Unique-By", this.firstEvents.size(), this.firstEvents.size());
    }

    @Override
    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }
}

