/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view.std;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.CloneableView;
import com.espertech.esper.view.GroupableView;
import com.espertech.esper.view.StoppableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewDataVisitorContained;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.std.GroupByView;
import com.espertech.esper.view.std.GroupByViewAgedEntry;
import com.espertech.esper.view.std.GroupByViewImpl;
import com.espertech.esper.view.std.MergeView;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewReclaimAged
extends ViewSupport
implements CloneableView,
GroupByView {
    private final ExprNode[] criteriaExpressions;
    private final ExprEvaluator[] criteriaEvaluators;
    protected final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final long reclaimMaxAge;
    private final long reclaimFrequency;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected String[] propertyNames;
    protected final Map<Object, GroupByViewAgedEntry> subViewsPerKey = new HashMap<Object, GroupByViewAgedEntry>();
    private final HashMap<GroupByViewAgedEntry, Pair<Object, Object>> groupedEvents = new HashMap();
    private Long nextSweepTime = null;
    private static final Logger log = LoggerFactory.getLogger(GroupByViewReclaimAged.class);

    public GroupByViewReclaimAged(AgentInstanceViewFactoryChainContext agentInstanceContext, ExprNode[] criteriaExpressions, ExprEvaluator[] criteriaEvaluators, double reclaimMaxAgeSeconds, double reclaimFrequencySeconds) {
        this.agentInstanceContext = agentInstanceContext;
        this.criteriaExpressions = criteriaExpressions;
        this.criteriaEvaluators = criteriaEvaluators;
        TimeAbacus timeAbacus = agentInstanceContext.getStatementContext().getEngineImportService().getTimeAbacus();
        this.reclaimMaxAge = timeAbacus.deltaForSecondsDouble(reclaimMaxAgeSeconds);
        this.reclaimFrequency = timeAbacus.deltaForSecondsDouble(reclaimFrequencySeconds);
        this.propertyNames = new String[criteriaExpressions.length];
        for (int i = 0; i < criteriaExpressions.length; ++i) {
            this.propertyNames[i] = ExprNodeUtility.toExpressionStringMinPrecedenceSafe(criteriaExpressions[i]);
        }
    }

    @Override
    public View cloneView() {
        return new GroupByViewReclaimAged(this.agentInstanceContext, this.criteriaExpressions, this.criteriaEvaluators, this.reclaimMaxAge, this.reclaimFrequency);
    }

    @Override
    public ExprNode[] getCriteriaExpressions() {
        return this.criteriaExpressions;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        long currentTime = this.agentInstanceContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug("Reclaiming groups older then " + this.reclaimMaxAge + " msec and every " + this.reclaimFrequency + "msec in frequency");
            }
            this.nextSweepTime = currentTime + this.reclaimFrequency;
            this.sweep(currentTime);
        }
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            EventBean[] eventBeanArray = new EventBean[]{theEvent};
            Object groupByValuesKey = this.getGroupKey(theEvent);
            GroupByViewAgedEntry subViews = this.subViewsPerKey.get(groupByValuesKey);
            if (subViews == null) {
                Object subviewsList = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey, this.agentInstanceContext);
                subViews = new GroupByViewAgedEntry(subviewsList, currentTime);
                this.subViewsPerKey.put(groupByValuesKey, subViews);
            } else {
                subViews.setLastUpdateTime(currentTime);
            }
            GroupByViewImpl.updateChildViews(subViews.getSubviewHolder(), eventBeanArray, null);
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getSecond());
                GroupByViewImpl.updateChildViews(entry.getKey(), newEvents, oldEvents);
            }
            this.groupedEvents.clear();
        }
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Object groupByValuesKey = this.getGroupKey(theEvent);
        GroupByViewAgedEntry subViews = this.subViewsPerKey.get(groupByValuesKey);
        if (subViews == null) {
            Object subviewsList = GroupByViewImpl.makeSubViews(this, this.propertyNames, groupByValuesKey, this.agentInstanceContext);
            long currentTime = this.agentInstanceContext.getStatementContext().getTimeProvider().getTime();
            subViews = new GroupByViewAgedEntry(subviewsList, currentTime);
            this.subViewsPerKey.put(groupByValuesKey, subViews);
        } else {
            subViews.setLastUpdateTime(this.agentInstanceContext.getStatementContext().getTimeProvider().getTime());
        }
        Pair<Object, Object> pair = this.groupedEvents.get(subViews);
        if (pair == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        throw new UnsupportedOperationException("Cannot iterate over group view, this operation is not supported");
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.criteriaExpressions);
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        viewDataVisitor.visitPrimary("Group-By", this.subViewsPerKey.size());
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewsPerKey.entrySet()) {
            GroupByViewImpl.visitView(viewDataVisitor, entry.getKey(), entry.getValue().getSubviewHolder());
        }
    }

    private void sweep(long currentTime) {
        ArrayDeque<Object> removed = new ArrayDeque<Object>();
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewsPerKey.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= this.reclaimMaxAge) continue;
            removed.add(entry.getKey());
        }
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : removed) {
            GroupByViewAgedEntry entry2 = this.subViewsPerKey.remove(entry);
            Object subviewHolder = entry2.getSubviewHolder();
            if (subviewHolder instanceof List) {
                List subviews = (List)subviewHolder;
                for (View view : subviews) {
                    this.removeSubview(view);
                }
                continue;
            }
            if (!(subviewHolder instanceof View)) continue;
            this.removeSubview((View)subviewHolder);
        }
    }

    @Override
    public boolean removeView(View view) {
        boolean removed;
        if (!(view instanceof GroupableView)) {
            super.removeView(view);
        }
        if (!(removed = super.removeView(view))) {
            return false;
        }
        if (!this.hasViews()) {
            this.subViewsPerKey.clear();
            return true;
        }
        GroupableView removedView = (GroupableView)((Object)view);
        ArrayDeque<Object> removedKeys = null;
        block0: for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewsPerKey.entrySet()) {
            Object value = entry.getValue().getSubviewHolder();
            if (value instanceof View) {
                GroupableView subview = (GroupableView)value;
                if (!this.compareViews(subview, removedView)) continue;
                if (removedKeys == null) {
                    removedKeys = new ArrayDeque<Object>();
                }
                removedKeys.add(entry.getKey());
                continue;
            }
            if (!(value instanceof List)) continue;
            List subviews = (List)value;
            for (int i = 0; i < subviews.size(); ++i) {
                GroupableView subview = (GroupableView)subviews.get(i);
                if (!this.compareViews(subview, removedView)) continue;
                subviews.remove(i);
                if (!subviews.isEmpty()) continue block0;
                if (removedKeys == null) {
                    removedKeys = new ArrayDeque();
                }
                removedKeys.add(entry.getKey());
                continue block0;
            }
        }
        if (removedKeys != null) {
            for (Map.Entry<Object, GroupByViewAgedEntry> entry : removedKeys) {
                this.subViewsPerKey.remove(entry);
            }
        }
        return true;
    }

    private boolean compareViews(GroupableView subview, GroupableView removed) {
        return subview.getViewFactory() == removed.getViewFactory();
    }

    private void removeSubview(View view) {
        view.setParent(null);
        this.recursiveMergeViewRemove(view);
        if (view instanceof StoppableView) {
            ((StoppableView)((Object)view)).stop();
        }
    }

    private void recursiveMergeViewRemove(View view) {
        for (View child : view.getViews()) {
            if (child instanceof MergeView) {
                MergeView mergeView = (MergeView)child;
                mergeView.removeParentView(view);
                continue;
            }
            if (child instanceof StoppableView) {
                ((StoppableView)((Object)child)).stop();
            }
            if (child.getViews().length <= 0) continue;
            this.recursiveMergeViewRemove(child);
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.criteriaEvaluators.length == 1) {
            return this.criteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        Object[] values = new Object[this.criteriaEvaluators.length];
        for (int i = 0; i < this.criteriaEvaluators.length; ++i) {
            values[i] = this.criteriaEvaluators[i].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        return new MultiKeyUntyped(values);
    }
}

