/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.kafka;

import com.espertech.esper.client.ConfigurationException;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.core.service.EPServiceProviderSPI;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esperio.kafka.EsperIOKafkaInputAdapter;
import com.espertech.esperio.kafka.EsperIOKafkaOutputFlowController;
import com.espertech.esperio.kafka.EsperIOKafkaOutputFlowControllerContext;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsperIOKafkaOutputAdapter {
    private static final Logger log = LoggerFactory.getLogger(EsperIOKafkaOutputAdapter.class);
    private final Properties properties;
    private final String engineURI;
    private EsperIOKafkaOutputFlowController controller;

    public EsperIOKafkaOutputAdapter(Properties properties, String engineURI) {
        this.properties = properties;
        this.engineURI = engineURI;
    }

    public void start() {
        if (log.isInfoEnabled()) {
            log.info("Starting EsperIO Kafka Output Adapter for engine URI '{}'", (Object)this.engineURI);
        }
        EPServiceProviderSPI engine = (EPServiceProviderSPI)EPServiceProviderManager.getProvider(this.engineURI);
        String className = EsperIOKafkaInputAdapter.getRequiredProperty((Properties)this.properties, (String)"esperio.kafka.output.flowcontroller");
        try {
            EsperIOKafkaOutputFlowController controller = (EsperIOKafkaOutputFlowController)JavaClassHelper.instantiate(EsperIOKafkaOutputFlowController.class, className, engine.getEngineImportService().getClassForNameProvider());
            EsperIOKafkaOutputFlowControllerContext context = new EsperIOKafkaOutputFlowControllerContext((EPServiceProvider)engine, this.properties);
            controller.initialize(context);
        }
        catch (Throwable t) {
            throw new ConfigurationException("Unexpected exception invoking flow-controller initialize method on class " + className + " for engine URI '" + this.engineURI + "': " + t.getMessage(), t);
        }
        if (log.isInfoEnabled()) {
            log.info("Completed starting EsperIO Kafka Output Adapter for engine URI '{}'", (Object)this.engineURI);
        }
    }

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug("Destroying Esper Kafka Output Adapter for engine URI '{}'", (Object)this.engineURI);
        }
        if (this.controller != null) {
            try {
                this.controller.close();
            }
            catch (Throwable t) {
                log.warn("Unexpected exception invoking flow-controller close method: " + t.getMessage(), t);
            }
            this.controller = null;
        }
    }
}

