/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.kafka;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.junit.Assert;

public class SupportAwaitUtil {
    public static <T> T awaitOrFail(long waitTime, TimeUnit timeUnit, String message, Supplier<T> supplier) {
        long start = System.currentTimeMillis();
        long waitTimeMSec = TimeUnit.MILLISECONDS.convert(waitTime, timeUnit);
        T result;
        while ((result = supplier.get()) == null) {
            long delta = System.currentTimeMillis() - start;
            if (delta > waitTimeMSec) {
                Assert.fail((String)("Failed after waiting for " + waitTime + " " + timeUnit.name() + ": " + message));
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
        }
        return result;
    }
}

