/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esperio.kafka;

import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esperio.kafka.SupportAwaitUtil;
import com.espertech.esperio.kafka.SupportBean;
import com.espertech.esperio.kafka.SupportBeanFromStringDeserializer;
import com.espertech.esperio.kafka.SupportConstants;
import com.espertech.esperio.kafka.SupportListener;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class TestKafkaInputNoTimestampStringValue
extends TestCase {
    private static final String TOPIC = "esperio_regression_input_t1";

    public void testInput() {
        Properties pluginProperties = SupportConstants.getInputPluginProps((String)TOPIC, (String)SupportBeanFromStringDeserializer.class.getName(), null);
        EPServiceProvider epService = SupportConstants.getEngineWKafkaInput((String)this.getClass().getSimpleName(), (Properties)pluginProperties);
        epService.getEPAdministrator().getConfiguration().addEventType("SupportBean", SupportBean.class);
        EPStatement stmt = epService.getEPAdministrator().createEPL("select * from SupportBean");
        SupportListener listener = new SupportListener();
        stmt.addListener((UpdateListener)listener);
        Properties producerProperties = SupportConstants.getProducerProps((String)StringSerializer.class.getName());
        KafkaProducer producer = new KafkaProducer(producerProperties);
        for (int i = 0; i < 10; ++i) {
            String generatedUUID = UUID.randomUUID().toString();
            producer.send(new ProducerRecord(TOPIC, (Object)generatedUUID));
            SupportAwaitUtil.awaitOrFail((long)10L, (TimeUnit)TimeUnit.SECONDS, (String)"failed to receive expected event", () -> {
                Iterator iterator = listener.getEvents().iterator();
                while (iterator.hasNext()) {
                    EventBean[] events;
                    for (EventBean event : events = (EventBean[])iterator.next()) {
                        SupportBean bean = (SupportBean)event.getUnderlying();
                        if (!bean.getStringProp().equals(generatedUUID)) continue;
                        return true;
                    }
                }
                return null;
            });
        }
        producer.close();
        epService.destroy();
    }
}

