/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.List;

public class CreateTableColumn
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String columnName;
    private Expression optionalExpression;
    private String optionalTypeName;
    private Boolean optionalTypeIsArray;
    private Boolean optionalTypeIsPrimitiveArray;
    private List<AnnotationPart> annotations;
    private Boolean primaryKey;

    public CreateTableColumn(String columnName, Expression optionalExpression, String optionalTypeName, Boolean optionalTypeIsArray, Boolean optionalTypeIsPrimitiveArray, List<AnnotationPart> annotations, Boolean primaryKey) {
        this.columnName = columnName;
        this.optionalExpression = optionalExpression;
        this.optionalTypeName = optionalTypeName;
        this.optionalTypeIsArray = optionalTypeIsArray;
        this.optionalTypeIsPrimitiveArray = optionalTypeIsPrimitiveArray;
        this.annotations = annotations;
        this.primaryKey = primaryKey;
    }

    public CreateTableColumn() {
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public List<AnnotationPart> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationPart> annotations) {
        this.annotations = annotations;
    }

    public Expression getOptionalExpression() {
        return this.optionalExpression;
    }

    public void setOptionalExpression(Expression optionalExpression) {
        this.optionalExpression = optionalExpression;
    }

    public String getOptionalTypeName() {
        return this.optionalTypeName;
    }

    public void setOptionalTypeName(String optionalTypeName) {
        this.optionalTypeName = optionalTypeName;
    }

    public Boolean getOptionalTypeIsArray() {
        return this.optionalTypeIsArray;
    }

    public void setOptionalTypeIsArray(Boolean optionalTypeIsArray) {
        this.optionalTypeIsArray = optionalTypeIsArray;
    }

    public Boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Boolean getOptionalTypeIsPrimitiveArray() {
        return this.optionalTypeIsPrimitiveArray;
    }

    public void setOptionalTypeIsPrimitiveArray(Boolean optionalTypeIsPrimitiveArray) {
        this.optionalTypeIsPrimitiveArray = optionalTypeIsPrimitiveArray;
    }

    public void toEPL(StringWriter writer) {
        writer.append(this.columnName);
        writer.append(" ");
        if (this.optionalExpression != null) {
            this.optionalExpression.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        } else {
            writer.append(this.optionalTypeName);
            if (this.optionalTypeIsArray != null && this.optionalTypeIsArray.booleanValue()) {
                if (this.optionalTypeIsPrimitiveArray != null && this.optionalTypeIsPrimitiveArray.booleanValue()) {
                    writer.append("[primitive]");
                } else {
                    writer.append("[]");
                }
            }
            if (this.primaryKey.booleanValue()) {
                writer.append(" primary key");
            }
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            writer.append(" ");
            String delimiter = "";
            for (AnnotationPart part : this.annotations) {
                if (part.getName() == null) continue;
                writer.append(delimiter);
                delimiter = " ";
                part.toEPL(writer);
            }
        }
    }
}

