/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.EPStatementFormatter;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.client.soda.Stream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class MethodInvocationStream
extends Stream {
    private String className;
    private String methodName;
    private List<Expression> parameterExpressions;
    private String optionalEventTypeName;
    private static final long serialVersionUID = -4629123886680505829L;

    public MethodInvocationStream() {
    }

    public static MethodInvocationStream create(String className, String methodName) {
        return new MethodInvocationStream(className, methodName, null);
    }

    public static MethodInvocationStream create(String className, String methodName, String optStreamName) {
        return new MethodInvocationStream(className, methodName, optStreamName);
    }

    public MethodInvocationStream(String className, String methodName, String optStreamName) {
        super(optStreamName);
        this.className = className;
        this.methodName = methodName;
        this.parameterExpressions = new ArrayList<Expression>();
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public List<Expression> getParameterExpressions() {
        return this.parameterExpressions;
    }

    public void setParameterExpressions(List<Expression> parameterExpressions) {
        this.parameterExpressions = parameterExpressions;
    }

    public String getOptionalEventTypeName() {
        return this.optionalEventTypeName;
    }

    public void setOptionalEventTypeName(String optionalEventTypeName) {
        this.optionalEventTypeName = optionalEventTypeName;
    }

    public MethodInvocationStream addParameter(Expression parameterExpression) {
        this.parameterExpressions.add(parameterExpression);
        return this;
    }

    @Override
    public void toEPLStream(StringWriter writer, EPStatementFormatter formatter) {
        writer.write("method:");
        writer.write(this.className);
        writer.write(".");
        writer.write(this.methodName);
        writer.write("(");
        String delimiter = "";
        for (Expression expr : this.parameterExpressions) {
            writer.append(delimiter);
            expr.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.write(")");
        if (this.optionalEventTypeName != null) {
            writer.append(" @type(");
            writer.append(this.optionalEventTypeName);
            writer.append(")");
        }
    }

    @Override
    public void toEPLStreamType(StringWriter writer) {
        writer.write("method:");
        writer.write(this.className);
        writer.write(".");
        writer.write(this.methodName);
        writer.write("(..)");
    }

    @Override
    public void toEPLStreamOptions(StringWriter writer) {
    }
}

