/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.client.soda;

import com.espertech.esper.client.soda.Assignment;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.ExpressionPrecedenceEnum;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class UpdateClause
implements MetaDefItem,
Serializable {
    private static final long serialVersionUID = 0L;
    private String eventType;
    private String optionalAsClauseStreamName;
    private List<Assignment> assignments;
    private Expression optionalWhereClause;

    public UpdateClause() {
    }

    public static UpdateClause create(String eventType, Expression expression) {
        UpdateClause clause = new UpdateClause(eventType, null);
        clause.addAssignment(expression);
        return clause;
    }

    public UpdateClause(String eventType, String optionalAsClauseStreamName) {
        this.eventType = eventType;
        this.optionalAsClauseStreamName = optionalAsClauseStreamName;
        this.assignments = new ArrayList<Assignment>();
    }

    public UpdateClause addAssignment(Expression expression) {
        this.assignments.add(new Assignment(expression));
        return this;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments = assignments;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public Expression getOptionalWhereClause() {
        return this.optionalWhereClause;
    }

    public void setOptionalWhereClause(Expression optionalWhereClause) {
        this.optionalWhereClause = optionalWhereClause;
    }

    public String getOptionalAsClauseStreamName() {
        return this.optionalAsClauseStreamName;
    }

    public void setOptionalAsClauseStreamName(String optionalAsClauseStreamName) {
        this.optionalAsClauseStreamName = optionalAsClauseStreamName;
    }

    public void toEPL(StringWriter writer) {
        writer.write("update istream ");
        writer.write(this.eventType);
        if (this.optionalAsClauseStreamName != null) {
            writer.write(" as ");
            writer.write(this.optionalAsClauseStreamName);
        }
        writer.write(" ");
        UpdateClause.renderEPLAssignments(writer, this.assignments);
        if (this.optionalWhereClause != null) {
            writer.write(" where ");
            this.optionalWhereClause.toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
        }
    }

    public static void renderEPLAssignments(StringWriter writer, List<Assignment> assignments) {
        writer.write("set ");
        String delimiter = "";
        for (Assignment pair : assignments) {
            writer.write(delimiter);
            pair.getValue().toEPL(writer, ExpressionPrecedenceEnum.MINIMUM);
            delimiter = ", ";
        }
    }
}

