/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.compile;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.util.ClassLoaderProvider;
import com.espertech.esper.codegen.compile.CodeGenerationUtil;
import com.espertech.esper.codegen.core.CodeGenerationHelper;
import com.espertech.esper.codegen.core.CodegenClass;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.util.JavaClassHelper;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodegenCompiler {
    public static final boolean DEBUG = true;
    private static final Logger log = LoggerFactory.getLogger(CodegenCompiler.class);
    private static Class janinoCompilerClass;
    private static Constructor janinoCompilerCtor;
    private static Method janinoCompilerCookMethod;
    private static Method janinoCompilerGetClassLoaderMethod;
    private static Method janinoCompilerSetDebuggingInformationMethod;
    private static Method janinoCompilerSetParentClassLoaderMethod;

    public static <T> T compile(CodegenClass clazz, ClassLoaderProvider classLoaderProvider, Class<T> interfaceClass, String classLevelComment) {
        if (janinoCompilerClass == null) {
            CodegenCompiler.setupJanino();
        }
        LinkedHashSet<CodegenMember> memberSet = new LinkedHashSet<CodegenMember>(clazz.getMembers());
        Set<Class> classes = clazz.getReferencedClasses();
        Map<Class, String> imports = CodegenCompiler.compileImports(classes);
        String code = CodegenCompiler.generateCode(imports, clazz, memberSet, classLevelComment);
        String fullyQualifiedClassName = clazz.getPackageName() + "." + clazz.getClassName();
        Object[] params = new Object[memberSet.size()];
        int count = 0;
        for (CodegenMember member : memberSet) {
            params[count++] = member.getObject();
        }
        Class<T> compiled = CodegenCompiler.compileWJanino(code, fullyQualifiedClassName, classLoaderProvider);
        try {
            return interfaceClass.cast(compiled.getConstructors()[0].newInstance(params));
        }
        catch (Exception ex) {
            throw new EPException("Failed to instantiate code-generated class: " + ex.getMessage(), ex);
        }
    }

    private static void setupJanino() {
        String classnameCompiler = "org.codehaus.janino.SimpleCompiler";
        try {
            janinoCompilerClass = Class.forName("org.codehaus.janino.SimpleCompiler");
        }
        catch (Exception ex) {
            throw new EPException("Failed to load Janino compiler class '" + classnameCompiler + "': " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerCtor = janinoCompilerClass.getConstructor(new Class[0]);
        }
        catch (Exception ex) {
            throw new EPException("Failed to find Janino compiler constructor taking no parameters: " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerCookMethod = janinoCompilerClass.getMethod("cook", Reader.class);
        }
        catch (Exception ex) {
            throw new EPException("Failed to find Janino compiler cook method taking StringReader as parameter: " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerGetClassLoaderMethod = janinoCompilerClass.getMethod("getClassLoader", new Class[0]);
        }
        catch (Exception ex) {
            throw new EPException("Failed to find Janino compiler 'getClassLoader' method: " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerSetDebuggingInformationMethod = janinoCompilerClass.getMethod("setDebuggingInformation", Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Exception ex) {
            throw new EPException("Failed to find Janino compiler 'setDebuggingInformation' method: " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerSetParentClassLoaderMethod = janinoCompilerClass.getMethod("setParentClassLoader", ClassLoader.class);
        }
        catch (Exception ex) {
            throw new EPException("Failed to find Janino compiler 'janinoCompilerSetParentClassLoaderMethod' method: " + ex.getMessage(), ex);
        }
    }

    private static <T> Class<T> compileWJanino(String code, String fullyQualifiedClassName, ClassLoaderProvider classLoaderProvider) {
        ClassLoader classLoader;
        Object compiler;
        try {
            compiler = janinoCompilerCtor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new EPException("Failed to instantiate Janino scanner: " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerSetParentClassLoaderMethod.invoke(compiler, classLoaderProvider.classloader());
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino getClassLoader: " + ex.getMessage(), ex);
        }
        try {
            janinoCompilerSetDebuggingInformationMethod.invoke(compiler, true, true, true);
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino getClassLoader: " + ex.getMessage(), ex);
        }
        try {
            log.info("Compiling class " + fullyQualifiedClassName + ":\n" + CodeGenerationUtil.codeWithLineNum(code));
            janinoCompilerCookMethod.invoke(compiler, new StringReader(code));
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String message = "Failed code generation: " + t.getMessage() + "\ncode:\n" + CodeGenerationUtil.codeWithLineNum(code);
            log.error(message, t);
            throw new EPException(message, t);
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino compile method: " + ex.getMessage(), ex);
        }
        try {
            classLoader = (ClassLoader)janinoCompilerGetClassLoaderMethod.invoke(compiler, new Object[0]);
        }
        catch (Exception ex) {
            throw new EPException("Failed to invoke Janino getClassLoader: " + ex.getMessage(), ex);
        }
        try {
            return Class.forName(fullyQualifiedClassName, true, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new EPException("Failed find compiled class: " + ex.getMessage(), ex);
        }
    }

    private static Map<Class, String> compileImports(Set<Class> classes) {
        HashMap<Class, String> imports = new HashMap<Class, String>();
        HashMap<String, Class> assignments = new HashMap<String, Class>();
        for (Class clazz : classes) {
            if (clazz == null) continue;
            if (clazz.isArray()) {
                CodegenCompiler.compileImports(JavaClassHelper.getComponentTypeOutermost(clazz), imports, assignments);
                continue;
            }
            CodegenCompiler.compileImports(clazz, imports, assignments);
        }
        return imports;
    }

    private static void compileImports(Class clazz, Map<Class, String> imports, Map<String, Class> assignments) {
        if (clazz == null || clazz.isPrimitive()) {
            return;
        }
        try {
            if (clazz.getPackage().getName().equals("java.lang")) {
                imports.put(clazz, clazz.getSimpleName());
                return;
            }
        }
        catch (Throwable r) {
            System.out.println(r);
        }
        if (assignments.containsKey(clazz.getSimpleName())) {
            return;
        }
        imports.put(clazz, clazz.getSimpleName());
        assignments.put(clazz.getSimpleName(), clazz);
    }

    private static String generateCode(Map<Class, String> imports, CodegenClass clazz, Set<CodegenMember> memberSet, String classLevelComment) {
        StringBuilder builder = new StringBuilder();
        CodeGenerationUtil.packagedecl(builder, clazz.getPackageName());
        CodeGenerationUtil.importsdecl(builder, imports.keySet());
        if (classLevelComment != null) {
            builder.append("// ").append(classLevelComment).append("\n");
        }
        CodeGenerationUtil.classimplements(builder, clazz.getClassName(), clazz.getInterfaceImplemented());
        for (CodegenMember codegenMember : memberSet) {
            CodeGenerationHelper.appendClassName(builder, codegenMember.getClazz(), codegenMember.getOptionalTypeParam(), imports);
            builder.append(" ").append(codegenMember.getMemberName()).append(";\n");
        }
        builder.append("public ").append(clazz.getClassName()).append("(");
        String delimiter = "";
        for (CodegenMember member : memberSet) {
            builder.append(delimiter);
            CodeGenerationHelper.appendClassName(builder, member.getClazz(), member.getOptionalTypeParam(), imports);
            builder.append(" ").append(member.getMemberName());
            delimiter = ",";
        }
        builder.append("){\n");
        for (CodegenMember member : memberSet) {
            builder.append("this.").append(member.getMemberName()).append("=").append(member.getMemberName()).append(";\n");
        }
        builder.append("}\n");
        for (CodegenMethod publicMethod : clazz.getPublicMethods()) {
            publicMethod.render(builder, imports, true);
        }
        LinkedHashSet<CodegenMethod> linkedHashSet = new LinkedHashSet<CodegenMethod>(clazz.getPrivateMethods());
        for (CodegenMethod method : linkedHashSet) {
            method.render(builder, imports, false);
        }
        builder.append("}\n");
        return builder.toString();
    }
}

