/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.codegen.model.expression.CodegenExpression;
import com.espertech.esper.codegen.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.codegen.model.statement.CodegenStatement;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignArrayElement;
import com.espertech.esper.codegen.model.statement.CodegenStatementAssignRef;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVar;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVarEventPerStreamUnd;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVarNull;
import com.espertech.esper.codegen.model.statement.CodegenStatementDeclareVarWCast;
import com.espertech.esper.codegen.model.statement.CodegenStatementExprDotMethod;
import com.espertech.esper.codegen.model.statement.CodegenStatementExpression;
import com.espertech.esper.codegen.model.statement.CodegenStatementForInt;
import com.espertech.esper.codegen.model.statement.CodegenStatementIf;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfConditionReturnConst;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfRefNotTypeReturnConst;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfRefNullReturnFalse;
import com.espertech.esper.codegen.model.statement.CodegenStatementIfRefNullReturnNull;
import com.espertech.esper.codegen.model.statement.CodegenStatementReturnExpression;
import com.espertech.esper.codegen.model.statement.CodegenStatementWBlockBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenBlock {
    private final CodegenMethod parentMethod;
    private final CodegenStatementWBlockBase parentWBlock;
    private boolean closed;
    protected List<CodegenStatement> statements = new ArrayList<CodegenStatement>(4);

    public CodegenBlock(CodegenMethod parentMethod) {
        this.parentMethod = parentMethod;
        this.parentWBlock = null;
    }

    public CodegenBlock(CodegenStatementWBlockBase parentWBlock) {
        this.parentWBlock = parentWBlock;
        this.parentMethod = null;
    }

    public CodegenBlock expression(CodegenExpression expression) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExpression(expression));
        return this;
    }

    public CodegenBlock ifConditionReturnConst(CodegenExpression condition, Object constant) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfConditionReturnConst(condition, constant));
        return this;
    }

    public CodegenBlock ifNotInstanceOf(String name, Class clazz) {
        return this.ifInstanceOf(name, clazz, true);
    }

    public CodegenBlock ifInstanceOf(String name, Class clazz) {
        return this.ifInstanceOf(name, clazz, false);
    }

    private CodegenBlock ifInstanceOf(String name, Class clazz, boolean not) {
        this.checkClosed();
        CodegenStatementIf ifStmt = new CodegenStatementIf(this);
        CodegenExpression condition = !not ? CodegenExpressionBuilder.instanceOf(CodegenExpressionBuilder.ref(name), clazz) : CodegenExpressionBuilder.notInstanceOf(CodegenExpressionBuilder.ref(name), clazz);
        CodegenBlock block = new CodegenBlock(ifStmt);
        ifStmt.add(condition, block);
        this.statements.add(ifStmt);
        return block;
    }

    public CodegenBlock forLoopInt(String name, CodegenExpression upperLimit) {
        this.checkClosed();
        CodegenStatementForInt forStmt = new CodegenStatementForInt(this, name, upperLimit);
        CodegenBlock block = new CodegenBlock(forStmt);
        forStmt.setBlock(block);
        this.statements.add(forStmt);
        return block;
    }

    public CodegenBlock blockElseIf(CodegenExpression condition) {
        if (this.parentMethod != null) {
            throw new IllegalStateException("Else-If in a method-level block?");
        }
        if (!(this.parentWBlock instanceof CodegenStatementIf)) {
            throw new IllegalStateException("Else_if in a non-if block?");
        }
        CodegenStatementIf ifStmt = (CodegenStatementIf)this.parentWBlock;
        this.checkClosed();
        this.closed = true;
        CodegenBlock block = new CodegenBlock(this.parentWBlock);
        ifStmt.add(condition, block);
        return block;
    }

    public CodegenBlock blockElse() {
        if (this.parentMethod != null) {
            throw new IllegalStateException("Else in a method-level block?");
        }
        if (!(this.parentWBlock instanceof CodegenStatementIf)) {
            throw new IllegalStateException("Else in a non-if block?");
        }
        CodegenStatementIf ifStmt = (CodegenStatementIf)this.parentWBlock;
        if (ifStmt.getOptionalElse() != null) {
            throw new IllegalStateException("Else already present");
        }
        this.checkClosed();
        this.closed = true;
        CodegenBlock block = new CodegenBlock(this.parentWBlock);
        ifStmt.setOptionalElse(block);
        return block;
    }

    public CodegenBlock declareVarWCast(Class clazz, String var, String rhsName) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVarWCast(clazz, var, rhsName));
        return this;
    }

    public CodegenBlock declareVar(Class clazz, String var, CodegenExpression initializer) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVar(clazz, var, initializer));
        return this;
    }

    public CodegenBlock declareVarNull(Class clazz, String var) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVarNull(clazz, var));
        return this;
    }

    public CodegenBlock assignRef(String ref, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignRef(ref, assignment));
        return this;
    }

    public CodegenBlock assignArrayElement(String ref, CodegenExpression index, CodegenExpression assignment) {
        this.checkClosed();
        this.statements.add(new CodegenStatementAssignArrayElement(ref, index, assignment));
        return this;
    }

    public CodegenBlock exprDotMethod(CodegenExpression expression, String method, CodegenExpression ... params) {
        this.checkClosed();
        this.statements.add(new CodegenStatementExprDotMethod(expression, method, params));
        return this;
    }

    public CodegenBlock ifRefNullReturnFalse(String ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNullReturnFalse(ref));
        return this;
    }

    public CodegenBlock ifRefNotTypeReturnConst(String ref, Class type, Object constant) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNotTypeReturnConst(ref, type, constant));
        return this;
    }

    public CodegenBlock ifRefNullReturnNull(String ref) {
        this.checkClosed();
        this.statements.add(new CodegenStatementIfRefNullReturnNull(ref));
        return this;
    }

    public CodegenBlock declareVarEventPerStreamUnd(Class clazz, int streamNum) {
        this.checkClosed();
        this.statements.add(new CodegenStatementDeclareVarEventPerStreamUnd(clazz, streamNum));
        return this;
    }

    public CodegenBlock blockReturn(CodegenExpression expression) {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementReturnExpression(expression));
        return this.parentWBlock.getParent();
    }

    public CodegenBlock blockEnd() {
        if (this.parentWBlock == null) {
            throw new IllegalStateException("No codeblock parent, use 'methodReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        return this.parentWBlock.getParent();
    }

    public String methodReturn(CodegenExpression expression) {
        if (this.parentMethod == null) {
            throw new IllegalStateException("No method parent, use 'blockReturn... instead");
        }
        this.checkClosed();
        this.closed = true;
        this.statements.add(new CodegenStatementReturnExpression(expression));
        return this.parentMethod.getMethodName();
    }

    public void render(StringBuilder builder, Map<Class, String> imports) {
        for (CodegenStatement statement : this.statements) {
            statement.render(builder, imports);
        }
    }

    public void mergeClasses(Set<Class> classes) {
        for (CodegenStatement statement : this.statements) {
            statement.mergeClasses(classes);
        }
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Code block already closed");
        }
    }
}

