/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.core.CodeGenerationIDGenerator;
import com.espertech.esper.codegen.core.CodegenBlock;
import com.espertech.esper.codegen.core.CodegenMember;
import com.espertech.esper.codegen.core.CodegenMethod;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodegenContext {
    private final List<CodegenMember> members = new ArrayList<CodegenMember>();
    private final List<CodegenMethod> methods = new ArrayList<CodegenMethod>();

    public void addMember(String memberName, Class clazz, Object object) {
        this.members.add(new CodegenMember(memberName, clazz, object));
    }

    public void addMember(String memberName, Class clazz, Class optionalTypeParam, Object object) {
        this.members.add(new CodegenMember(memberName, clazz, optionalTypeParam, object));
    }

    public void addMember(CodegenMember entry) {
        this.members.add(entry);
    }

    public CodegenMember makeMember(Class clazz, Object object) {
        String memberName = CodeGenerationIDGenerator.generateMember();
        return new CodegenMember(memberName, clazz, object);
    }

    public CodegenMember makeAddMember(Class clazz, Object object) {
        CodegenMember member = this.makeMember(clazz, object);
        this.members.add(member);
        return member;
    }

    public CodegenMember makeMember(Class clazz, Class optionalTypeParam, Object object) {
        String memberName = CodeGenerationIDGenerator.generateMember();
        return new CodegenMember(memberName, clazz, optionalTypeParam, object);
    }

    public CodegenBlock addMethod(Class returnType, Class paramType, String paramName, Class generator) {
        String methodName = CodeGenerationIDGenerator.generateMethod();
        CodegenMethod method = new CodegenMethod(returnType, methodName, Collections.singletonList(new CodegenNamedParam(paramType, paramName)), this.getGeneratorDetail(generator));
        this.methods.add(method);
        return method.statements();
    }

    public CodegenBlock addMethod(Class returnType, Class generator) {
        String methodName = CodeGenerationIDGenerator.generateMethod();
        CodegenMethod method = new CodegenMethod(returnType, methodName, Collections.emptyList(), this.getGeneratorDetail(generator));
        this.methods.add(method);
        return method.statements();
    }

    public List<CodegenMember> getMembers() {
        return this.members;
    }

    public List<CodegenMethod> getMethods() {
        return this.methods;
    }

    private String getGeneratorDetail(Class generator) {
        String fullClassName = Thread.currentThread().getStackTrace()[3].getClassName();
        String className = fullClassName.substring(fullClassName.lastIndexOf(".") + 1);
        String methodName = Thread.currentThread().getStackTrace()[3].getMethodName();
        int lineNumber = Thread.currentThread().getStackTrace()[3].getLineNumber();
        return generator.getName() + " --- " + className + "." + methodName + "():" + lineNumber;
    }
}

