/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.codegen.core;

import com.espertech.esper.codegen.core.CodeGenerationHelper;
import com.espertech.esper.codegen.core.CodegenBlock;
import com.espertech.esper.codegen.core.CodegenNamedParam;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodegenMethod {
    private final Class returnType;
    private final String methodName;
    private final List<CodegenNamedParam> params;
    private final String optionalComment;
    private CodegenBlock block;

    public CodegenMethod(Class returnType, String methodName, List<CodegenNamedParam> params, String optionalComment) {
        this.returnType = returnType;
        this.methodName = methodName;
        this.params = params;
        this.optionalComment = optionalComment;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<CodegenNamedParam> getParams() {
        return this.params;
    }

    public CodegenBlock statements() {
        this.allocateBlock();
        return this.block;
    }

    public void mergeClasses(Set<Class> classes) {
        this.allocateBlock();
        classes.add(this.returnType);
        this.block.mergeClasses(classes);
        for (CodegenNamedParam param : this.params) {
            param.mergeClasses(classes);
        }
    }

    public void render(StringBuilder builder, Map<Class, String> imports, boolean isPublic) {
        this.allocateBlock();
        if (this.optionalComment != null) {
            builder.append("// ").append(this.optionalComment).append("\n");
        }
        if (isPublic) {
            builder.append("public ");
        }
        CodeGenerationHelper.appendClassName(builder, this.returnType, null, imports);
        builder.append(" ").append(this.methodName).append("(");
        CodegenNamedParam.render(builder, this.params, imports);
        builder.append("){\n");
        this.block.render(builder, imports);
        builder.append("}\n");
    }

    private void allocateBlock() {
        if (this.block == null) {
            this.block = new CodegenBlock(this);
        }
    }
}

