/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.activator.ViewableActivationResult;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryBase;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryCreateWindowResult;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryResult;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactorySelect;
import com.espertech.esper.core.context.factory.StatementAgentInstancePostLoad;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.context.util.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.core.context.util.StatementAgentInstanceUtil;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodCreateWindow;
import com.espertech.esper.core.start.EPStatementStartMethodHelperAssignExpr;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.named.NamedWindowProcessorInstance;
import com.espertech.esper.epl.named.NamedWindowRootViewInstance;
import com.espertech.esper.epl.named.NamedWindowTailViewInstance;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.view.OutputProcessViewBase;
import com.espertech.esper.epl.view.OutputProcessViewFactory;
import com.espertech.esper.epl.virtualdw.VirtualDWView;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewServiceCreateResult;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementAgentInstanceFactoryCreateWindow
extends StatementAgentInstanceFactoryBase {
    private static final Logger log = LoggerFactory.getLogger(EPStatementStartMethodCreateWindow.class);
    protected final StatementContext statementContext;
    protected final StatementSpecCompiled statementSpec;
    protected final EPServicesContext services;
    protected final ViewableActivator activator;
    protected final ViewFactoryChain unmaterializedViewChain;
    protected final ResultSetProcessorFactoryDesc resultSetProcessorPrototype;
    protected final OutputProcessViewFactory outputProcessViewFactory;
    protected final boolean isRecoveringStatement;

    public StatementAgentInstanceFactoryCreateWindow(StatementContext statementContext, StatementSpecCompiled statementSpec, EPServicesContext services, ViewableActivator activator, ViewFactoryChain unmaterializedViewChain, ResultSetProcessorFactoryDesc resultSetProcessorPrototype, OutputProcessViewFactory outputProcessViewFactory, boolean recoveringStatement) {
        super(statementContext.getAnnotations());
        this.statementContext = statementContext;
        this.statementSpec = statementSpec;
        this.services = services;
        this.activator = activator;
        this.unmaterializedViewChain = unmaterializedViewChain;
        this.resultSetProcessorPrototype = resultSetProcessorPrototype;
        this.outputProcessViewFactory = outputProcessViewFactory;
        this.isRecoveringStatement = recoveringStatement;
    }

    @Override
    public StatementAgentInstanceFactoryCreateWindowResult newContextInternal(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        StatementAgentInstancePostLoad postLoad;
        Viewable finalView;
        Viewable topView;
        NamedWindowProcessorInstance processorInstance;
        Viewable eventStreamParentViewable;
        ViewableActivationResult viewableActivationResult;
        ArrayList<StopCallback> stopCallbacks;
        block12: {
            stopCallbacks = new ArrayList<StopCallback>();
            String windowName = this.statementSpec.getCreateWindowDesc().getWindowName();
            try {
                viewableActivationResult = this.activator.activate(agentInstanceContext, false, isRecoveringResilient);
                stopCallbacks.add(viewableActivationResult.getStopCallback());
                eventStreamParentViewable = viewableActivationResult.getViewable();
                NamedWindowProcessor processor = this.services.getNamedWindowMgmtService().getProcessor(windowName);
                if (processor == null) {
                    throw new RuntimeException("Failed to obtain named window processor for named window '" + windowName + "'");
                }
                processorInstance = processor.addInstance(agentInstanceContext);
                NamedWindowRootViewInstance rootView = processorInstance.getRootViewInstance();
                eventStreamParentViewable.addView(rootView);
                AgentInstanceViewFactoryChainContext viewFactoryChainContext = new AgentInstanceViewFactoryChainContext(agentInstanceContext, true, null, null);
                ViewServiceCreateResult createResult = this.services.getViewService().createViews(rootView, this.unmaterializedViewChain.getViewFactoryChain(), viewFactoryChainContext, false);
                topView = createResult.getTopViewable();
                finalView = createResult.getFinalViewable();
                StatementAgentInstanceFactorySelect.addViewStopCallback(stopCallbacks, createResult.getNewViews());
                StopCallback envStopCallback = null;
                if (finalView instanceof VirtualDWView) {
                    final String objectName = "/virtualdw/" + windowName;
                    final VirtualDWView virtualDWView = (VirtualDWView)((Object)finalView);
                    try {
                        this.services.getEngineEnvContext().bind(objectName, (Object)virtualDWView.getVirtualDataWindow());
                    }
                    catch (NamingException e) {
                        throw new ViewProcessingException("Invalid name for adding to context:" + e.getMessage(), e);
                    }
                    envStopCallback = new StopCallback(){

                        @Override
                        public void stop() {
                            try {
                                virtualDWView.destroy();
                                StatementAgentInstanceFactoryCreateWindow.this.services.getEngineEnvContext().unbind(objectName);
                            }
                            catch (NamingException namingException) {
                                // empty catch block
                            }
                        }
                    };
                }
                final StopCallback environmentStopCallback = envStopCallback;
                final String contextName = processor.getContextName();
                final int agentInstanceId = agentInstanceContext.getAgentInstanceId();
                StopCallback allInOneStopMethod = new StopCallback(){

                    @Override
                    public void stop() {
                        String windowName = StatementAgentInstanceFactoryCreateWindow.this.statementSpec.getCreateWindowDesc().getWindowName();
                        NamedWindowProcessor processor = StatementAgentInstanceFactoryCreateWindow.this.services.getNamedWindowMgmtService().getProcessor(windowName);
                        if (processor == null) {
                            log.warn("Named window processor by name '" + windowName + "' has not been found");
                        } else {
                            NamedWindowProcessorInstance instance = processor.getProcessorInstanceAllowUnpartitioned(agentInstanceId);
                            if (instance != null) {
                                if (contextName != null) {
                                    instance.destroy();
                                } else {
                                    instance.stop();
                                }
                            }
                        }
                        if (environmentStopCallback != null) {
                            environmentStopCallback.stop();
                        }
                    }
                };
                stopCallbacks.add(allInOneStopMethod);
                NamedWindowTailViewInstance tailView = processorInstance.getTailViewInstance();
                finalView.addView(tailView);
                finalView = tailView;
                ResultSetProcessor resultSetProcessor = EPStatementStartMethodHelperAssignExpr.getAssignResultSetProcessor(agentInstanceContext, this.resultSetProcessorPrototype, false, null, false);
                OutputProcessViewBase outputView = this.outputProcessViewFactory.makeView(resultSetProcessor, agentInstanceContext);
                finalView.addView(outputView);
                finalView = outputView;
                postLoad = processorInstance.getPostLoad();
                if (!this.statementSpec.getCreateWindowDesc().isInsert() || this.isRecoveringStatement || isRecoveringResilient) break block12;
                String insertFromWindow = this.statementSpec.getCreateWindowDesc().getInsertFromWindow();
                NamedWindowProcessor namedWindowProcessor = this.services.getNamedWindowMgmtService().getProcessor(insertFromWindow);
                NamedWindowProcessorInstance sourceWindowInstances = namedWindowProcessor.getProcessorInstance(agentInstanceContext);
                ArrayList<EventBean> events = new ArrayList<EventBean>();
                if (this.statementSpec.getCreateWindowDesc().getInsertFilter() != null) {
                    EventBean[] eventsPerStream = new EventBean[1];
                    ExprEvaluator filter = this.statementSpec.getCreateWindowDesc().getInsertFilter().getExprEvaluator();
                    Iterator<EventBean> it = sourceWindowInstances.getTailViewInstance().iterator();
                    while (it.hasNext()) {
                        EventBean candidate;
                        eventsPerStream[0] = candidate = it.next();
                        Boolean result = (Boolean)filter.evaluate(eventsPerStream, true, agentInstanceContext);
                        if (result == null || !result.booleanValue()) continue;
                        events.add(candidate);
                    }
                } else {
                    Iterator<EventBean> it = sourceWindowInstances.getTailViewInstance().iterator();
                    while (it.hasNext()) {
                        events.add(it.next());
                    }
                }
                if (events.size() > 0) {
                    EventType rootViewType = rootView.getEventType();
                    EventBean[] convertedEvents = this.services.getEventAdapterService().typeCast(events, rootViewType);
                    rootView.update(convertedEvents, null);
                }
            }
            catch (RuntimeException ex) {
                StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
                StatementAgentInstanceUtil.stopSafe(stopCallback, this.statementContext);
                throw ex;
            }
        }
        StatementAgentInstanceFactoryCreateWindowResult createWindowResult = new StatementAgentInstanceFactoryCreateWindowResult(finalView, null, agentInstanceContext, eventStreamParentViewable, postLoad, topView, processorInstance, viewableActivationResult);
        if (this.statementContext.getStatementExtensionServicesContext() != null) {
            this.statementContext.getStatementExtensionServicesContext().contributeStopCallback(createWindowResult, stopCallbacks);
        }
        log.debug(".start Statement start completed");
        StopCallback stopCallback = StatementAgentInstanceUtil.getStopCallback(stopCallbacks, agentInstanceContext);
        createWindowResult.setStopCallback(stopCallback);
        return createWindowResult;
    }

    @Override
    public void assignExpressions(StatementAgentInstanceFactoryResult result) {
    }

    @Override
    public void unassignExpressions() {
    }
}

