/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.core.context.activator.ViewableActivator;
import com.espertech.esper.core.context.factory.StatementAgentInstanceFactoryOnTriggerBase;
import com.espertech.esper.core.context.subselect.SubSelectStrategyCollection;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPStatementStartMethodOnTriggerItem;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorFactoryDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.table.mgmt.TableStateInstance;
import com.espertech.esper.util.StopCallback;
import com.espertech.esper.view.View;
import com.espertech.esper.view.internal.RouteResultView;
import java.util.List;

public class StatementAgentInstanceFactoryOnTriggerSplit
extends StatementAgentInstanceFactoryOnTriggerBase {
    private final EPStatementStartMethodOnTriggerItem[] items;
    private final EventType activatorResultEventType;

    public StatementAgentInstanceFactoryOnTriggerSplit(StatementContext statementContext, StatementSpecCompiled statementSpec, EPServicesContext services, ViewableActivator activator, SubSelectStrategyCollection subSelectStrategyCollection, EPStatementStartMethodOnTriggerItem[] items, EventType activatorResultEventType) {
        super(statementContext, statementSpec, services, activator, subSelectStrategyCollection);
        this.items = items;
        this.activatorResultEventType = activatorResultEventType;
    }

    @Override
    public StatementAgentInstanceFactoryOnTriggerBase.OnExprViewResult determineOnExprView(AgentInstanceContext agentInstanceContext, List<StopCallback> stopCallbacks, boolean isRecoveringReslient) {
        ResultSetProcessor[] processors = new ResultSetProcessor[this.items.length];
        for (int i = 0; i < processors.length; ++i) {
            ResultSetProcessor processor;
            ResultSetProcessorFactoryDesc factory = this.items[i].getFactoryDesc();
            processors[i] = processor = factory.getResultSetProcessorFactory().instantiate(null, null, agentInstanceContext);
        }
        TableStateInstance[] tableStateInstances = new TableStateInstance[processors.length];
        for (int i = 0; i < this.items.length; ++i) {
            String tableName = this.items[i].getInsertIntoTableNames();
            if (tableName == null) continue;
            tableStateInstances[i] = agentInstanceContext.getStatementContext().getTableService().getState(tableName, agentInstanceContext.getAgentInstanceId());
        }
        ExprEvaluator[] whereClauseEvals = new ExprEvaluator[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            whereClauseEvals[i] = this.items[i].getWhereClause() == null ? null : this.items[i].getWhereClause().getExprEvaluator();
        }
        OnTriggerSplitStreamDesc desc = (OnTriggerSplitStreamDesc)this.statementSpec.getOnTriggerDesc();
        RouteResultView view = new RouteResultView(desc.isFirst(), this.activatorResultEventType, this.statementContext.getEpStatementHandle(), this.services.getInternalEventRouter(), tableStateInstances, this.items, processors, whereClauseEvals, agentInstanceContext);
        return new StatementAgentInstanceFactoryOnTriggerBase.OnExprViewResult(view, null);
    }

    @Override
    public View determineFinalOutputView(AgentInstanceContext agentInstanceContext, View onExprView) {
        return onExprView;
    }
}

