/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.context.mgr;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.core.context.mgr.ContextControllerPartitionedInstanceCreateCallback;
import com.espertech.esper.core.context.mgr.ContextInternalFilterAddendum;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.EPStatementHandleCallback;
import com.espertech.esper.epl.spec.ContextDetailPartitionItem;
import com.espertech.esper.filter.FilterHandleCallback;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.filter.FilterServiceEntry;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetParam;
import java.util.Collection;

public class ContextControllerPartitionedFilterCallback
implements FilterHandleCallback {
    private final AgentInstanceContext agentInstanceContextCreateContext;
    private final EventPropertyGetter[] getters;
    private final ContextControllerPartitionedInstanceCreateCallback callback;
    private final EPStatementHandleCallback filterHandle;
    private final FilterServiceEntry filterServiceEntry;

    public ContextControllerPartitionedFilterCallback(EPServicesContext servicesContext, AgentInstanceContext agentInstanceContextCreateContext, ContextDetailPartitionItem partitionItem, ContextControllerPartitionedInstanceCreateCallback callback, ContextInternalFilterAddendum filterAddendum) {
        this.agentInstanceContextCreateContext = agentInstanceContextCreateContext;
        this.callback = callback;
        this.filterHandle = new EPStatementHandleCallback(agentInstanceContextCreateContext.getEpStatementAgentInstanceHandle(), this);
        this.getters = new EventPropertyGetter[partitionItem.getPropertyNames().size()];
        for (int i = 0; i < partitionItem.getPropertyNames().size(); ++i) {
            EventPropertyGetter getter;
            String propertyName = partitionItem.getPropertyNames().get(i);
            this.getters[i] = getter = partitionItem.getFilterSpecCompiled().getFilterForEventType().getGetter(propertyName);
        }
        FilterValueSetParam[][] addendum = filterAddendum != null ? filterAddendum.getFilterAddendum(partitionItem.getFilterSpecCompiled()) : (FilterValueSetParam[][])null;
        FilterValueSet filterValueSet = partitionItem.getFilterSpecCompiled().getValueSet(null, null, addendum);
        this.filterServiceEntry = servicesContext.getFilterService().add(filterValueSet, this.filterHandle);
        long filtersVersion = servicesContext.getFilterService().getFiltersVersion();
        agentInstanceContextCreateContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    @Override
    public void matchFound(EventBean theEvent, Collection<FilterHandleCallback> allStmtMatches) {
        Object key;
        if (this.getters.length > 1) {
            Object[] keys = new Object[this.getters.length];
            for (int i = 0; i < keys.length; ++i) {
                keys[i] = this.getters[i].get(theEvent);
            }
            key = new MultiKeyUntyped(keys);
        } else {
            key = this.getters[0].get(theEvent);
        }
        this.callback.create(key, theEvent);
    }

    @Override
    public boolean isSubSelect() {
        return false;
    }

    @Override
    public int getStatementId() {
        return this.agentInstanceContextCreateContext.getStatementContext().getStatementId();
    }

    public void destroy(FilterService filterService) {
        filterService.remove(this.filterHandle, this.filterServiceEntry);
        long filtersVersion = this.agentInstanceContextCreateContext.getStatementContext().getFilterService().getFiltersVersion();
        this.agentInstanceContextCreateContext.getEpStatementAgentInstanceHandle().getStatementFilterVersion().setStmtFilterVersion(filtersVersion);
    }

    public EPStatementHandleCallback getFilterHandle() {
        return this.filterHandle;
    }
}

