/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.deploy;

import com.espertech.esper.client.ConfigurationEngineDefaults;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EPServiceProviderIsolated;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.deploy.DeploymentActionException;
import com.espertech.esper.client.deploy.DeploymentException;
import com.espertech.esper.client.deploy.DeploymentInformation;
import com.espertech.esper.client.deploy.DeploymentInformationItem;
import com.espertech.esper.client.deploy.DeploymentItemException;
import com.espertech.esper.client.deploy.DeploymentLockException;
import com.espertech.esper.client.deploy.DeploymentNotFoundException;
import com.espertech.esper.client.deploy.DeploymentOptions;
import com.espertech.esper.client.deploy.DeploymentOrder;
import com.espertech.esper.client.deploy.DeploymentOrderException;
import com.espertech.esper.client.deploy.DeploymentOrderOptions;
import com.espertech.esper.client.deploy.DeploymentResult;
import com.espertech.esper.client.deploy.DeploymentState;
import com.espertech.esper.client.deploy.DeploymentStateException;
import com.espertech.esper.client.deploy.Module;
import com.espertech.esper.client.deploy.ModuleItem;
import com.espertech.esper.client.deploy.ParseException;
import com.espertech.esper.client.deploy.StatementDeploymentContext;
import com.espertech.esper.client.deploy.UndeploymentOptions;
import com.espertech.esper.client.deploy.UndeploymentResult;
import com.espertech.esper.core.deploy.DeploymentStateService;
import com.espertech.esper.core.deploy.EPDeploymentAdminSPI;
import com.espertech.esper.core.deploy.EPLModuleUtil;
import com.espertech.esper.core.service.EPAdministratorSPI;
import com.espertech.esper.core.service.StatementEventTypeRef;
import com.espertech.esper.core.service.StatementIsolationService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.filter.FilterService;
import com.espertech.esper.util.DependencyGraph;
import com.espertech.esper.util.ManagedReadWriteLock;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TimeZone;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPDeploymentAdminImpl
implements EPDeploymentAdminSPI {
    private static Logger log = LoggerFactory.getLogger(EPDeploymentAdminImpl.class);
    private final EPAdministratorSPI epService;
    private final ManagedReadWriteLock eventProcessingRWLock;
    private final DeploymentStateService deploymentStateService;
    private final StatementEventTypeRef statementEventTypeRef;
    private final EventAdapterService eventAdapterService;
    private final StatementIsolationService statementIsolationService;
    private final FilterService filterService;
    private final TimeZone timeZone;
    private final ConfigurationEngineDefaults.ExceptionHandling.UndeployRethrowPolicy undeployRethrowPolicy;

    public EPDeploymentAdminImpl(EPAdministratorSPI epService, ManagedReadWriteLock eventProcessingRWLock, DeploymentStateService deploymentStateService, StatementEventTypeRef statementEventTypeRef, EventAdapterService eventAdapterService, StatementIsolationService statementIsolationService, FilterService filterService, TimeZone timeZone, ConfigurationEngineDefaults.ExceptionHandling.UndeployRethrowPolicy undeployRethrowPolicy) {
        this.epService = epService;
        this.eventProcessingRWLock = eventProcessingRWLock;
        this.deploymentStateService = deploymentStateService;
        this.statementEventTypeRef = statementEventTypeRef;
        this.eventAdapterService = eventAdapterService;
        this.statementIsolationService = statementIsolationService;
        this.filterService = filterService;
        this.timeZone = timeZone;
        this.undeployRethrowPolicy = undeployRethrowPolicy;
    }

    @Override
    public Module read(InputStream stream, String uri) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading module from input stream");
        }
        return EPLModuleUtil.readInternal(stream, uri);
    }

    @Override
    public Module read(File file) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource '" + file.getAbsolutePath() + "'");
        }
        return EPLModuleUtil.readFile(file);
    }

    @Override
    public Module read(URL url) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource from url: " + url.toString());
        }
        return EPLModuleUtil.readInternal(url.openStream(), url.toString());
    }

    @Override
    public Module read(String resource) throws IOException, ParseException {
        if (log.isDebugEnabled()) {
            log.debug("Reading resource '" + resource + "'");
        }
        return EPLModuleUtil.readResource(resource, this.eventAdapterService.getEngineImportService());
    }

    @Override
    public synchronized DeploymentResult deploy(Module module, DeploymentOptions options, String assignedDeploymentId) throws DeploymentActionException, DeploymentLockException, InterruptedException {
        if (this.deploymentStateService.getDeployment(assignedDeploymentId) != null) {
            throw new IllegalArgumentException("Assigned deployment id '" + assignedDeploymentId + "' is already in use");
        }
        return this.deployInternal(module, options, assignedDeploymentId, Calendar.getInstance(this.timeZone));
    }

    @Override
    public synchronized DeploymentResult deploy(Module module, DeploymentOptions options) throws DeploymentActionException, DeploymentLockException, InterruptedException {
        String deploymentId = this.deploymentStateService.nextDeploymentId();
        return this.deployInternal(module, options, deploymentId, Calendar.getInstance(this.timeZone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentResult deployInternal(Module module, DeploymentOptions options, String deploymentId, Calendar addedDate) throws DeploymentActionException, DeploymentLockException, InterruptedException {
        if (options == null) {
            options = new DeploymentOptions();
        }
        options.getDeploymentLockStrategy().acquire(this.eventProcessingRWLock);
        try {
            DeploymentResult deploymentResult = this.deployInternalLockTaken(module, options, deploymentId, addedDate);
            return deploymentResult;
        }
        finally {
            options.getDeploymentLockStrategy().release(this.eventProcessingRWLock);
        }
    }

    private DeploymentResult deployInternalLockTaken(Module module, DeploymentOptions options, String deploymentId, Calendar addedDate) throws DeploymentActionException {
        ArrayList<DeploymentItemException> exceptions;
        List<String> imports;
        if (log.isDebugEnabled()) {
            log.debug("Deploying module " + module);
        }
        if (module.getImports() != null) {
            for (String string : module.getImports()) {
                if (log.isDebugEnabled()) {
                    log.debug("Adding import " + string);
                }
                this.epService.getConfiguration().addImport(string);
            }
            imports = new ArrayList<String>(module.getImports());
        } else {
            imports = Collections.emptyList();
        }
        if (options.isCompile()) {
            exceptions = new ArrayList<DeploymentItemException>();
            for (ModuleItem item : module.getItems()) {
                if (item.isCommentOnly()) continue;
                try {
                    this.epService.compileEPL(item.getExpression());
                }
                catch (RuntimeException ex) {
                    exceptions.add(new DeploymentItemException(ex.getMessage(), item.getExpression(), ex, item.getLineNumber()));
                }
            }
            if (!exceptions.isEmpty()) {
                throw this.buildException("Compilation failed", module, exceptions);
            }
        }
        if (options.isCompileOnly()) {
            return null;
        }
        exceptions = new ArrayList();
        ArrayList<DeploymentInformationItem> arrayList = new ArrayList<DeploymentInformationItem>();
        ArrayList<EPStatement> statements = new ArrayList<EPStatement>();
        HashSet<String> eventTypesReferenced = new HashSet<String>();
        for (ModuleItem item : module.getItems()) {
            if (item.isCommentOnly()) continue;
            String statementName = null;
            Object userObject = null;
            if (options.getStatementNameResolver() != null || options.getStatementUserObjectResolver() != null) {
                StatementDeploymentContext ctx = new StatementDeploymentContext(item.getExpression(), module, item, deploymentId);
                statementName = options.getStatementNameResolver() != null ? options.getStatementNameResolver().getStatementName(ctx) : null;
                userObject = options.getStatementUserObjectResolver() != null ? options.getStatementUserObjectResolver().getUserObject(ctx) : null;
            }
            try {
                EPStatement stmt;
                if (options.getIsolatedServiceProvider() == null) {
                    stmt = this.epService.createEPL(item.getExpression(), statementName, userObject);
                } else {
                    EPServiceProviderIsolated unit = this.statementIsolationService.getIsolationUnit(options.getIsolatedServiceProvider(), -1);
                    stmt = unit.getEPAdministrator().createEPL(item.getExpression(), statementName, userObject);
                }
                arrayList.add(new DeploymentInformationItem(stmt.getName(), stmt.getText()));
                statements.add(stmt);
                String[] types = this.statementEventTypeRef.getTypesForStatementName(stmt.getName());
                if (types == null) continue;
                eventTypesReferenced.addAll(Arrays.asList(types));
            }
            catch (EPException ex) {
                exceptions.add(new DeploymentItemException(ex.getMessage(), item.getExpression(), ex, item.getLineNumber()));
                if (!options.isFailFast()) continue;
                break;
            }
        }
        if (!exceptions.isEmpty()) {
            if (options.isRollbackOnFail()) {
                log.debug("Rolling back intermediate statements for deployment");
                for (EPStatement stmt : statements) {
                    try {
                        stmt.destroy();
                    }
                    catch (Exception ex) {
                        log.debug("Failed to destroy created statement during rollback: " + ex.getMessage(), (Throwable)ex);
                    }
                }
                EPLModuleUtil.undeployTypes(eventTypesReferenced, this.statementEventTypeRef, this.eventAdapterService, this.filterService);
            }
            Object text = "Deployment failed";
            if (options.isValidateOnly()) {
                text = "Validation failed";
            }
            throw this.buildException((String)text, module, exceptions);
        }
        if (options.isValidateOnly()) {
            log.debug("Rolling back created statements for validate-only");
            for (EPStatement stmt : statements) {
                try {
                    stmt.destroy();
                }
                catch (Exception ex) {
                    log.debug("Failed to destroy created statement during rollback: " + ex.getMessage(), (Throwable)ex);
                }
            }
            EPLModuleUtil.undeployTypes(eventTypesReferenced, this.statementEventTypeRef, this.eventAdapterService, this.filterService);
            return null;
        }
        DeploymentInformationItem[] deploymentInfoArr = arrayList.toArray(new DeploymentInformationItem[arrayList.size()]);
        DeploymentInformation desc = new DeploymentInformation(deploymentId, module, addedDate, Calendar.getInstance(this.timeZone), deploymentInfoArr, DeploymentState.DEPLOYED);
        this.deploymentStateService.addUpdateDeployment(desc);
        if (log.isDebugEnabled()) {
            log.debug("Module " + module + " was successfully deployed.");
        }
        return new DeploymentResult(desc.getDeploymentId(), Collections.unmodifiableList(statements), imports);
    }

    private DeploymentActionException buildException(String msg, Module module, List<DeploymentItemException> exceptions) {
        String message = msg;
        if (module.getName() != null) {
            message = message + " in module '" + module.getName() + "'";
        }
        if (module.getUri() != null) {
            message = message + " in module url '" + module.getUri() + "'";
        }
        if (exceptions.size() > 0) {
            message = message + " in expression '" + this.getAbbreviated(exceptions.get(0).getExpression()) + "' : " + exceptions.get(0).getMessage();
        }
        return new DeploymentActionException(message, exceptions);
    }

    private String getAbbreviated(String expression) {
        if (expression.length() < 60) {
            return this.replaceNewline(expression);
        }
        String subtext = expression.substring(0, 50) + "...(" + expression.length() + " chars)";
        return this.replaceNewline(subtext);
    }

    private String replaceNewline(String text) {
        text = text.replaceAll("\\n", " ");
        text = text.replaceAll("\\t", " ");
        text = text.replaceAll("\\r", " ");
        return text;
    }

    @Override
    public Module parse(String eplModuleText) throws IOException, ParseException {
        return EPLModuleUtil.parseInternal(eplModuleText, null);
    }

    @Override
    public synchronized UndeploymentResult undeployRemove(String deploymentId) throws DeploymentNotFoundException {
        return this.undeployRemoveInternal(deploymentId, new UndeploymentOptions());
    }

    @Override
    public synchronized UndeploymentResult undeployRemove(String deploymentId, UndeploymentOptions undeploymentOptions) throws DeploymentNotFoundException {
        return this.undeployRemoveInternal(deploymentId, undeploymentOptions == null ? new UndeploymentOptions() : undeploymentOptions);
    }

    @Override
    public synchronized UndeploymentResult undeploy(String deploymentId) throws DeploymentStateException, DeploymentNotFoundException, DeploymentLockException, InterruptedException {
        return this.undeployInternal(deploymentId, new UndeploymentOptions());
    }

    @Override
    public synchronized UndeploymentResult undeploy(String deploymentId, UndeploymentOptions undeploymentOptions) throws DeploymentException, InterruptedException {
        return this.undeployInternal(deploymentId, undeploymentOptions == null ? new UndeploymentOptions() : undeploymentOptions);
    }

    @Override
    public synchronized String[] getDeployments() {
        return this.deploymentStateService.getDeployments();
    }

    @Override
    public synchronized DeploymentInformation getDeployment(String deploymentId) {
        return this.deploymentStateService.getDeployment(deploymentId);
    }

    @Override
    public synchronized DeploymentInformation[] getDeploymentInformation() {
        return this.deploymentStateService.getAllDeployments();
    }

    @Override
    public synchronized DeploymentOrder getDeploymentOrder(Collection<Module> modules, DeploymentOrderOptions options) throws DeploymentOrderException {
        Stack<Integer> circular;
        if (options == null) {
            options = new DeploymentOrderOptions();
        }
        String[] deployments = this.deploymentStateService.getDeployments();
        ArrayList<Module> proposedModules = new ArrayList<Module>();
        proposedModules.addAll(modules);
        HashSet<String> availableModuleNames = new HashSet<String>();
        for (Module module : proposedModules) {
            if (module.getName() == null) continue;
            availableModuleNames.add(module.getName());
        }
        HashMap<String, HashSet<String>> usesPerModuleName = new HashMap<String, HashSet<String>>();
        for (String deployment : deployments) {
            DeploymentInformation info = this.deploymentStateService.getDeployment(deployment);
            if (info == null || info.getModule().getName() == null || info.getModule().getUses() == null) continue;
            HashSet<String> usesSet = (HashSet<String>)usesPerModuleName.get(info.getModule().getName());
            if (usesSet == null) {
                usesSet = new HashSet<String>();
                usesPerModuleName.put(info.getModule().getName(), usesSet);
            }
            usesSet.addAll(info.getModule().getUses());
        }
        for (Module proposedModule : proposedModules) {
            if (options.isCheckUses() && proposedModule.getUses() != null) {
                for (String uses : proposedModule.getUses()) {
                    if (availableModuleNames.contains(uses) || this.isDeployed(uses)) continue;
                    String message = "Module-dependency not found";
                    if (proposedModule.getName() != null) {
                        message = message + " as declared by module '" + proposedModule.getName() + "'";
                    }
                    message = message + " for uses-declaration '" + uses + "'";
                    throw new DeploymentOrderException(message);
                }
            }
            if (proposedModule.getName() == null || proposedModule.getUses() == null) continue;
            HashSet<String> usesSet = (HashSet<String>)usesPerModuleName.get(proposedModule.getName());
            if (usesSet == null) {
                usesSet = new HashSet<String>();
                usesPerModuleName.put(proposedModule.getName(), usesSet);
            }
            usesSet.addAll(proposedModule.getUses());
        }
        HashMap<String, TreeSet<Integer>> hashMap = new HashMap<String, TreeSet<Integer>>();
        int count = 0;
        for (Module proposedModule : proposedModules) {
            SortedSet<Integer> moduleNumbers = (SortedSet)hashMap.get(proposedModule.getName());
            if (moduleNumbers == null) {
                moduleNumbers = new TreeSet<Integer>();
                hashMap.put(proposedModule.getName(), (TreeSet<Integer>)moduleNumbers);
            }
            moduleNumbers.add(count);
            ++count;
        }
        DependencyGraph graph = new DependencyGraph(proposedModules.size(), false);
        int fromModule = 0;
        for (Module proposedModule : proposedModules) {
            if (proposedModule.getUses() == null || proposedModule.getUses().isEmpty()) {
                ++fromModule;
                continue;
            }
            TreeSet<Integer> dependentModuleNumbers = new TreeSet<Integer>();
            for (String use : proposedModule.getUses()) {
                SortedSet moduleNumbers = (SortedSet)hashMap.get(use);
                if (moduleNumbers == null) continue;
                dependentModuleNumbers.addAll(moduleNumbers);
            }
            dependentModuleNumbers.remove(fromModule);
            graph.addDependency(fromModule, dependentModuleNumbers);
            ++fromModule;
        }
        if (options.isCheckCircularDependency() && (circular = graph.getFirstCircularDependency()) != null) {
            String message = "";
            String delimiter = "";
            Iterator<Object> iterator = circular.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                message = message + delimiter;
                message = message + "module '" + ((Module)proposedModules.get(i)).getName() + "'";
                delimiter = " uses (depends on) ";
            }
            throw new DeploymentOrderException("Circular dependency detected in module uses-relationships: " + message);
        }
        ArrayList<Module> reverseDeployList = new ArrayList<Module>();
        HashSet<Integer> ignoreList = new HashSet<Integer>();
        while (ignoreList.size() < proposedModules.size()) {
            TreeSet<Integer> rootNodes = new TreeSet<Integer>(new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return -1 * o1.compareTo(o2);
                }
            });
            rootNodes.addAll(graph.getRootNodes(ignoreList));
            if (rootNodes.isEmpty()) {
                for (int i = 0; i < proposedModules.size(); ++i) {
                    if (ignoreList.contains(i)) continue;
                    rootNodes.add(i);
                    break;
                }
            }
            for (Integer root : rootNodes) {
                ignoreList.add(root);
                reverseDeployList.add((Module)proposedModules.get(root));
            }
        }
        Collections.reverse(reverseDeployList);
        return new DeploymentOrder(reverseDeployList);
    }

    @Override
    public synchronized boolean isDeployed(String moduleName) {
        DeploymentInformation[] infos = this.deploymentStateService.getAllDeployments();
        if (infos == null) {
            return false;
        }
        for (DeploymentInformation info : infos) {
            if (info.getModule().getName() == null || !info.getModule().getName().equals(moduleName)) continue;
            return info.getState() == DeploymentState.DEPLOYED;
        }
        return false;
    }

    @Override
    public synchronized DeploymentResult readDeploy(InputStream stream, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException, DeploymentLockException, InterruptedException {
        Module module = EPLModuleUtil.readInternal(stream, moduleURI);
        return this.deployQuick(module, moduleURI, moduleArchive, userObject);
    }

    @Override
    public synchronized DeploymentResult readDeploy(String resource, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException, DeploymentLockException, InterruptedException {
        Module module = this.read(resource);
        return this.deployQuick(module, moduleURI, moduleArchive, userObject);
    }

    @Override
    public synchronized DeploymentResult parseDeploy(String eplModuleText) throws IOException, ParseException, DeploymentException, InterruptedException {
        return this.parseDeploy(eplModuleText, null, null, null);
    }

    @Override
    public synchronized DeploymentResult parseDeploy(String buffer, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException, DeploymentLockException, InterruptedException {
        Module module = EPLModuleUtil.parseInternal(buffer, moduleURI);
        return this.deployQuick(module, moduleURI, moduleArchive, userObject);
    }

    @Override
    public synchronized void add(Module module, String assignedDeploymentId) {
        if (this.deploymentStateService.getDeployment(assignedDeploymentId) != null) {
            throw new IllegalArgumentException("Assigned deployment id '" + assignedDeploymentId + "' is already in use");
        }
        this.addInternal(module, assignedDeploymentId);
    }

    @Override
    public synchronized String add(Module module) {
        String deploymentId = this.deploymentStateService.nextDeploymentId();
        this.addInternal(module, deploymentId);
        return deploymentId;
    }

    private void addInternal(Module module, String deploymentId) {
        DeploymentInformation desc = new DeploymentInformation(deploymentId, module, Calendar.getInstance(this.timeZone), Calendar.getInstance(this.timeZone), new DeploymentInformationItem[0], DeploymentState.UNDEPLOYED);
        this.deploymentStateService.addUpdateDeployment(desc);
    }

    @Override
    public synchronized DeploymentResult deploy(String deploymentId, DeploymentOptions options) throws DeploymentNotFoundException, DeploymentStateException, DeploymentOrderException, DeploymentActionException, DeploymentLockException, InterruptedException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        if (info.getState() == DeploymentState.DEPLOYED) {
            throw new DeploymentStateException("Module by deployment id '" + deploymentId + "' is already in deployed state");
        }
        this.getDeploymentOrder(Collections.singletonList(info.getModule()), null);
        return this.deployInternal(info.getModule(), options, deploymentId, info.getAddedDate());
    }

    @Override
    public synchronized void remove(String deploymentId) throws DeploymentStateException, DeploymentNotFoundException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        if (info.getState() == DeploymentState.DEPLOYED) {
            throw new DeploymentStateException("Deployment by id '" + deploymentId + "' is in deployed state, please undeploy first");
        }
        this.deploymentStateService.remove(deploymentId);
    }

    private synchronized UndeploymentResult undeployRemoveInternal(String deploymentId, UndeploymentOptions options) throws DeploymentNotFoundException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        UndeploymentResult result = info.getState() == DeploymentState.DEPLOYED ? this.undeployRemoveInternal(info, options) : new UndeploymentResult(deploymentId, Collections.emptyList());
        this.deploymentStateService.remove(deploymentId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UndeploymentResult undeployInternal(String deploymentId, UndeploymentOptions undeploymentOptions) throws DeploymentStateException, DeploymentNotFoundException, DeploymentLockException, InterruptedException {
        undeploymentOptions.getDeploymentLockStrategy().acquire(this.eventProcessingRWLock);
        try {
            UndeploymentResult undeploymentResult = this.undeployInternalLockTaken(deploymentId, undeploymentOptions);
            return undeploymentResult;
        }
        finally {
            undeploymentOptions.getDeploymentLockStrategy().release(this.eventProcessingRWLock);
        }
    }

    private UndeploymentResult undeployInternalLockTaken(String deploymentId, UndeploymentOptions undeploymentOptions) throws DeploymentStateException, DeploymentNotFoundException {
        DeploymentInformation info = this.deploymentStateService.getDeployment(deploymentId);
        if (info == null) {
            throw new DeploymentNotFoundException("Deployment by id '" + deploymentId + "' could not be found");
        }
        if (info.getState() == DeploymentState.UNDEPLOYED) {
            throw new DeploymentStateException("Deployment by id '" + deploymentId + "' is already in undeployed state");
        }
        UndeploymentResult result = this.undeployRemoveInternal(info, undeploymentOptions);
        DeploymentInformation updated = new DeploymentInformation(deploymentId, info.getModule(), info.getAddedDate(), Calendar.getInstance(this.timeZone), new DeploymentInformationItem[0], DeploymentState.UNDEPLOYED);
        this.deploymentStateService.addUpdateDeployment(updated);
        return result;
    }

    private UndeploymentResult undeployRemoveInternal(DeploymentInformation info, UndeploymentOptions undeploymentOptions) {
        DeploymentInformationItem[] reverted = new DeploymentInformationItem[info.getItems().length];
        for (int i = 0; i < info.getItems().length; ++i) {
            reverted[i] = info.getItems()[info.getItems().length - 1 - i];
        }
        ArrayList<DeploymentInformationItem> revertedStatements = new ArrayList<DeploymentInformationItem>();
        if (undeploymentOptions.isDestroyStatements()) {
            HashSet<String> referencedTypes = new HashSet<String>();
            RuntimeException firstExceptionEncountered = null;
            for (DeploymentInformationItem item : reverted) {
                block7: {
                    EPStatement statement = this.epService.getStatement(item.getStatementName());
                    if (statement == null) {
                        log.debug("Deployment id '" + info.getDeploymentId() + "' statement name '" + item + "' not found");
                        continue;
                    }
                    referencedTypes.addAll(Arrays.asList(this.statementEventTypeRef.getTypesForStatementName(statement.getName())));
                    if (statement.isDestroyed()) continue;
                    try {
                        statement.destroy();
                    }
                    catch (RuntimeException ex) {
                        log.warn("Unexpected exception destroying statement: " + ex.getMessage(), (Throwable)ex);
                        if (firstExceptionEncountered != null) break block7;
                        firstExceptionEncountered = ex;
                    }
                }
                revertedStatements.add(item);
            }
            EPLModuleUtil.undeployTypes(referencedTypes, this.statementEventTypeRef, this.eventAdapterService, this.filterService);
            Collections.reverse(revertedStatements);
            if (firstExceptionEncountered != null && this.undeployRethrowPolicy == ConfigurationEngineDefaults.ExceptionHandling.UndeployRethrowPolicy.RETHROW_FIRST) {
                throw firstExceptionEncountered;
            }
        }
        return new UndeploymentResult(info.getDeploymentId(), revertedStatements);
    }

    private DeploymentResult deployQuick(Module module, String moduleURI, String moduleArchive, Object userObject) throws IOException, ParseException, DeploymentOrderException, DeploymentActionException, DeploymentLockException, InterruptedException {
        module.setUri(moduleURI);
        module.setArchiveName(moduleArchive);
        module.setUserObject(userObject);
        this.getDeploymentOrder(Collections.singletonList(module), null);
        return this.deploy(module, null);
    }
}

