/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.service;

import com.espertech.esper.client.EPServiceProviderIsolated;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.core.service.EPIsolationUnitServices;
import com.espertech.esper.core.service.EPServiceProviderIsolatedImpl;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementIsolationService;
import com.espertech.esper.filter.FilterServiceProvider;
import com.espertech.esper.filter.FilterServiceSPI;
import com.espertech.esper.schedule.SchedulingServiceImpl;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementIsolationServiceImpl
implements StatementIsolationService {
    private static final Logger log = LoggerFactory.getLogger(StatementIsolationServiceImpl.class);
    private final Map<String, EPServiceProviderIsolatedImpl> isolatedProviders = new ConcurrentHashMap<String, EPServiceProviderIsolatedImpl>();
    private EPServicesContext epServicesContext;
    private volatile int currentUnitId = 0;

    public void setEpServicesContext(EPServicesContext epServicesContext) {
        this.epServicesContext = epServicesContext;
    }

    @Override
    public EPServiceProviderIsolated getIsolationUnit(String name, Integer optionalUnitId) {
        EPServiceProviderIsolatedImpl serviceProviderIsolated = this.isolatedProviders.get(name);
        if (serviceProviderIsolated != null) {
            return serviceProviderIsolated;
        }
        FilterServiceSPI filterService = FilterServiceProvider.newService(this.epServicesContext.getConfigSnapshot().getEngineDefaults().getExecution().getFilterServiceProfile(), true);
        SchedulingServiceImpl scheduleService = new SchedulingServiceImpl(this.epServicesContext.getTimeSource());
        EPIsolationUnitServices services = new EPIsolationUnitServices(name, this.currentUnitId, filterService, scheduleService);
        serviceProviderIsolated = new EPServiceProviderIsolatedImpl(name, services, this.epServicesContext, this.isolatedProviders);
        this.isolatedProviders.put(name, serviceProviderIsolated);
        return serviceProviderIsolated;
    }

    @Override
    public void destroy() {
        this.isolatedProviders.clear();
    }

    @Override
    public String[] getIsolationUnitNames() {
        Set<String> keyset = this.isolatedProviders.keySet();
        return keyset.toArray(new String[keyset.size()]);
    }

    @Override
    public void beginIsolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Begin isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    @Override
    public void commitIsolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Completed isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    @Override
    public void rollbackIsolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Failed isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    @Override
    public void beginUnisolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Begin un-isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    @Override
    public void commitUnisolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Completed un-isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    @Override
    public void rollbackUnisolatingStatements(String name, int unitId, EPStatement[] stmt) {
        if (log.isInfoEnabled()) {
            log.info("Failed un-isolating statements " + this.print(stmt) + " unit " + name + " id " + unitId);
        }
    }

    @Override
    public void newStatement(int stmtId, String stmtName, EPIsolationUnitServices isolatedServices) {
        log.info("New statement '" + stmtName + "' unit " + isolatedServices.getName());
    }

    private String print(EPStatement[] stmts) {
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (EPStatement stmt : stmts) {
            buf.append(delimiter);
            buf.append(stmt.getName());
            delimiter = ", ";
        }
        return buf.toString();
    }
}

