/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.start;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.context.ContextPartitionSelector;
import com.espertech.esper.core.service.EPPreparedQueryResult;
import com.espertech.esper.core.service.EPServicesContext;
import com.espertech.esper.core.service.StatementContext;
import com.espertech.esper.core.start.EPPreparedExecuteIUDSingleStreamExec;
import com.espertech.esper.core.start.EPPreparedExecuteMethod;
import com.espertech.esper.core.start.EPPreparedExecuteMethodHelper;
import com.espertech.esper.core.start.EPStatementStartMethodHelperValidate;
import com.espertech.esper.core.start.FireAndForgetInstance;
import com.espertech.esper.core.start.FireAndForgetProcessor;
import com.espertech.esper.core.start.FireAndForgetProcessorFactory;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.join.hint.ExcludePlanHint;
import com.espertech.esper.epl.join.plan.QueryGraph;
import com.espertech.esper.epl.spec.FireAndForgetSpecDelete;
import com.espertech.esper.epl.spec.FireAndForgetSpecUpdate;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.TableQueryStreamSpec;
import com.espertech.esper.util.CollectionUtil;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EPPreparedExecuteIUDSingleStream
implements EPPreparedExecuteMethod {
    private static final Logger QUERY_PLAN_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.queryplan");
    private static final Logger log = LoggerFactory.getLogger(EPPreparedExecuteIUDSingleStream.class);
    protected final StatementSpecCompiled statementSpec;
    protected final FireAndForgetProcessor processor;
    protected final EPServicesContext services;
    protected final EPPreparedExecuteIUDSingleStreamExec executor;
    protected final StatementContext statementContext;
    protected boolean hasTableAccess;

    public abstract EPPreparedExecuteIUDSingleStreamExec getExecutor(QueryGraph var1, String var2) throws ExprValidationException;

    public EPPreparedExecuteIUDSingleStream(StatementSpecCompiled statementSpec, EPServicesContext services, StatementContext statementContext) throws ExprValidationException {
        boolean queryPlanLogging = services.getConfigSnapshot().getEngineDefaults().getLogging().isEnableQueryPlan();
        if (queryPlanLogging) {
            QUERY_PLAN_LOG.info("Query plans for Fire-and-forget query '" + statementContext.getExpression() + "'");
        }
        boolean bl = this.hasTableAccess = statementSpec.getIntoTableSpec() != null || statementSpec.getTableNodes() != null && statementSpec.getTableNodes().length > 0;
        if (statementSpec.getInsertIntoDesc() != null && services.getTableService().getTableMetadata(statementSpec.getInsertIntoDesc().getEventTypeName()) != null) {
            this.hasTableAccess = true;
        }
        if (statementSpec.getFireAndForgetSpec() instanceof FireAndForgetSpecUpdate || statementSpec.getFireAndForgetSpec() instanceof FireAndForgetSpecDelete) {
            this.hasTableAccess |= statementSpec.getStreamSpecs()[0] instanceof TableQueryStreamSpec;
        }
        this.statementSpec = statementSpec;
        this.services = services;
        this.statementContext = statementContext;
        EPPreparedExecuteMethodHelper.validateFAFQuery(statementSpec);
        StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[0];
        this.processor = FireAndForgetProcessorFactory.validateResolveProcessor(streamSpec, services);
        String processorName = this.processor.getNamedWindowOrTableName();
        EventType eventType = this.processor.getEventTypeResultSetProcessor();
        String aliasName = processorName;
        if (streamSpec.getOptionalStreamName() != null) {
            aliasName = streamSpec.getOptionalStreamName();
        }
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{eventType}, new String[]{aliasName}, new boolean[]{true}, services.getEngineURI(), true);
        ExcludePlanHint excludePlanHint = ExcludePlanHint.getHint(typeService.getStreamNames(), statementContext);
        QueryGraph queryGraph = new QueryGraph(1, excludePlanHint, false);
        if (statementSpec.getFilterRootNode() != null) {
            ExprNodeUtility.validateFilterWQueryGraphSafe(queryGraph, statementSpec.getFilterRootNode(), statementContext, typeService);
        }
        EPStatementStartMethodHelperValidate.validateNodes(statementSpec, statementContext, typeService, null);
        this.executor = this.getExecutor(queryGraph, aliasName);
    }

    @Override
    public EventType getEventType() {
        return this.processor.getEventTypeResultSetProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EPPreparedQueryResult execute(ContextPartitionSelector[] contextPartitionSelectors) {
        try {
            FireAndForgetInstance processorInstance;
            ContextPartitionSelector optionalSingleSelector;
            if (contextPartitionSelectors != null && contextPartitionSelectors.length != 1) {
                throw new IllegalArgumentException("Number of context partition selectors must be one");
            }
            ContextPartitionSelector contextPartitionSelector = optionalSingleSelector = contextPartitionSelectors != null && contextPartitionSelectors.length > 0 ? contextPartitionSelectors[0] : null;
            if (this.processor.getContextName() != null && this.statementSpec.getOptionalContextName() != null && !this.processor.getContextName().equals(this.statementSpec.getOptionalContextName())) {
                throw new EPException("Context for named window is '" + this.processor.getContextName() + "' and query specifies context '" + this.statementSpec.getOptionalContextName() + "'");
            }
            if (this.statementSpec.getOptionalContextName() == null && (processorInstance = this.processor.getProcessorInstanceNoContext()) != null) {
                EventBean[] rows = this.executor.execute(processorInstance);
                if (rows != null && rows.length > 0) {
                    this.dispatch();
                }
                EPPreparedQueryResult ePPreparedQueryResult = new EPPreparedQueryResult(this.processor.getEventTypePublic(), rows);
                return ePPreparedQueryResult;
            }
            Collection<Integer> agentInstanceIds = EPPreparedExecuteMethodHelper.getAgentInstanceIds(this.processor, optionalSingleSelector, this.services.getContextManagementService(), this.processor.getContextName());
            if (agentInstanceIds.isEmpty()) {
                EPPreparedQueryResult rows = new EPPreparedQueryResult(this.processor.getEventTypeResultSetProcessor(), CollectionUtil.EVENTBEANARRAY_EMPTY);
                return rows;
            }
            if (agentInstanceIds.size() == 1) {
                int agentInstanceId = agentInstanceIds.iterator().next();
                FireAndForgetInstance processorInstance2 = this.processor.getProcessorInstanceContextById(agentInstanceId);
                EventBean[] rows = this.executor.execute(processorInstance2);
                if (rows.length > 0) {
                    this.dispatch();
                }
                EPPreparedQueryResult ePPreparedQueryResult = new EPPreparedQueryResult(this.processor.getEventTypeResultSetProcessor(), rows);
                return ePPreparedQueryResult;
            }
            ArrayDeque<EventBean> allRows = new ArrayDeque<EventBean>();
            Object object = agentInstanceIds.iterator();
            while (object.hasNext()) {
                int agentInstanceId = object.next();
                FireAndForgetInstance processorInstance3 = this.processor.getProcessorInstanceContextById(agentInstanceId);
                if (processorInstance3 == null) continue;
                EventBean[] rows = this.executor.execute(processorInstance3);
                allRows.addAll(Arrays.asList(rows));
            }
            if (allRows.size() > 0) {
                this.dispatch();
            }
            object = new EPPreparedQueryResult(this.processor.getEventTypeResultSetProcessor(), allRows.toArray(new EventBean[allRows.size()]));
            return object;
        }
        finally {
            if (this.hasTableAccess) {
                this.services.getTableService().getTableExprEvaluatorContext().releaseAcquiredLocks();
            }
        }
    }

    protected void dispatch() {
        this.services.getInternalEventEngineRouteDest().processThreadWorkQueue();
    }
}

