/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.core.thread;

import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineThreadFactory
implements ThreadFactory {
    private static final Logger log = LoggerFactory.getLogger(EngineThreadFactory.class);
    private final String engineURI;
    private final String prefix;
    private final ThreadGroup threadGroup;
    private final int threadPriority;
    private int currThreadCount;

    public EngineThreadFactory(String engineURI, String prefix, ThreadGroup threadGroup, int threadPrio) {
        this.engineURI = engineURI == null ? "default" : engineURI;
        this.prefix = prefix;
        this.threadGroup = threadGroup;
        this.threadPriority = threadPrio;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        String name = "com.espertech.esper." + this.prefix + "-" + this.engineURI + "-" + this.currThreadCount;
        ++this.currThreadCount;
        Thread t = new Thread(this.threadGroup, runnable, name);
        t.setDaemon(true);
        t.setPriority(this.threadPriority);
        if (log.isDebugEnabled()) {
            log.debug("Creating thread '" + name + "' : " + t + " priority " + this.threadPriority);
        }
        return t;
    }
}

