/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.dataflow.core;

import com.espertech.esper.client.dataflow.EPDataFlowInstanceOperatorStat;
import com.espertech.esper.client.dataflow.EPDataFlowInstanceStatistics;
import com.espertech.esper.dataflow.util.OperatorMetadataDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OperatorStatisticsProvider
implements EPDataFlowInstanceStatistics {
    private final long[][] submitCounts;
    private final long[][] cpuDelta;
    private final OperatorMetadataDescriptor[] desc;

    public OperatorStatisticsProvider(Map<Integer, OperatorMetadataDescriptor> operatorMetadata) {
        this.submitCounts = new long[operatorMetadata.size()][];
        this.cpuDelta = new long[operatorMetadata.size()][];
        this.desc = new OperatorMetadataDescriptor[operatorMetadata.size()];
        for (Map.Entry<Integer, OperatorMetadataDescriptor> entry : operatorMetadata.entrySet()) {
            int opNum = entry.getKey();
            this.desc[opNum] = entry.getValue();
            int numPorts = entry.getValue().getOperatorSpec().getOutput().getItems().size();
            this.submitCounts[opNum] = new long[numPorts];
            this.cpuDelta[opNum] = new long[numPorts];
        }
    }

    @Override
    public List<EPDataFlowInstanceOperatorStat> getOperatorStatistics() {
        ArrayList<EPDataFlowInstanceOperatorStat> result = new ArrayList<EPDataFlowInstanceOperatorStat>(this.submitCounts.length);
        for (int i = 0; i < this.submitCounts.length; ++i) {
            long[] submittedPerPort = this.submitCounts[i];
            long submittedOverall = 0L;
            for (long port : submittedPerPort) {
                submittedOverall += port;
            }
            long[] timePerPort = this.cpuDelta[i];
            long timeOverall = 0L;
            for (long port : timePerPort) {
                timeOverall += port;
            }
            OperatorMetadataDescriptor meta = this.desc[i];
            EPDataFlowInstanceOperatorStat stat = new EPDataFlowInstanceOperatorStat(meta.getOperatorName(), meta.getOperatorPrettyPrint(), i, submittedOverall, submittedPerPort, timeOverall, timePerPort);
            result.add(stat);
        }
        return result;
    }

    public void countSubmitPort(int producerOpNum, int portNumber) {
        long[] lArray = this.submitCounts[producerOpNum];
        int n = portNumber;
        lArray[n] = lArray[n] + 1L;
    }

    public void countSubmitPortWithTime(int producerOpNum, int portNumber, long nanoTimeDelta) {
        this.countSubmitPort(producerOpNum, portNumber);
        long[] lArray = this.cpuDelta[producerOpNum];
        int n = portNumber;
        lArray[n] = lArray[n] + nanoTimeDelta;
    }
}

