/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;

public class AggregatorRate
implements AggregationMethod {
    protected final long oneSecondTime;
    protected double accumulator;
    protected long latest;
    protected long oldest;
    protected boolean isSet = false;

    public AggregatorRate(long oneSecondTime) {
        this.oneSecondTime = oneSecondTime;
    }

    @Override
    public void enter(Object value) {
        if (value.getClass().isArray()) {
            this.enterValueArr((Object[])value);
        } else {
            this.enterValueSingle(value);
        }
    }

    @Override
    public void leave(Object value) {
        if (value.getClass().isArray()) {
            this.leaveValueArr((Object[])value);
        } else {
            this.leaveValueSingle(value);
        }
    }

    @Override
    public Object getValue() {
        if (!this.isSet) {
            return null;
        }
        return this.accumulator * (double)this.oneSecondTime / (double)(this.latest - this.oldest);
    }

    @Override
    public void clear() {
        this.accumulator = 0.0;
        this.latest = 0L;
        this.oldest = 0L;
    }

    public long getOneSecondTime() {
        return this.oneSecondTime;
    }

    public double getAccumulator() {
        return this.accumulator;
    }

    public void setAccumulator(double accumulator) {
        this.accumulator = accumulator;
    }

    public long getLatest() {
        return this.latest;
    }

    public void setLatest(long latest) {
        this.latest = latest;
    }

    public long getOldest() {
        return this.oldest;
    }

    public void setOldest(long oldest) {
        this.oldest = oldest;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public void setSet(boolean set) {
        this.isSet = set;
    }

    protected void enterValueSingle(Object value) {
        this.accumulator += 1.0;
        this.latest = (Long)value;
    }

    protected void enterValueArr(Object[] parameters) {
        Number val = (Number)parameters[1];
        this.accumulator += val.doubleValue();
        this.latest = (Long)parameters[0];
    }

    protected void leaveValueArr(Object[] parameters) {
        Number val = (Number)parameters[1];
        this.accumulator -= val.doubleValue();
        this.oldest = (Long)parameters[0];
        if (!this.isSet) {
            this.isSet = true;
        }
    }

    protected void leaveValueSingle(Object value) {
        this.accumulator -= 1.0;
        this.oldest = (Long)value;
        if (!this.isSet) {
            this.isSet = true;
        }
    }
}

