/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.aggregator;

import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.schedule.TimeProvider;
import java.util.ArrayDeque;

public class AggregatorRateEver
implements AggregationMethod {
    protected final long interval;
    protected final long oneSecondTime;
    protected final ArrayDeque<Long> points;
    protected boolean hasLeave = false;
    protected final TimeProvider timeProvider;

    public AggregatorRateEver(long interval, long oneSecondTime, TimeProvider timeProvider) {
        this.interval = interval;
        this.oneSecondTime = oneSecondTime;
        this.timeProvider = timeProvider;
        this.points = new ArrayDeque();
    }

    @Override
    public void clear() {
        this.points.clear();
    }

    @Override
    public void enter(Object object) {
        long timestamp = this.timeProvider.getTime();
        this.points.add(timestamp);
        this.removeFromHead(timestamp);
    }

    @Override
    public void leave(Object object) {
    }

    @Override
    public Object getValue() {
        if (!this.points.isEmpty()) {
            long newest = this.points.getLast();
            this.removeFromHead(newest);
        }
        if (!this.hasLeave) {
            return null;
        }
        if (this.points.isEmpty()) {
            return 0.0;
        }
        return (double)((long)this.points.size() * this.oneSecondTime) * 1.0 / (double)this.interval;
    }

    public long getInterval() {
        return this.interval;
    }

    public long getOneSecondTime() {
        return this.oneSecondTime;
    }

    public ArrayDeque<Long> getPoints() {
        return this.points;
    }

    public boolean isHasLeave() {
        return this.hasLeave;
    }

    public void setHasLeave(boolean hasLeave) {
        this.hasLeave = hasLeave;
    }

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    private void removeFromHead(long timestamp) {
        if (this.points.size() > 1) {
            long first;
            long delta;
            while ((delta = timestamp - (first = this.points.getFirst().longValue())) >= this.interval) {
                this.points.remove();
                this.hasLeave = true;
                if (!this.points.isEmpty()) continue;
                break;
            }
        }
    }
}

