/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.factory;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.aggregator.AggregatorRate;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateEver;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateEverFilter;
import com.espertech.esper.epl.agg.aggregator.AggregatorRateFilter;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.AggregationValidationUtil;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;
import com.espertech.esper.epl.expression.methodagg.ExprRateAggNode;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.schedule.TimeProvider;

public class AggregationMethodFactoryRate
implements AggregationMethodFactory {
    protected final ExprRateAggNode parent;
    protected final boolean isEver;
    protected final long intervalTime;
    protected final TimeProvider timeProvider;
    protected final TimeAbacus timeAbacus;

    public AggregationMethodFactoryRate(ExprRateAggNode parent, boolean isEver, long intervalTime, TimeProvider timeProvider, TimeAbacus timeAbacus) {
        this.parent = parent;
        this.isEver = isEver;
        this.intervalTime = intervalTime;
        this.timeProvider = timeProvider;
        this.timeAbacus = timeAbacus;
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public Class getResultType() {
        return Double.class;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new IllegalStateException("Not an access aggregation function");
    }

    @Override
    public AggregationMethod make() {
        if (this.isEver) {
            if (this.parent.getPositionalParams().length == 0) {
                return new AggregatorRateEver(this.intervalTime, this.timeAbacus.getOneSecond(), this.timeProvider);
            }
            return new AggregatorRateEverFilter(this.intervalTime, this.timeAbacus.getOneSecond(), this.timeProvider);
        }
        if (this.parent.getOptionalFilter() != null) {
            return new AggregatorRateFilter(this.timeAbacus.getOneSecond());
        }
        return new AggregatorRate(this.timeAbacus.getOneSecond());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactoryRate that = (AggregationMethodFactoryRate)intoTableAgg;
        if (this.intervalTime != that.intervalTime) {
            throw new ExprValidationException("The size is " + this.intervalTime + " and provided is " + that.intervalTime);
        }
        AggregationValidationUtil.validateAggregationUnbound(!this.isEver, !that.isEver);
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        return null;
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultEvaluator(this.parent.getPositionalParams(), join, typesPerStream);
    }
}

