/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.agg.service;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.access.AggregationAccessorSlotPair;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationState;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.agg.service.AggregationRowPair;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitor;
import com.espertech.esper.epl.agg.service.AggregationServiceVisitorWGroupDetail;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.table.mgmt.TableColumnMethodPair;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableStateInstanceGrouped;
import com.espertech.esper.epl.table.strategy.ExprTableEvalLockUtil;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import java.util.Collection;
import java.util.concurrent.locks.Lock;

public abstract class AggSvcGroupByWTableBase
implements AggregationService {
    protected final TableMetadata tableMetadata;
    protected final TableColumnMethodPair[] methodPairs;
    protected final AggregationAccessorSlotPair[] accessors;
    protected final boolean isJoin;
    protected final TableStateInstanceGrouped tableStateInstance;
    protected final int[] targetStates;
    protected final ExprNode[] accessStateExpr;
    private final AggregationAgent[] agents;
    protected AggregationMethod[] currentAggregatorMethods;
    protected AggregationState[] currentAggregatorStates;
    protected Object currentGroupKey;

    public AggSvcGroupByWTableBase(TableMetadata tableMetadata, TableColumnMethodPair[] methodPairs, AggregationAccessorSlotPair[] accessors, boolean join, TableStateInstanceGrouped tableStateInstance, int[] targetStates, ExprNode[] accessStateExpr, AggregationAgent[] agents) {
        this.tableMetadata = tableMetadata;
        this.methodPairs = methodPairs;
        this.accessors = accessors;
        this.isJoin = join;
        this.tableStateInstance = tableStateInstance;
        this.targetStates = targetStates;
        this.accessStateExpr = accessStateExpr;
        this.agents = agents;
    }

    public abstract void applyEnterInternal(EventBean[] var1, Object var2, ExprEvaluatorContext var3);

    public abstract void applyLeaveInternal(EventBean[] var1, Object var2, ExprEvaluatorContext var3);

    @Override
    public void applyEnter(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        this.applyEnterInternal(eventsPerStream, groupByKey, exprEvaluatorContext);
    }

    @Override
    public void applyLeave(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ExprTableEvalLockUtil.obtainLockUnless((Lock)this.tableStateInstance.getTableLevelRWLock().writeLock(), exprEvaluatorContext);
        this.applyLeaveInternal(eventsPerStream, groupByKey, exprEvaluatorContext);
    }

    protected void applyEnterGroupKey(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayBackedEventBean bean = this.tableStateInstance.getCreateRowIntoTable(groupByKey, exprEvaluatorContext);
        AggregationRowPair row = (AggregationRowPair)bean.getProperties()[0];
        this.currentAggregatorMethods = row.getMethods();
        this.currentAggregatorStates = row.getStates();
        for (int j = 0; j < this.methodPairs.length; ++j) {
            TableColumnMethodPair methodPair = this.methodPairs[j];
            AggregationMethod method = this.currentAggregatorMethods[methodPair.getTargetIndex()];
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, true, exprEvaluatorContext);
            method.enter(columnResult);
        }
        for (int i = 0; i < this.targetStates.length; ++i) {
            AggregationState state = this.currentAggregatorStates[this.targetStates[i]];
            this.agents[i].applyEnter(eventsPerStream, exprEvaluatorContext, state);
        }
        this.tableStateInstance.handleRowUpdated(bean);
    }

    protected void applyLeaveGroupKey(EventBean[] eventsPerStream, Object groupByKey, ExprEvaluatorContext exprEvaluatorContext) {
        ObjectArrayBackedEventBean bean = this.tableStateInstance.getCreateRowIntoTable(groupByKey, exprEvaluatorContext);
        AggregationRowPair row = (AggregationRowPair)bean.getProperties()[0];
        this.currentAggregatorMethods = row.getMethods();
        this.currentAggregatorStates = row.getStates();
        for (int j = 0; j < this.methodPairs.length; ++j) {
            TableColumnMethodPair methodPair = this.methodPairs[j];
            AggregationMethod method = this.currentAggregatorMethods[methodPair.getTargetIndex()];
            Object columnResult = methodPair.getEvaluator().evaluate(eventsPerStream, false, exprEvaluatorContext);
            method.leave(columnResult);
        }
        for (int i = 0; i < this.targetStates.length; ++i) {
            AggregationState state = this.currentAggregatorStates[this.targetStates[i]];
            this.agents[i].applyLeave(eventsPerStream, exprEvaluatorContext, state);
        }
        this.tableStateInstance.handleRowUpdated(bean);
    }

    @Override
    public void setCurrentAccess(Object groupByKey, int agentInstanceId, AggregationGroupByRollupLevel rollupLevel) {
        ObjectArrayBackedEventBean bean = this.tableStateInstance.getRowForGroupKey(groupByKey);
        if (bean != null) {
            AggregationRowPair row = (AggregationRowPair)bean.getProperties()[0];
            this.currentAggregatorMethods = row.getMethods();
            this.currentAggregatorStates = row.getStates();
        } else {
            this.currentAggregatorMethods = null;
        }
        this.currentGroupKey = groupByKey;
    }

    @Override
    public Object getValue(int column, int agentInstanceId, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (column < this.currentAggregatorMethods.length) {
            return this.currentAggregatorMethods[column].getValue();
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.currentAggregatorMethods.length];
        return pair.getAccessor().getValue(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Collection<EventBean> getCollectionOfEvents(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.currentAggregatorMethods.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.currentAggregatorMethods.length];
        return pair.getAccessor().getEnumerableEvents(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public Collection<Object> getCollectionScalar(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.currentAggregatorMethods.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.currentAggregatorMethods.length];
        return pair.getAccessor().getEnumerableScalar(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public EventBean getEventBean(int column, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (column < this.currentAggregatorMethods.length) {
            return null;
        }
        AggregationAccessorSlotPair pair = this.accessors[column - this.currentAggregatorMethods.length];
        return pair.getAccessor().getEnumerableEvent(this.currentAggregatorStates[pair.getSlot()], eventsPerStream, isNewData, context);
    }

    @Override
    public void setRemovedCallback(AggregationRowRemovedCallback callback) {
    }

    @Override
    public void accept(AggregationServiceVisitor visitor) {
    }

    @Override
    public void acceptGroupDetail(AggregationServiceVisitorWGroupDetail visitor) {
    }

    @Override
    public boolean isGrouped() {
        return true;
    }

    @Override
    public Object getGroupKey(int agentInstanceId) {
        return this.currentGroupKey;
    }

    @Override
    public Collection<Object> getGroupKeys(ExprEvaluatorContext exprEvaluatorContext) {
        return this.tableStateInstance.getGroupKeys();
    }

    @Override
    public void clearResults(ExprEvaluatorContext exprEvaluatorContext) {
        this.tableStateInstance.clear();
    }

    @Override
    public void stop() {
    }

    @Override
    public AggregationService getContextPartitionAggregationService(int agentInstanceId) {
        return this;
    }
}

