/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.approx;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CountMinSketchStateTopk {
    private final int topkMax;
    private final TreeMap<Long, Object> topk;
    private final Map<ByteBuffer, Long> lastFreqForItem;

    public CountMinSketchStateTopk(int topkMax) {
        this.topkMax = topkMax;
        this.lastFreqForItem = new HashMap<ByteBuffer, Long>();
        this.topk = new TreeMap(Collections.reverseOrder());
    }

    public CountMinSketchStateTopk(int topkMax, TreeMap<Long, Object> topk, Map<ByteBuffer, Long> lastFreqForItem) {
        this.topkMax = topkMax;
        this.topk = topk;
        this.lastFreqForItem = lastFreqForItem;
    }

    public TreeMap<Long, Object> getTopk() {
        return this.topk;
    }

    public void updateExpectIncreasing(byte[] value, long frequency) {
        boolean filled;
        boolean bl = filled = this.lastFreqForItem.size() == this.topkMax;
        if (!filled) {
            ByteBuffer valueBuffer = ByteBuffer.wrap(value);
            this.updateInternal(valueBuffer, frequency);
        } else {
            Long lastKey = this.topk.lastKey();
            if (frequency > lastKey) {
                ByteBuffer valueBuffer = ByteBuffer.wrap(value);
                this.updateInternal(valueBuffer, frequency);
            }
        }
        this.trimItems();
    }

    private void updateInternal(ByteBuffer valueBuffer, long frequency) {
        Long beforeUpdateFrequency = this.lastFreqForItem.put(valueBuffer, frequency);
        if (beforeUpdateFrequency != null) {
            this.removeItemFromSorted(beforeUpdateFrequency, valueBuffer);
        }
        this.addItemToSorted(frequency, valueBuffer);
    }

    private void removeItemFromSorted(long frequency, ByteBuffer value) {
        Object existing = this.topk.get(frequency);
        if (existing != null) {
            if (existing instanceof Deque) {
                Deque deque = (Deque)existing;
                deque.remove(value);
                if (deque.isEmpty()) {
                    this.topk.remove(frequency);
                }
            } else {
                this.topk.remove(frequency);
            }
        }
    }

    private void addItemToSorted(long frequency, ByteBuffer value) {
        Object existing = this.topk.get(frequency);
        if (existing == null) {
            this.topk.put(frequency, value);
        } else if (existing instanceof Deque) {
            Deque deque = (Deque)existing;
            deque.add(value);
        } else {
            ArrayDeque<ByteBuffer> deque = new ArrayDeque<ByteBuffer>(2);
            deque.add((ByteBuffer)existing);
            deque.add(value);
            this.topk.put(frequency, deque);
        }
    }

    private void trimItems() {
        Map.Entry<Long, Object> last;
        while (this.lastFreqForItem.size() > this.topkMax && (last = this.topk.lastEntry()) != null) {
            if (last.getValue() instanceof Deque) {
                Deque deque = (Deque)last.getValue();
                ByteBuffer valueRemoved = (ByteBuffer)deque.removeLast();
                this.lastFreqForItem.remove(valueRemoved);
                if (!deque.isEmpty()) continue;
                this.topk.remove(last.getKey());
                continue;
            }
            this.topk.remove(last.getKey());
            this.lastFreqForItem.remove((ByteBuffer)last.getValue());
        }
    }

    public List<ByteBuffer> getTopKValues() {
        ArrayList<ByteBuffer> values = new ArrayList<ByteBuffer>();
        for (Map.Entry<Long, Object> entry : this.topk.entrySet()) {
            if (entry.getValue() instanceof Deque) {
                Deque set = (Deque)entry.getValue();
                for (ByteBuffer o : set) {
                    values.add(o);
                }
                continue;
            }
            values.add((ByteBuffer)entry.getValue());
        }
        return values;
    }

    public int getTopkMax() {
        return this.topkMax;
    }
}

