/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.ArrayEventIterator;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.context.util.AgentInstanceContext;
import com.espertech.esper.epl.agg.service.AggregationRowRemovedCallback;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.OrderByProcessor;
import com.espertech.esper.epl.core.ResultSetAggregateGroupedIterator;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedFactory;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedOutputAllHelper;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedOutputLastHelper;
import com.espertech.esper.epl.core.ResultSetProcessorGroupedOutputAllGroupReps;
import com.espertech.esper.epl.core.ResultSetProcessorGroupedOutputFirstHelper;
import com.espertech.esper.epl.core.ResultSetProcessorOutputHelperVisitor;
import com.espertech.esper.epl.core.ResultSetProcessorUtil;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.view.OutputConditionPolled;
import com.espertech.esper.view.Viewable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorAggregateGrouped
implements ResultSetProcessor,
AggregationRowRemovedCallback {
    protected final ResultSetProcessorAggregateGroupedFactory prototype;
    private final SelectExprProcessor selectExprProcessor;
    private final OrderByProcessor orderByProcessor;
    protected final AggregationService aggregationService;
    protected AgentInstanceContext agentInstanceContext;
    protected final EventBean[] eventsPerStreamOneStream = new EventBean[1];
    private ResultSetProcessorGroupedOutputAllGroupReps outputAllGroupReps;
    private final Map<Object, EventBean[]> workCollection = new LinkedHashMap<Object, EventBean[]>();
    private final Map<Object, EventBean[]> workCollectionTwo = new LinkedHashMap<Object, EventBean[]>();
    private ResultSetProcessorAggregateGroupedOutputLastHelper outputLastHelper;
    private ResultSetProcessorAggregateGroupedOutputAllHelper outputAllHelper;
    private ResultSetProcessorGroupedOutputFirstHelper outputFirstHelper;

    public ResultSetProcessorAggregateGrouped(ResultSetProcessorAggregateGroupedFactory prototype, SelectExprProcessor selectExprProcessor, OrderByProcessor orderByProcessor, AggregationService aggregationService, AgentInstanceContext agentInstanceContext) {
        this.prototype = prototype;
        this.selectExprProcessor = selectExprProcessor;
        this.orderByProcessor = orderByProcessor;
        this.aggregationService = aggregationService;
        this.agentInstanceContext = agentInstanceContext;
        aggregationService.setRemovedCallback(this);
        if (prototype.isOutputLast() && prototype.isEnableOutputLimitOpt()) {
            this.outputLastHelper = prototype.getResultSetProcessorHelperFactory().makeRSAggregateGroupedOutputLastOpt(agentInstanceContext, this, prototype);
        } else if (prototype.isOutputAll()) {
            if (!prototype.isEnableOutputLimitOpt()) {
                this.outputAllGroupReps = prototype.getResultSetProcessorHelperFactory().makeRSGroupedOutputAllNoOpt(agentInstanceContext, prototype.getGroupKeyNodes(), prototype.getNumStreams());
            } else {
                this.outputAllHelper = prototype.getResultSetProcessorHelperFactory().makeRSAggregateGroupedOutputAll(agentInstanceContext, this, prototype);
            }
        } else if (prototype.isOutputFirst()) {
            this.outputFirstHelper = prototype.getResultSetProcessorHelperFactory().makeRSGroupedOutputFirst(agentInstanceContext, prototype.getGroupKeyNodes(), prototype.getOptionalOutputFirstConditionFactory(), null, -1);
        }
    }

    @Override
    public void setAgentInstanceContext(AgentInstanceContext agentInstanceContext) {
        this.agentInstanceContext = agentInstanceContext;
    }

    @Override
    public EventType getResultEventType() {
        return this.prototype.getResultEventType();
    }

    public EventBean[] getEventsPerStreamOneStream() {
        return this.eventsPerStreamOneStream;
    }

    public AggregationService getAggregationService() {
        return this.aggregationService;
    }

    @Override
    public void applyViewResult(EventBean[] newData, EventBean[] oldData) {
        Object mk;
        int n;
        int n2;
        EventBean[] eventBeanArray;
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            eventBeanArray = newData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                EventBean aNewData;
                eventsPerStream[0] = aNewData = eventBeanArray[n];
                mk = this.generateGroupKey(eventsPerStream, true);
                this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            eventBeanArray = oldData;
            n2 = eventBeanArray.length;
            for (n = 0; n < n2; ++n) {
                EventBean anOldData;
                eventsPerStream[0] = anOldData = eventBeanArray[n];
                mk = this.generateGroupKey(eventsPerStream, false);
                this.aggregationService.applyLeave(eventsPerStream, mk, this.agentInstanceContext);
            }
        }
    }

    @Override
    public void applyJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents) {
        Object mk;
        if (!newEvents.isEmpty()) {
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                mk = this.generateGroupKey(eventsPerStream.getArray(), true);
                this.aggregationService.applyEnter(eventsPerStream.getArray(), mk, this.agentInstanceContext);
            }
        }
        if (oldEvents != null && !oldEvents.isEmpty()) {
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                mk = this.generateGroupKey(eventsPerStream.getArray(), false);
                this.aggregationService.applyLeave(eventsPerStream.getArray(), mk, this.agentInstanceContext);
            }
        }
    }

    @Override
    public UniformPair<EventBean[]> processJoinResult(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int count;
        Object[] newDataGroupByKeys = this.generateGroupKeys(newEvents, true);
        Object[] oldDataGroupByKeys = this.generateGroupKeys(oldEvents, false);
        if (this.prototype.isUnidirectional()) {
            this.clear();
        }
        if (!newEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : newEvents) {
                this.aggregationService.applyEnter(eventsPerStream.getArray(), newDataGroupByKeys[count], this.agentInstanceContext);
                ++count;
            }
        }
        if (!oldEvents.isEmpty()) {
            count = 0;
            for (MultiKey<EventBean> eventsPerStream : oldEvents) {
                this.aggregationService.applyLeave(eventsPerStream.getArray(), oldDataGroupByKeys[count], this.agentInstanceContext);
                ++count;
            }
        }
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsJoin(oldEvents, oldDataGroupByKeys, false, isSynthesize);
        }
        if ((selectNewEvents = this.generateOutputEventsJoin(newEvents, newDataGroupByKeys, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    @Override
    public UniformPair<EventBean[]> processViewResult(EventBean[] newData, EventBean[] oldData, boolean isSynthesize) {
        EventBean[] selectNewEvents;
        int i;
        Object[] newDataGroupByKeys = this.generateGroupKeys(newData, true);
        Object[] oldDataGroupByKeys = this.generateGroupKeys(oldData, false);
        EventBean[] eventsPerStream = new EventBean[1];
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                eventsPerStream[0] = newData[i];
                this.aggregationService.applyEnter(eventsPerStream, newDataGroupByKeys[i], this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                eventsPerStream[0] = oldData[i];
                this.aggregationService.applyLeave(eventsPerStream, oldDataGroupByKeys[i], this.agentInstanceContext);
            }
        }
        EventBean[] selectOldEvents = null;
        if (this.prototype.isSelectRStream()) {
            selectOldEvents = this.generateOutputEventsView(oldData, oldDataGroupByKeys, false, isSynthesize);
        }
        if ((selectNewEvents = this.generateOutputEventsView(newData, newDataGroupByKeys, true, isSynthesize)) != null || selectOldEvents != null) {
            return new UniformPair<EventBean[]>(selectNewEvents, selectOldEvents);
        }
        return null;
    }

    private EventBean[] generateOutputEventsView(EventBean[] outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize) {
        if (outputEvents == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        EventBean[] events = new EventBean[outputEvents.length];
        Object[] keys = new Object[outputEvents.length];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[outputEvents.length][];
        }
        int countOutputRows = 0;
        for (int countInputRows = 0; countInputRows < outputEvents.length; ++countInputRows) {
            Boolean result;
            this.aggregationService.setCurrentAccess(groupByKeys[countInputRows], this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = outputEvents[countInputRows];
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[countOutputRows] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[countOutputRows] = groupByKeys[countInputRows];
            if (this.prototype.isSorting()) {
                EventBean[] currentEventsPerStream = new EventBean[]{outputEvents[countInputRows]};
                currentGenerators[countOutputRows] = currentEventsPerStream;
            }
            ++countOutputRows;
        }
        if (countOutputRows != events.length) {
            if (countOutputRows == 0) {
                return null;
            }
            EventBean[] outEvents = new EventBean[countOutputRows];
            System.arraycopy(events, 0, outEvents, 0, countOutputRows);
            events = outEvents;
            if (this.prototype.isSorting()) {
                Object[] outKeys = new Object[countOutputRows];
                System.arraycopy(keys, 0, outKeys, 0, countOutputRows);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[countOutputRows][];
                System.arraycopy(currentGenerators, 0, outGens, 0, countOutputRows);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    public Object[] generateGroupKeys(Set<MultiKey<EventBean>> resultSet, boolean isNewData) {
        if (resultSet.isEmpty()) {
            return null;
        }
        Object[] keys = new Object[resultSet.size()];
        int count = 0;
        for (MultiKey<EventBean> eventsPerStream : resultSet) {
            keys[count] = this.generateGroupKey(eventsPerStream.getArray(), isNewData);
            ++count;
        }
        return keys;
    }

    public Object[] generateGroupKeys(EventBean[] events, boolean isNewData) {
        if (events == null) {
            return null;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        Object[] keys = new Object[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventsPerStream[0] = events[i];
            keys[i] = this.generateGroupKey(eventsPerStream, isNewData);
        }
        return keys;
    }

    @Override
    public void acceptHelperVisitor(ResultSetProcessorOutputHelperVisitor visitor) {
        if (this.outputAllGroupReps != null) {
            visitor.visit(this.outputAllGroupReps);
        }
        if (this.outputLastHelper != null) {
            visitor.visit(this.outputLastHelper);
        }
        if (this.outputAllHelper != null) {
            visitor.visit(this.outputAllHelper);
        }
        if (this.outputFirstHelper != null) {
            visitor.visit(this.outputFirstHelper);
        }
    }

    protected Object generateGroupKey(EventBean[] eventsPerStream, boolean isNewData) {
        if (this.prototype.getGroupKeyNode() != null) {
            return this.prototype.getGroupKeyNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
        }
        Object[] keys = new Object[this.prototype.getGroupKeyNodes().length];
        int count = 0;
        for (ExprEvaluator exprNode : this.prototype.getGroupKeyNodes()) {
            keys[count] = exprNode.evaluate(eventsPerStream, isNewData, this.agentInstanceContext);
            ++count;
        }
        return new MultiKeyUntyped(keys);
    }

    private EventBean[] generateOutputEventsJoin(Set<MultiKey<EventBean>> resultSet, Object[] groupByKeys, boolean isNewData, boolean isSynthesize) {
        if (resultSet.isEmpty()) {
            return null;
        }
        EventBean[] events = new EventBean[resultSet.size()];
        Object[] keys = new Object[resultSet.size()];
        EventBean[][] currentGenerators = null;
        if (this.prototype.isSorting()) {
            currentGenerators = new EventBean[resultSet.size()][];
        }
        int countOutputRows = 0;
        int countInputRows = -1;
        for (MultiKey<EventBean> row : resultSet) {
            Boolean result;
            EventBean[] eventsPerStream = row.getArray();
            this.aggregationService.setCurrentAccess(groupByKeys[++countInputRows], this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            events[countOutputRows] = this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
            keys[countOutputRows] = groupByKeys[countInputRows];
            if (this.prototype.isSorting()) {
                currentGenerators[countOutputRows] = eventsPerStream;
            }
            ++countOutputRows;
        }
        if (countOutputRows != events.length) {
            if (countOutputRows == 0) {
                return null;
            }
            EventBean[] outEvents = new EventBean[countOutputRows];
            System.arraycopy(events, 0, outEvents, 0, countOutputRows);
            events = outEvents;
            if (this.prototype.isSorting()) {
                Object[] outKeys = new Object[countOutputRows];
                System.arraycopy(keys, 0, outKeys, 0, countOutputRows);
                keys = outKeys;
                EventBean[][] outGens = new EventBean[countOutputRows][];
                System.arraycopy(currentGenerators, 0, outGens, 0, countOutputRows);
                currentGenerators = outGens;
            }
        }
        if (this.prototype.isSorting()) {
            events = this.orderByProcessor.sort(events, currentGenerators, keys, isNewData, this.agentInstanceContext);
        }
        return events;
    }

    @Override
    public Iterator<EventBean> getIterator(Viewable parent) {
        if (!this.prototype.isHistoricalOnly()) {
            return this.obtainIterator(parent);
        }
        this.aggregationService.clearResults(this.agentInstanceContext);
        Iterator<EventBean> it = parent.iterator();
        EventBean[] eventsPerStream = new EventBean[1];
        while (it.hasNext()) {
            eventsPerStream[0] = it.next();
            Object groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.applyEnter(eventsPerStream, groupKey, this.agentInstanceContext);
        }
        ArrayDeque<EventBean> deque = ResultSetProcessorUtil.iteratorToDeque(this.obtainIterator(parent));
        this.aggregationService.clearResults(this.agentInstanceContext);
        return deque.iterator();
    }

    private Iterator<EventBean> obtainIterator(Viewable parent) {
        if (this.orderByProcessor == null) {
            return new ResultSetAggregateGroupedIterator(parent.iterator(), this, this.aggregationService, this.agentInstanceContext);
        }
        EventBean[] eventsPerStream = new EventBean[1];
        ArrayList<EventBean> outgoingEvents = new ArrayList<EventBean>();
        ArrayList<Object> orderKeys = new ArrayList<Object>();
        Iterator<EventBean> iterator = parent.iterator();
        while (iterator.hasNext()) {
            Boolean pass;
            EventBean candidate;
            eventsPerStream[0] = candidate = iterator.next();
            Object groupKey = this.generateGroupKey(eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((pass = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, true, this.agentInstanceContext)) == null || !pass.booleanValue())) continue;
            outgoingEvents.add(this.selectExprProcessor.process(eventsPerStream, true, true, this.agentInstanceContext));
            Object orderKey = this.orderByProcessor.getSortKey(eventsPerStream, true, this.agentInstanceContext);
            orderKeys.add(orderKey);
        }
        EventBean[] outgoingEventsArr = outgoingEvents.toArray(new EventBean[outgoingEvents.size()]);
        Object[] orderKeysArr = orderKeys.toArray(new Object[orderKeys.size()]);
        EventBean[] orderedEvents = this.orderByProcessor.sort(outgoingEventsArr, orderKeysArr, this.agentInstanceContext);
        return new ArrayEventIterator(orderedEvents);
    }

    public SelectExprProcessor getSelectExprProcessor() {
        return this.selectExprProcessor;
    }

    public ExprEvaluator getOptionalHavingNode() {
        return this.prototype.getOptionalHavingNode();
    }

    @Override
    public Iterator<EventBean> getIterator(Set<MultiKey<EventBean>> joinSet) {
        Object[] groupByKeys = this.generateGroupKeys(joinSet, true);
        EventBean[] result = this.generateOutputEventsJoin(joinSet, groupByKeys, true, true);
        return new ArrayEventIterator(result);
    }

    @Override
    public void clear() {
        this.aggregationService.clearResults(this.agentInstanceContext);
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            return this.processOutputLimitedJoinDefault(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            return this.processOutputLimitedJoinAll(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            return this.processOutputLimitedJoinFirst(joinEventsSet, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedJoinLast(joinEventsSet, generateSynthetic);
        }
        throw new IllegalStateException("Unrecognized output limit " + (Object)((Object)outputLimitLimitType));
    }

    @Override
    public UniformPair<EventBean[]> processOutputLimitedView(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic, OutputLimitLimitType outputLimitLimitType) {
        if (outputLimitLimitType == OutputLimitLimitType.DEFAULT) {
            return this.processOutputLimitedViewDefault(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.ALL) {
            return this.processOutputLimitedViewAll(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.FIRST) {
            return this.processOutputLimitedViewFirst(viewEventsList, generateSynthetic);
        }
        if (outputLimitLimitType == OutputLimitLimitType.LAST) {
            return this.processOutputLimitedViewLast(viewEventsList, generateSynthetic);
        }
        throw new IllegalStateException("Unrecognized output limited type " + (Object)((Object)outputLimitLimitType));
    }

    @Override
    public void stop() {
        if (this.outputAllGroupReps != null) {
            this.outputAllGroupReps.destroy();
        }
        if (this.outputAllHelper != null) {
            this.outputAllHelper.destroy();
        }
        if (this.outputLastHelper != null) {
            this.outputLastHelper.destroy();
        }
        if (this.outputFirstHelper != null) {
            this.outputFirstHelper.destroy();
        }
    }

    public void generateOutputBatchedJoinUnkeyed(Set<MultiKey<EventBean>> outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, Collection<EventBean> resultEvents, List<Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        int count = 0;
        for (MultiKey<EventBean> row : outputEvents) {
            Boolean result;
            this.aggregationService.setCurrentAccess(groupByKeys[count], this.agentInstanceContext.getAgentInstanceId(), null);
            EventBean[] eventsPerStream = row.getArray();
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    public EventBean generateOutputBatchedSingle(Object groupByKey, EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize) {
        Boolean result;
        this.aggregationService.setCurrentAccess(groupByKey, this.agentInstanceContext.getAgentInstanceId(), null);
        if (!(this.prototype.getOptionalHavingNode() == null || (result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) != null && result.booleanValue())) {
            return null;
        }
        return this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext);
    }

    public void generateOutputBatchedViewPerKey(EventBean[] outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, Map<Object, EventBean> resultEvents, Map<Object, Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            Object groupKey = groupByKeys[count];
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = outputEvents[count];
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.put(groupKey, this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.put(groupKey, this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    public void generateOutputBatchedJoinPerKey(Set<MultiKey<EventBean>> outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, Map<Object, EventBean> resultEvents, Map<Object, Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        int count = 0;
        for (MultiKey<EventBean> row : outputEvents) {
            Boolean result;
            Object groupKey = groupByKeys[count];
            this.aggregationService.setCurrentAccess(groupKey, this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(row.getArray(), isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.put(groupKey, this.selectExprProcessor.process(row.getArray(), isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.put(groupKey, this.orderByProcessor.getSortKey(row.getArray(), isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }

    @Override
    public boolean hasAggregation() {
        return true;
    }

    @Override
    public void removed(Object key) {
        if (this.outputAllGroupReps != null) {
            this.outputAllGroupReps.remove(key);
        }
        if (this.outputAllHelper != null) {
            this.outputAllHelper.remove(key);
        }
        if (this.outputLastHelper != null) {
            this.outputLastHelper.remove(key);
        }
        if (this.outputFirstHelper != null) {
            this.outputFirstHelper.remove(key);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processView(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processView(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public void processOutputLimitedLastAllNonBufferedJoin(Set<MultiKey<EventBean>> newData, Set<MultiKey<EventBean>> oldData, boolean isGenerateSynthetic, boolean isAll) {
        if (isAll) {
            this.outputAllHelper.processJoin(newData, oldData, isGenerateSynthetic);
        } else {
            this.outputLastHelper.processJoin(newData, oldData, isGenerateSynthetic);
        }
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedView(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputView(isSynthesize);
        }
        return this.outputLastHelper.outputView(isSynthesize);
    }

    @Override
    public UniformPair<EventBean[]> continueOutputLimitedLastAllNonBufferedJoin(boolean isSynthesize, boolean isAll) {
        if (isAll) {
            return this.outputAllHelper.outputJoin(isSynthesize);
        }
        return this.outputLastHelper.outputJoin(isSynthesize);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinLast(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedHashMap<Object, EventBean> lastPerGroupNew = new LinkedHashMap<Object, EventBean>();
        LinkedHashMap<Object, EventBean> lastPerGroupOld = null;
        if (this.prototype.isSelectRStream()) {
            lastPerGroupOld = new LinkedHashMap<Object, EventBean>();
        }
        LinkedHashMap<Object, Object> newEventsSortKey = null;
        LinkedHashMap<Object, Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedHashMap<Object, Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedHashMap<Object, Object>();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            int count;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> aNewData : newData) {
                    Object mk = newDataMultiKey[count];
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedJoinPerKey(oldData, oldDataMultiKey, false, generateSynthetic, lastPerGroupOld, oldEventsSortKey);
            }
            this.generateOutputBatchedJoinPerKey(newData, newDataMultiKey, false, generateSynthetic, lastPerGroupNew, newEventsSortKey);
        }
        EventBean[] newEventsArr = lastPerGroupNew.isEmpty() ? null : lastPerGroupNew.values().toArray(new EventBean[lastPerGroupNew.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = lastPerGroupOld.isEmpty() ? null : lastPerGroupOld.values().toArray(new EventBean[lastPerGroupOld.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.values().toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.values().toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinFirst(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        Set<MultiKey<EventBean>> oldData;
        Set<MultiKey<EventBean>> newData;
        ArrayList<EventBean> resultNewEvents = new ArrayList<EventBean>();
        ArrayList<Object> resultNewSortKeys = null;
        ArrayList resultOldEvents = null;
        ArrayList resultOldSortKeys = null;
        if (this.orderByProcessor != null) {
            resultNewSortKeys = new ArrayList<Object>();
        }
        if (this.prototype.isSelectRStream()) {
            resultOldEvents = new ArrayList();
            resultOldSortKeys = new ArrayList();
        }
        this.workCollection.clear();
        if (this.prototype.getOptionalHavingNode() == null) {
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                boolean pass;
                OutputConditionPolled outputStateGroup;
                Object mk;
                int count;
                newData = pair.getFirst();
                oldData = pair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = newDataMultiKey[count];
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(1, 0);
                        if (pass) {
                            this.workCollection.put(mk, aNewData.getArray());
                        }
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aOldData : oldData) {
                        mk = oldDataMultiKey[count];
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(0, 1);
                        if (pass) {
                            this.workCollection.put(mk, aOldData.getArray());
                        }
                        this.aggregationService.applyLeave(aOldData.getArray(), mk, this.agentInstanceContext);
                        ++count;
                    }
                }
                this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
            }
        } else {
            for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
                boolean pass;
                OutputConditionPolled outputStateGroup;
                Boolean result;
                Object mk;
                int count;
                newData = pair.getFirst();
                oldData = pair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = newDataMultiKey[count];
                        this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aOldData : oldData) {
                        mk = oldDataMultiKey[count];
                        this.aggregationService.applyLeave(aOldData.getArray(), mk, this.agentInstanceContext);
                        ++count;
                    }
                }
                if (newData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aNewData : newData) {
                        mk = newDataMultiKey[count];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(aNewData.getArray(), true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) {
                            ++count;
                            continue;
                        }
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(1, 0);
                        if (pass) {
                            this.workCollection.put(mk, aNewData.getArray());
                        }
                        ++count;
                    }
                }
                if (oldData != null) {
                    count = 0;
                    for (MultiKey<EventBean> aOldData : oldData) {
                        mk = oldDataMultiKey[count];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(aOldData.getArray(), true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue()) {
                            ++count;
                            continue;
                        }
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(0, 1);
                        if (!pass) continue;
                        this.workCollection.put(mk, aOldData.getArray());
                    }
                }
                this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
            }
        }
        EventBean[] newEventsArr = null;
        EventBean[] oldEventsArr = null;
        if (!resultNewEvents.isEmpty()) {
            newEventsArr = resultNewEvents.toArray(new EventBean[resultNewEvents.size()]);
        }
        if (resultOldEvents != null && !resultOldEvents.isEmpty()) {
            oldEventsArr = resultOldEvents.toArray(new EventBean[resultOldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = resultNewSortKeys.isEmpty() ? null : resultNewSortKeys.toArray(new Object[resultNewSortKeys.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = resultOldSortKeys.isEmpty() ? null : resultOldSortKeys.toArray(new Object[resultOldSortKeys.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinAll(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        this.workCollection.clear();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            int count;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> aNewData : newData) {
                    Object mk = newDataMultiKey[count];
                    this.aggregationService.applyEnter(aNewData.getArray(), mk, this.agentInstanceContext);
                    ++count;
                    this.workCollection.put(mk, aNewData.getArray());
                    this.outputAllGroupReps.put(mk, aNewData.getArray());
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedJoinUnkeyed(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            this.generateOutputBatchedJoinUnkeyed(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
        }
        Iterator<Map.Entry<Object, EventBean[]>> entryIterator = this.outputAllGroupReps.entryIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Object, EventBean[]> entry = entryIterator.next();
            if (this.workCollection.containsKey(entry.getKey())) continue;
            this.workCollectionTwo.put(entry.getKey(), entry.getValue());
            this.generateOutputBatchedArr(this.workCollectionTwo, true, generateSynthetic, newEvents, newEventsSortKey);
            this.workCollectionTwo.clear();
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedJoinDefault(List<UniformPair<Set<MultiKey<EventBean>>>> joinEventsSet, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinEventsSet) {
            int count;
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (this.prototype.isUnidirectional()) {
                this.clear();
            }
            if (newData != null) {
                count = 0;
                for (MultiKey<EventBean> aNewData : newData) {
                    this.aggregationService.applyEnter(aNewData.getArray(), newDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                for (MultiKey<EventBean> anOldData : oldData) {
                    this.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedJoinUnkeyed(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            this.generateOutputBatchedJoinUnkeyed(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewLast(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedHashMap<Object, EventBean> lastPerGroupNew = new LinkedHashMap<Object, EventBean>();
        LinkedHashMap<Object, EventBean> lastPerGroupOld = null;
        if (this.prototype.isSelectRStream()) {
            lastPerGroupOld = new LinkedHashMap<Object, EventBean>();
        }
        LinkedHashMap<Object, Object> newEventsSortKey = null;
        LinkedHashMap<Object, Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedHashMap<Object, Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedHashMap<Object, Object>();
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int count;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (newData != null) {
                count = 0;
                for (EventBean aNewData : newData) {
                    Object mk = newDataMultiKey[count];
                    this.eventsPerStreamOneStream[0] = aNewData;
                    this.aggregationService.applyEnter(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                EventBean[] eventBeanArray = oldData;
                int n = eventBeanArray.length;
                for (int i = 0; i < n; ++i) {
                    EventBean anOldData;
                    this.eventsPerStreamOneStream[0] = anOldData = eventBeanArray[i];
                    this.aggregationService.applyLeave(this.eventsPerStreamOneStream, oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedViewPerKey(oldData, oldDataMultiKey, false, generateSynthetic, lastPerGroupOld, oldEventsSortKey);
            }
            this.generateOutputBatchedViewPerKey(newData, newDataMultiKey, false, generateSynthetic, lastPerGroupNew, newEventsSortKey);
        }
        EventBean[] newEventsArr = lastPerGroupNew.isEmpty() ? null : lastPerGroupNew.values().toArray(new EventBean[lastPerGroupNew.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = lastPerGroupOld.isEmpty() ? null : lastPerGroupOld.values().toArray(new EventBean[lastPerGroupOld.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.values().toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.values().toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewFirst(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        EventBean[] oldData;
        EventBean[] newData;
        ArrayList<EventBean> resultNewEvents = new ArrayList<EventBean>();
        ArrayList<Object> resultNewSortKeys = null;
        ArrayList resultOldEvents = null;
        ArrayList resultOldSortKeys = null;
        if (this.orderByProcessor != null) {
            resultNewSortKeys = new ArrayList<Object>();
        }
        if (this.prototype.isSelectRStream()) {
            resultOldEvents = new ArrayList();
            resultOldSortKeys = new ArrayList();
        }
        this.workCollection.clear();
        if (this.prototype.getOptionalHavingNode() == null) {
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                boolean pass;
                OutputConditionPolled outputStateGroup;
                Object mk;
                int i;
                newData = pair.getFirst();
                oldData = pair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    for (i = 0; i < newData.length; ++i) {
                        this.eventsPerStreamOneStream[0] = newData[i];
                        mk = newDataMultiKey[i];
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(1, 0);
                        if (pass) {
                            this.workCollection.put(mk, new EventBean[]{newData[i]});
                        }
                        this.aggregationService.applyEnter(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                    }
                }
                if (oldData != null) {
                    for (i = 0; i < oldData.length; ++i) {
                        this.eventsPerStreamOneStream[0] = oldData[i];
                        mk = oldDataMultiKey[i];
                        outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory());
                        pass = outputStateGroup.updateOutputCondition(0, 1);
                        if (pass) {
                            this.workCollection.put(mk, new EventBean[]{oldData[i]});
                        }
                        this.aggregationService.applyLeave(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                    }
                }
                this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
            }
        } else {
            for (UniformPair<EventBean[]> pair : viewEventsList) {
                OutputConditionPolled outputStateGroup;
                boolean pass;
                Boolean result;
                Object mk;
                int i;
                newData = pair.getFirst();
                oldData = pair.getSecond();
                Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
                Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
                if (newData != null) {
                    for (i = 0; i < newData.length; ++i) {
                        this.eventsPerStreamOneStream[0] = newData[i];
                        mk = newDataMultiKey[i];
                        this.aggregationService.applyEnter(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                    }
                }
                if (oldData != null) {
                    for (i = 0; i < oldData.length; ++i) {
                        this.eventsPerStreamOneStream[0] = oldData[i];
                        mk = oldDataMultiKey[i];
                        this.aggregationService.applyLeave(this.eventsPerStreamOneStream, mk, this.agentInstanceContext);
                    }
                }
                if (newData != null) {
                    for (i = 0; i < newData.length; ++i) {
                        this.eventsPerStreamOneStream[0] = newData[i];
                        mk = newDataMultiKey[i];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(this.eventsPerStreamOneStream, true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue() || !(pass = (outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory())).updateOutputCondition(1, 0))) continue;
                        this.workCollection.put(mk, new EventBean[]{newData[i]});
                    }
                }
                if (oldData != null) {
                    for (i = 0; i < oldData.length; ++i) {
                        this.eventsPerStreamOneStream[0] = oldData[i];
                        mk = oldDataMultiKey[i];
                        this.aggregationService.setCurrentAccess(mk, this.agentInstanceContext.getAgentInstanceId(), null);
                        result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(this.eventsPerStreamOneStream, true, this.agentInstanceContext);
                        if (result == null || !result.booleanValue() || !(pass = (outputStateGroup = this.outputFirstHelper.getOrAllocate(mk, this.agentInstanceContext, this.prototype.getOptionalOutputFirstConditionFactory())).updateOutputCondition(0, 1))) continue;
                        this.workCollection.put(mk, new EventBean[]{oldData[i]});
                    }
                }
                this.generateOutputBatchedArr(this.workCollection, false, generateSynthetic, resultNewEvents, resultNewSortKeys);
            }
        }
        EventBean[] newEventsArr = null;
        EventBean[] oldEventsArr = null;
        if (!resultNewEvents.isEmpty()) {
            newEventsArr = resultNewEvents.toArray(new EventBean[resultNewEvents.size()]);
        }
        if (resultOldEvents != null && !resultOldEvents.isEmpty()) {
            oldEventsArr = resultOldEvents.toArray(new EventBean[resultOldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = resultNewSortKeys.isEmpty() ? null : resultNewSortKeys.toArray(new Object[resultNewSortKeys.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = resultOldSortKeys.isEmpty() ? null : resultOldSortKeys.toArray(new Object[resultOldSortKeys.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewAll(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        this.workCollection.clear();
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int count;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            EventBean[] eventsPerStream = new EventBean[1];
            if (newData != null) {
                count = 0;
                for (EventBean aNewData : newData) {
                    Object mk = newDataMultiKey[count];
                    eventsPerStream[0] = aNewData;
                    this.aggregationService.applyEnter(eventsPerStream, mk, this.agentInstanceContext);
                    ++count;
                    this.workCollection.put(mk, eventsPerStream);
                    this.outputAllGroupReps.put(mk, new EventBean[]{aNewData});
                }
            }
            if (oldData != null) {
                count = 0;
                EventBean[] eventBeanArray = oldData;
                int n = eventBeanArray.length;
                for (int i = 0; i < n; ++i) {
                    EventBean anOldData;
                    eventsPerStream[0] = anOldData = eventBeanArray[i];
                    this.aggregationService.applyLeave(eventsPerStream, oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedViewUnkeyed(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            this.generateOutputBatchedViewUnkeyed(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
        }
        Iterator<Map.Entry<Object, EventBean[]>> entryIterator = this.outputAllGroupReps.entryIterator();
        while (entryIterator.hasNext()) {
            Map.Entry<Object, EventBean[]> entry = entryIterator.next();
            if (this.workCollection.containsKey(entry.getKey())) continue;
            this.workCollectionTwo.put(entry.getKey(), entry.getValue());
            this.generateOutputBatchedArr(this.workCollectionTwo, true, generateSynthetic, newEvents, newEventsSortKey);
            this.workCollectionTwo.clear();
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private UniformPair<EventBean[]> processOutputLimitedViewDefault(List<UniformPair<EventBean[]>> viewEventsList, boolean generateSynthetic) {
        LinkedList<EventBean> newEvents = new LinkedList<EventBean>();
        LinkedList<EventBean> oldEvents = null;
        if (this.prototype.isSelectRStream()) {
            oldEvents = new LinkedList<EventBean>();
        }
        LinkedList<Object> newEventsSortKey = null;
        LinkedList<Object> oldEventsSortKey = null;
        if (this.orderByProcessor != null) {
            newEventsSortKey = new LinkedList<Object>();
            if (this.prototype.isSelectRStream()) {
                oldEventsSortKey = new LinkedList<Object>();
            }
        }
        for (UniformPair<EventBean[]> pair : viewEventsList) {
            int n;
            int n2;
            EventBean[] eventBeanArray;
            int count;
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            Object[] newDataMultiKey = this.generateGroupKeys(newData, true);
            Object[] oldDataMultiKey = this.generateGroupKeys(oldData, false);
            if (newData != null) {
                count = 0;
                eventBeanArray = newData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean aNewData;
                    this.eventsPerStreamOneStream[0] = aNewData = eventBeanArray[n];
                    this.aggregationService.applyEnter(this.eventsPerStreamOneStream, newDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (oldData != null) {
                count = 0;
                eventBeanArray = oldData;
                n2 = eventBeanArray.length;
                for (n = 0; n < n2; ++n) {
                    EventBean anOldData;
                    this.eventsPerStreamOneStream[0] = anOldData = eventBeanArray[n];
                    this.aggregationService.applyLeave(this.eventsPerStreamOneStream, oldDataMultiKey[count], this.agentInstanceContext);
                    ++count;
                }
            }
            if (this.prototype.isSelectRStream()) {
                this.generateOutputBatchedViewUnkeyed(oldData, oldDataMultiKey, false, generateSynthetic, oldEvents, oldEventsSortKey);
            }
            this.generateOutputBatchedViewUnkeyed(newData, newDataMultiKey, true, generateSynthetic, newEvents, newEventsSortKey);
        }
        EventBean[] newEventsArr = newEvents.isEmpty() ? null : newEvents.toArray(new EventBean[newEvents.size()]);
        EventBean[] oldEventsArr = null;
        if (this.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = oldEvents.isEmpty() ? null : oldEvents.toArray(new EventBean[oldEvents.size()]);
        }
        if (this.orderByProcessor != null) {
            Object[] sortKeysNew = newEventsSortKey.isEmpty() ? null : newEventsSortKey.toArray(new Object[newEventsSortKey.size()]);
            newEventsArr = this.orderByProcessor.sort(newEventsArr, sortKeysNew, this.agentInstanceContext);
            if (this.prototype.isSelectRStream()) {
                Object[] sortKeysOld = oldEventsSortKey.isEmpty() ? null : oldEventsSortKey.toArray(new Object[oldEventsSortKey.size()]);
                oldEventsArr = this.orderByProcessor.sort(oldEventsArr, sortKeysOld, this.agentInstanceContext);
            }
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }

    private void generateOutputBatchedArr(Map<Object, EventBean[]> keysAndEvents, boolean isNewData, boolean isSynthesize, List<EventBean> resultEvents, List<Object> optSortKeys) {
        for (Map.Entry<Object, EventBean[]> entry : keysAndEvents.entrySet()) {
            Boolean result;
            EventBean[] eventsPerStream = entry.getValue();
            this.aggregationService.setCurrentAccess(entry.getKey(), this.agentInstanceContext.getAgentInstanceId(), null);
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (!this.prototype.isSorting()) continue;
            optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
        }
    }

    public void generateOutputBatchedViewUnkeyed(EventBean[] outputEvents, Object[] groupByKeys, boolean isNewData, boolean isSynthesize, Collection<EventBean> resultEvents, List<Object> optSortKeys) {
        if (outputEvents == null) {
            return;
        }
        EventBean[] eventsPerStream = new EventBean[1];
        int count = 0;
        for (int i = 0; i < outputEvents.length; ++i) {
            Boolean result;
            this.aggregationService.setCurrentAccess(groupByKeys[count], this.agentInstanceContext.getAgentInstanceId(), null);
            eventsPerStream[0] = outputEvents[count];
            if (this.prototype.getOptionalHavingNode() != null && ((result = (Boolean)this.prototype.getOptionalHavingNode().evaluate(eventsPerStream, isNewData, this.agentInstanceContext)) == null || !result.booleanValue())) continue;
            resultEvents.add(this.selectExprProcessor.process(eventsPerStream, isNewData, isSynthesize, this.agentInstanceContext));
            if (this.prototype.isSorting()) {
                optSortKeys.add(this.orderByProcessor.getSortKey(eventsPerStream, isNewData, this.agentInstanceContext));
            }
            ++count;
        }
    }
}

