/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGrouped;
import com.espertech.esper.epl.core.ResultSetProcessorAggregateGroupedOutputLastHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessorAggregateGroupedOutputLastHelperImpl
implements ResultSetProcessorAggregateGroupedOutputLastHelper {
    private final ResultSetProcessorAggregateGrouped processor;
    private Map<Object, EventBean> outputLastUnordGroupNew;
    private Map<Object, EventBean> outputLastUnordGroupOld;

    public ResultSetProcessorAggregateGroupedOutputLastHelperImpl(ResultSetProcessorAggregateGrouped processor) {
        this.processor = processor;
        this.outputLastUnordGroupNew = new LinkedHashMap<Object, EventBean>();
        this.outputLastUnordGroupOld = new LinkedHashMap<Object, EventBean>();
    }

    @Override
    public void processView(EventBean[] newData, EventBean[] oldData, boolean isGenerateSynthetic) {
        int count;
        Object[] newDataMultiKey = this.processor.generateGroupKeys(newData, true);
        Object[] oldDataMultiKey = this.processor.generateGroupKeys(oldData, false);
        if (newData != null) {
            count = 0;
            for (EventBean aNewData : newData) {
                Object mk = newDataMultiKey[count];
                this.processor.eventsPerStreamOneStream[0] = aNewData;
                this.processor.aggregationService.applyEnter(this.processor.eventsPerStreamOneStream, mk, this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (oldData != null) {
            count = 0;
            EventBean[] eventBeanArray = oldData;
            int n = eventBeanArray.length;
            for (int i = 0; i < n; ++i) {
                EventBean anOldData;
                this.processor.eventsPerStreamOneStream[0] = anOldData = eventBeanArray[i];
                this.processor.aggregationService.applyLeave(this.processor.eventsPerStreamOneStream, oldDataMultiKey[count], this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (this.processor.prototype.isSelectRStream()) {
            this.processor.generateOutputBatchedViewPerKey(oldData, oldDataMultiKey, false, isGenerateSynthetic, this.outputLastUnordGroupOld, null);
        }
        this.processor.generateOutputBatchedViewPerKey(newData, newDataMultiKey, false, isGenerateSynthetic, this.outputLastUnordGroupNew, null);
    }

    @Override
    public void processJoin(Set<MultiKey<EventBean>> newData, Set<MultiKey<EventBean>> oldData, boolean isGenerateSynthetic) {
        int count;
        Object[] newDataMultiKey = this.processor.generateGroupKeys(newData, true);
        Object[] oldDataMultiKey = this.processor.generateGroupKeys(oldData, false);
        if (newData != null) {
            count = 0;
            for (MultiKey<EventBean> aNewData : newData) {
                Object mk = newDataMultiKey[count];
                this.processor.aggregationService.applyEnter(aNewData.getArray(), mk, this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (oldData != null) {
            count = 0;
            for (MultiKey<EventBean> anOldData : oldData) {
                this.processor.aggregationService.applyLeave(anOldData.getArray(), oldDataMultiKey[count], this.processor.agentInstanceContext);
                ++count;
            }
        }
        if (this.processor.prototype.isSelectRStream()) {
            this.processor.generateOutputBatchedJoinPerKey(oldData, oldDataMultiKey, false, isGenerateSynthetic, this.outputLastUnordGroupOld, null);
        }
        this.processor.generateOutputBatchedJoinPerKey(newData, newDataMultiKey, false, isGenerateSynthetic, this.outputLastUnordGroupNew, null);
    }

    @Override
    public UniformPair<EventBean[]> outputView(boolean isSynthesize) {
        return this.continueOutputLimitedLastNonBuffered();
    }

    @Override
    public UniformPair<EventBean[]> outputJoin(boolean isSynthesize) {
        return this.continueOutputLimitedLastNonBuffered();
    }

    @Override
    public void remove(Object key) {
    }

    @Override
    public void destroy() {
    }

    private UniformPair<EventBean[]> continueOutputLimitedLastNonBuffered() {
        EventBean[] newEventsArr = this.outputLastUnordGroupNew.isEmpty() ? null : this.outputLastUnordGroupNew.values().toArray(new EventBean[this.outputLastUnordGroupNew.size()]);
        EventBean[] oldEventsArr = null;
        if (this.processor.prototype.isSelectRStream()) {
            EventBean[] eventBeanArray = oldEventsArr = this.outputLastUnordGroupOld.isEmpty() ? null : this.outputLastUnordGroupOld.values().toArray(new EventBean[this.outputLastUnordGroupOld.size()]);
        }
        if (newEventsArr == null && oldEventsArr == null) {
            return null;
        }
        this.outputLastUnordGroupNew.clear();
        this.outputLastUnordGroupOld.clear();
        return new UniformPair<EventBean[]>(newEventsArr, oldEventsArr);
    }
}

