/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.agg.service.AggregationService;
import com.espertech.esper.epl.core.ResultSetProcessorRowPerGroup;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class ResultSetRowPerGroupIterator
implements Iterator<EventBean> {
    private final Iterator<EventBean> sourceIterator;
    private final ResultSetProcessorRowPerGroup resultSetProcessor;
    private final AggregationService aggregationService;
    private EventBean nextResult;
    private final EventBean[] eventsPerStream;
    private final Set<Object> priorSeenGroups;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public ResultSetRowPerGroupIterator(Iterator<EventBean> sourceIterator, ResultSetProcessorRowPerGroup resultSetProcessor, AggregationService aggregationService, ExprEvaluatorContext exprEvaluatorContext) {
        this.sourceIterator = sourceIterator;
        this.resultSetProcessor = resultSetProcessor;
        this.aggregationService = aggregationService;
        this.eventsPerStream = new EventBean[1];
        this.priorSeenGroups = new HashSet<Object>();
        this.exprEvaluatorContext = exprEvaluatorContext;
    }

    @Override
    public boolean hasNext() {
        if (this.nextResult != null) {
            return true;
        }
        this.findNext();
        return this.nextResult != null;
    }

    @Override
    public EventBean next() {
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        this.findNext();
        if (this.nextResult != null) {
            EventBean result = this.nextResult;
            this.nextResult = null;
            return result;
        }
        throw new NoSuchElementException();
    }

    private void findNext() {
        while (this.sourceIterator.hasNext()) {
            Boolean pass;
            EventBean candidate;
            this.eventsPerStream[0] = candidate = this.sourceIterator.next();
            Object groupKey = this.resultSetProcessor.generateGroupKey(this.eventsPerStream, true);
            this.aggregationService.setCurrentAccess(groupKey, this.exprEvaluatorContext.getAgentInstanceId(), null);
            if (this.resultSetProcessor.getOptionalHavingNode() != null && !(pass = (Boolean)this.resultSetProcessor.getOptionalHavingNode().evaluate(this.eventsPerStream, true, this.exprEvaluatorContext)).booleanValue() || this.priorSeenGroups.contains(groupKey)) continue;
            this.priorSeenGroups.add(groupKey);
            this.nextResult = this.resultSetProcessor.getSelectExprProcessor().process(this.eventsPerStream, true, true, this.exprEvaluatorContext);
            break;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

