/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.util.EventUnderlyingType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.service.AggregationGroupByRollupLevel;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.GroupByRollupInfo;
import com.espertech.esper.epl.core.SelectExprEventTypeRegistry;
import com.espertech.esper.epl.core.SelectExprInsertEventBeanFactory;
import com.espertech.esper.epl.core.SelectExprJoinWildcardProcessorFactory;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.SelectExprProcessorEvalByGetter;
import com.espertech.esper.epl.core.SelectExprProcessorEvalByGetterFragment;
import com.espertech.esper.epl.core.SelectExprProcessorEvalStreamInsertNamedWindow;
import com.espertech.esper.epl.core.SelectExprProcessorEvalStreamInsertTable;
import com.espertech.esper.epl.core.SelectExprProcessorEvalStreamInsertUnd;
import com.espertech.esper.epl.core.SelectExprProcessorEvalTypableMap;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.eval.EvalInsertBeanRecast;
import com.espertech.esper.epl.core.eval.EvalInsertBeanWrapRecast;
import com.espertech.esper.epl.core.eval.EvalInsertCoercionAvro;
import com.espertech.esper.epl.core.eval.EvalInsertCoercionMap;
import com.espertech.esper.epl.core.eval.EvalInsertCoercionObjectArray;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardMap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardObjectArray;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardObjectArrayRemap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardObjectArrayRemapWWiden;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardRevision;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionAvroWrap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionBean;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionBeanWrap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionBeanWrapVariant;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionMapWrap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionObjectArrayWrap;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionBean;
import com.espertech.esper.epl.core.eval.EvalInsertNoWildcardSingleColCoercionRevisionFunc;
import com.espertech.esper.epl.core.eval.EvalInsertUtil;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardBean;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardJoin;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardJoinRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardRevisionWrapper;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardSSWrapper;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardSSWrapperRevision;
import com.espertech.esper.epl.core.eval.EvalInsertWildcardWrapper;
import com.espertech.esper.epl.core.eval.EvalSelectNoWildcardEmptyProps;
import com.espertech.esper.epl.core.eval.EvalSelectNoWildcardMap;
import com.espertech.esper.epl.core.eval.EvalSelectNoWildcardObjectArray;
import com.espertech.esper.epl.core.eval.EvalSelectStreamNoUndWEventBeanToObj;
import com.espertech.esper.epl.core.eval.EvalSelectStreamNoUndWEventBeanToObjObjArray;
import com.espertech.esper.epl.core.eval.EvalSelectStreamNoUnderlyingMap;
import com.espertech.esper.epl.core.eval.EvalSelectStreamNoUnderlyingObjectArray;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUndRecastMapFactory;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUndRecastObjectArrayFactory;
import com.espertech.esper.epl.core.eval.EvalSelectStreamWUnderlying;
import com.espertech.esper.epl.core.eval.EvalSelectWildcard;
import com.espertech.esper.epl.core.eval.EvalSelectWildcardJoin;
import com.espertech.esper.epl.core.eval.EvalSelectWildcardSSWrapper;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.core.eval.SelectExprStreamDesc;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprEvaluatorTypableReturn;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.named.NamedWindowMgmtService;
import com.espertech.esper.epl.named.NamedWindowProcessor;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.rettype.EventEPType;
import com.espertech.esper.epl.rettype.EventMultiValuedEPType;
import com.espertech.esper.epl.spec.CreateSchemaDesc;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.SelectClauseExprCompiledSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamCompiledSpec;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableService;
import com.espertech.esper.event.BaseNestableEventType;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.NativeEventType;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.event.avro.AvroSchemaEventType;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.vaevent.ValueAddEventProcessor;
import com.espertech.esper.event.vaevent.ValueAddEventService;
import com.espertech.esper.event.vaevent.VariantEventType;
import com.espertech.esper.util.CollectionUtil;
import com.espertech.esper.util.EventRepresentationUtil;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.TriFunction;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerCustomizer;
import com.espertech.esper.util.TypeWidenerFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectExprProcessorHelper {
    private static final Logger log = LoggerFactory.getLogger(SelectExprProcessorHelper.class);
    private final Collection<Integer> assignedTypeNumberStack;
    private final List<SelectClauseExprCompiledSpec> selectionList;
    private final List<SelectExprStreamDesc> selectedStreams;
    private final InsertIntoDesc insertIntoDesc;
    private EventType optionalInsertIntoOverrideType;
    private final boolean isUsingWildcard;
    private final StreamTypeService typeService;
    private final EventAdapterService eventAdapterService;
    private final ValueAddEventService valueAddEventService;
    private final SelectExprEventTypeRegistry selectExprEventTypeRegistry;
    private final EngineImportService engineImportService;
    private final int statementId;
    private final String statementName;
    private final Annotation[] annotations;
    private final ConfigurationInformation configuration;
    private final NamedWindowMgmtService namedWindowMgmtService;
    private final TableService tableService;
    private final GroupByRollupInfo groupByRollupInfo;

    public SelectExprProcessorHelper(Collection<Integer> assignedTypeNumberStack, List<SelectClauseExprCompiledSpec> selectionList, List<SelectExprStreamDesc> selectedStreams, InsertIntoDesc insertIntoDesc, EventType optionalInsertIntoOverrideType, boolean isUsingWildcard, StreamTypeService typeService, EventAdapterService eventAdapterService, ValueAddEventService valueAddEventService, SelectExprEventTypeRegistry selectExprEventTypeRegistry, EngineImportService engineImportService, int statementId, String statementName, Annotation[] annotations, ConfigurationInformation configuration, NamedWindowMgmtService namedWindowMgmtService, TableService tableService, GroupByRollupInfo groupByRollupInfo) throws ExprValidationException {
        this.assignedTypeNumberStack = assignedTypeNumberStack;
        this.selectionList = selectionList;
        this.selectedStreams = selectedStreams;
        this.insertIntoDesc = insertIntoDesc;
        this.optionalInsertIntoOverrideType = optionalInsertIntoOverrideType;
        this.eventAdapterService = eventAdapterService;
        this.isUsingWildcard = isUsingWildcard;
        this.typeService = typeService;
        this.valueAddEventService = valueAddEventService;
        this.selectExprEventTypeRegistry = selectExprEventTypeRegistry;
        this.engineImportService = engineImportService;
        this.statementId = statementId;
        this.statementName = statementName;
        this.annotations = annotations;
        this.configuration = configuration;
        this.namedWindowMgmtService = namedWindowMgmtService;
        this.tableService = tableService;
        this.groupByRollupInfo = groupByRollupInfo;
    }

    public SelectExprProcessor getEvaluator() throws ExprValidationException {
        int n;
        int i;
        String[] columnNamesAsProvided;
        String[] columnNames;
        Object pair;
        ArrayList<SelectClauseStreamCompiledSpec> namedStreams = new ArrayList<SelectClauseStreamCompiledSpec>();
        ArrayList<SelectExprStreamDesc> unnamedStreams = new ArrayList<SelectExprStreamDesc>();
        for (SelectExprStreamDesc spec : this.selectedStreams) {
            if (spec.getStreamSelected() != null && spec.getStreamSelected().getOptionalName() == null || spec.getExpressionSelectedAsStream() != null) {
                unnamedStreams.add(spec);
                continue;
            }
            namedStreams.add(spec.getStreamSelected());
            if (!spec.getStreamSelected().isProperty()) continue;
            throw new ExprValidationException("The property wildcard syntax must be used without column name");
        }
        if (unnamedStreams.size() > 1) {
            throw new ExprValidationException("A column name must be supplied for all but one stream if multiple streams are selected via the stream.* notation");
        }
        if (this.selectedStreams.isEmpty() && this.selectionList.isEmpty() && !this.isUsingWildcard) {
            throw new IllegalArgumentException("Empty selection list not supported");
        }
        for (SelectClauseExprCompiledSpec entry : this.selectionList) {
            if (entry.getAssignedName() != null) continue;
            throw new IllegalArgumentException("Expected name for each expression has not been supplied");
        }
        if (this.insertIntoDesc != null) {
            SelectExprProcessorHelper.verifyInsertInto(this.insertIntoDesc, this.selectionList);
        }
        SelectExprProcessor joinWildcardProcessor = null;
        if (this.typeService.getStreamNames().length > 1 && this.isUsingWildcard) {
            joinWildcardProcessor = SelectExprJoinWildcardProcessorFactory.create(this.assignedTypeNumberStack, this.statementId, this.statementName, this.typeService.getStreamNames(), this.typeService.getEventTypes(), this.eventAdapterService, null, this.selectExprEventTypeRegistry, this.engineImportService, this.annotations, this.configuration, this.tableService, this.typeService.getEngineURIQualifier());
        }
        EventType eventType = null;
        boolean singleStreamWrapper = false;
        if (this.isUsingWildcard) {
            if (joinWildcardProcessor != null) {
                eventType = joinWildcardProcessor.getResultEventType();
            } else {
                eventType = this.typeService.getEventTypes()[0];
                if (eventType instanceof WrapperEventType) {
                    singleStreamWrapper = true;
                }
            }
        }
        EventType insertIntoTargetType = null;
        if (this.insertIntoDesc != null) {
            if (this.optionalInsertIntoOverrideType != null) {
                insertIntoTargetType = this.optionalInsertIntoOverrideType;
            } else {
                insertIntoTargetType = this.eventAdapterService.getExistsTypeByName(this.insertIntoDesc.getEventTypeName());
                TableMetadata tableMetadata = this.tableService.getTableMetadata(this.insertIntoDesc.getEventTypeName());
                if (tableMetadata != null) {
                    this.optionalInsertIntoOverrideType = insertIntoTargetType = tableMetadata.getInternalEventType();
                }
            }
        }
        EPType[] insertIntoTargetsPerCol = SelectExprProcessorHelper.determineInsertedEventTypeTargets(insertIntoTargetType, this.selectionList);
        ExprEvaluator[] exprEvaluators = new ExprEvaluator[this.selectionList.size()];
        ExprNode[] exprNodes = new ExprNode[this.selectionList.size()];
        Object[] expressionReturnTypes = new Object[this.selectionList.size()];
        for (int i2 = 0; i2 < this.selectionList.size(); ++i2) {
            Class returnTypeBoxed;
            Class clazz;
            SelectClauseExprCompiledSpec spec = this.selectionList.get(i2);
            ExprNode expr = spec.getSelectExpression();
            ExprEvaluator evaluator = expr.getExprEvaluator();
            exprNodes[i2] = expr;
            if (this.insertIntoDesc != null) {
                pair = this.handleInsertIntoEnumeration(spec.getProvidedName(), insertIntoTargetsPerCol[i2], evaluator, this.engineImportService);
                if (pair != null) {
                    expressionReturnTypes[i2] = pair.getType();
                    exprEvaluators[i2] = pair.getFunction();
                    continue;
                }
                pair = this.handleInsertIntoTypableExpression(insertIntoTargetsPerCol[i2], evaluator, this.engineImportService);
                if (pair != null) {
                    expressionReturnTypes[i2] = pair.getType();
                    exprEvaluators[i2] = pair.getFunction();
                    continue;
                }
            }
            if ((pair = this.handleAtEventbeanEnumeration(spec.isEvents(), evaluator)) != null) {
                expressionReturnTypes[i2] = pair.getType();
                exprEvaluators[i2] = pair.getFunction();
                continue;
            }
            pair = this.handleTypableExpression(evaluator, i2);
            if (pair != null) {
                expressionReturnTypes[i2] = pair.getType();
                exprEvaluators[i2] = pair.getFunction();
                continue;
            }
            if (this.groupByRollupInfo != null && this.groupByRollupInfo.getRollupDesc() != null && (clazz = evaluator.getType()) != (returnTypeBoxed = JavaClassHelper.getBoxedType(clazz)) && this.isGroupByRollupNullableExpression(expr, this.groupByRollupInfo)) {
                exprEvaluators[i2] = evaluator;
                expressionReturnTypes[i2] = returnTypeBoxed;
                continue;
            }
            exprEvaluators[i2] = evaluator;
            expressionReturnTypes[i2] = exprEvaluators[i2].getType();
        }
        if (this.insertIntoDesc != null && !this.insertIntoDesc.getColumnNames().isEmpty()) {
            columnNames = this.insertIntoDesc.getColumnNames().toArray(new String[this.insertIntoDesc.getColumnNames().size()]);
            columnNamesAsProvided = columnNames;
        } else if (!this.selectedStreams.isEmpty()) {
            int numStreamColumnsJoin = 0;
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                numStreamColumnsJoin = this.typeService.getEventTypes().length;
            }
            columnNames = new String[this.selectionList.size() + namedStreams.size() + numStreamColumnsJoin];
            columnNamesAsProvided = new String[columnNames.length];
            int count = 0;
            for (SelectClauseExprCompiledSpec selectClauseExprCompiledSpec : this.selectionList) {
                columnNames[count] = selectClauseExprCompiledSpec.getAssignedName();
                columnNamesAsProvided[count] = selectClauseExprCompiledSpec.getProvidedName();
                ++count;
            }
            for (SelectClauseStreamCompiledSpec selectClauseStreamCompiledSpec : namedStreams) {
                columnNames[count] = selectClauseStreamCompiledSpec.getOptionalName();
                columnNamesAsProvided[count] = selectClauseStreamCompiledSpec.getOptionalName();
                ++count;
            }
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                pair = this.typeService.getStreamNames();
                int n2 = ((String[])pair).length;
                for (int returnTypeBoxed = 0; returnTypeBoxed < n2; ++returnTypeBoxed) {
                    String streamName;
                    columnNames[count] = streamName = pair[returnTypeBoxed];
                    columnNamesAsProvided[count] = streamName;
                    ++count;
                }
            }
        } else {
            columnNames = new String[this.selectionList.size()];
            columnNamesAsProvided = new String[this.selectionList.size()];
            for (int i3 = 0; i3 < this.selectionList.size(); ++i3) {
                columnNames[i3] = this.selectionList.get(i3).getAssignedName();
                columnNamesAsProvided[i3] = this.selectionList.get(i3).getProvidedName();
            }
        }
        for (i = 0; i < this.selectionList.size(); ++i) {
            Class returnType;
            EventPropertyGetter getter;
            FragmentEventType fragmentType;
            if (!(exprNodes[i] instanceof ExprIdentNode)) continue;
            ExprIdentNode identNode = (ExprIdentNode)exprNodes[i];
            String propertyName = identNode.getResolvedPropertyName();
            int n3 = identNode.getStreamId();
            EventType eventTypeStream = this.typeService.getEventTypes()[n3];
            if (eventTypeStream instanceof NativeEventType || (fragmentType = eventTypeStream.getFragmentType(propertyName)) == null || fragmentType.isNative()) continue;
            FragmentEventType targetFragment = null;
            if (insertIntoTargetType != null) {
                targetFragment = insertIntoTargetType.getFragmentType(columnNames[i]);
            }
            if (insertIntoTargetType != null && fragmentType.getFragmentType().getUnderlyingType() == expressionReturnTypes[i] && (targetFragment == null || targetFragment != null && targetFragment.isNative())) {
                getter = eventTypeStream.getGetter(propertyName);
                returnType = eventTypeStream.getPropertyType(propertyName);
                exprEvaluators[i] = new SelectExprProcessorEvalByGetter(n3, getter, returnType);
                continue;
            }
            if (insertIntoTargetType != null && expressionReturnTypes[i] instanceof Class && fragmentType.getFragmentType().getUnderlyingType() == ((Class)expressionReturnTypes[i]).getComponentType() && (targetFragment == null || targetFragment != null && targetFragment.isNative())) {
                getter = eventTypeStream.getGetter(propertyName);
                returnType = JavaClassHelper.getArrayType(eventTypeStream.getPropertyType(propertyName));
                exprEvaluators[i] = new SelectExprProcessorEvalByGetter(n3, getter, returnType);
                continue;
            }
            getter = eventTypeStream.getGetter(propertyName);
            FragmentEventType fragType = eventTypeStream.getFragmentType(propertyName);
            Class undType = fragType.getFragmentType().getUnderlyingType();
            Class returnType2 = fragType.isIndexed() ? JavaClassHelper.getArrayType(undType) : undType;
            exprEvaluators[i] = new SelectExprProcessorEvalByGetterFragment(n3, getter, returnType2);
            expressionReturnTypes[i] = !fragmentType.isIndexed() ? fragmentType.getFragmentType() : new EventType[]{fragmentType.getFragmentType()};
        }
        for (i = 0; i < this.selectionList.size(); ++i) {
            Pair<ExprEvaluator, Object> pair2 = this.handleUnderlyingStreamInsert(exprEvaluators[i], this.namedWindowMgmtService, this.eventAdapterService);
            if (pair2 == null) continue;
            exprEvaluators[i] = pair2.getFirst();
            expressionReturnTypes[i] = pair2.getSecond();
        }
        LinkedHashMap<String, Object> selPropertyTypes = new LinkedHashMap<String, Object>();
        int count = 0;
        for (int i4 = 0; i4 < exprEvaluators.length; ++i4) {
            Object object = expressionReturnTypes[count];
            selPropertyTypes.put(columnNames[count], object);
            ++count;
        }
        if (!this.selectedStreams.isEmpty()) {
            for (SelectClauseStreamCompiledSpec selectClauseStreamCompiledSpec : namedStreams) {
                EventType eventTypeStream = selectClauseStreamCompiledSpec.getTableMetadata() != null ? selectClauseStreamCompiledSpec.getTableMetadata().getPublicEventType() : this.typeService.getEventTypes()[selectClauseStreamCompiledSpec.getStreamNumber()];
                selPropertyTypes.put(columnNames[count], eventTypeStream);
                ++count;
            }
            if (this.isUsingWildcard && this.typeService.getEventTypes().length > 1) {
                for (int i5 = 0; i5 < this.typeService.getEventTypes().length; ++i5) {
                    EventType eventType2 = this.typeService.getEventTypes()[i5];
                    selPropertyTypes.put(columnNames[count], eventType2);
                    ++count;
                }
            }
        }
        EventType underlyingEventType = null;
        boolean bl = false;
        boolean underlyingIsFragmentEvent = false;
        EventPropertyGetter underlyingPropertyEventGetter = null;
        ExprEvaluator underlyingExprEvaluator = null;
        EventUnderlyingType representation = EventRepresentationUtil.getRepresentation(this.annotations, this.configuration, CreateSchemaDesc.AssignedType.NONE);
        if (!(this.selectedStreams.isEmpty() || !this.isUsingWildcard && unnamedStreams.isEmpty())) {
            if (!unnamedStreams.isEmpty()) {
                if (((SelectExprStreamDesc)unnamedStreams.get(0)).getStreamSelected() != null) {
                    SelectClauseStreamCompiledSpec streamSpec = ((SelectExprStreamDesc)unnamedStreams.get(0)).getStreamSelected();
                    n = streamSpec.getStreamNumber();
                    if (streamSpec.isFragmentEvent()) {
                        EventType compositeMap = this.typeService.getEventTypes()[n];
                        FragmentEventType fragment = compositeMap.getFragmentType(streamSpec.getStreamName());
                        underlyingEventType = fragment.getFragmentType();
                        underlyingIsFragmentEvent = true;
                    } else if (streamSpec.isProperty()) {
                        String propertyName = streamSpec.getStreamName();
                        Class propertyType = streamSpec.getPropertyType();
                        int streamNumber = streamSpec.getStreamNumber();
                        if (JavaClassHelper.isJavaBuiltinDataType(streamSpec.getPropertyType())) {
                            throw new ExprValidationException("The property wildcard syntax cannot be used on built-in types as returned by property '" + propertyName + "'");
                        }
                        underlyingEventType = this.eventAdapterService.addBeanType(propertyType.getName(), propertyType, false, false, false);
                        this.selectExprEventTypeRegistry.add(underlyingEventType);
                        underlyingPropertyEventGetter = this.typeService.getEventTypes()[streamNumber].getGetter(propertyName);
                        if (underlyingPropertyEventGetter == null) {
                            throw new ExprValidationException("Unexpected error resolving property getter for property " + propertyName);
                        }
                    } else {
                        underlyingEventType = this.typeService.getEventTypes()[n];
                    }
                } else if (this.insertIntoDesc == null || insertIntoTargetType == null) {
                    ExprNode expression = ((SelectExprStreamDesc)unnamedStreams.get(0)).getExpressionSelectedAsStream().getSelectExpression();
                    Class returnType = expression.getExprEvaluator().getType();
                    if (returnType == Object[].class || JavaClassHelper.isImplementsInterface(returnType, Map.class) || JavaClassHelper.isJavaBuiltinDataType(returnType)) {
                        throw new ExprValidationException("Invalid expression return type '" + returnType.getName() + "' for transpose function");
                    }
                    underlyingEventType = this.eventAdapterService.addBeanType(returnType.getName(), returnType, false, false, false);
                    this.selectExprEventTypeRegistry.add(underlyingEventType);
                    underlyingExprEvaluator = expression.getExprEvaluator();
                }
            } else if (this.typeService.getEventTypes().length == 1) {
                underlyingEventType = this.typeService.getEventTypes()[0];
                if (underlyingEventType instanceof WrapperEventType) {
                    singleStreamWrapper = true;
                }
            } else {
                underlyingEventType = null;
            }
        }
        SelectExprContext selectExprContext = new SelectExprContext(exprEvaluators, columnNames, this.eventAdapterService);
        if (this.insertIntoDesc == null) {
            EventType resultEventType;
            if (!this.selectedStreams.isEmpty()) {
                if (underlyingEventType != null) {
                    TableMetadata tableMetadata = this.tableService.getTableMetadataFromEventType(underlyingEventType);
                    if (tableMetadata != null) {
                        underlyingEventType = tableMetadata.getPublicEventType();
                    }
                    resultEventType = this.eventAdapterService.createAnonymousWrapperType(this.statementId + "_wrapout_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), underlyingEventType, selPropertyTypes);
                    return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, singleStreamWrapper, underlyingIsFragmentEvent, n, underlyingPropertyEventGetter, underlyingExprEvaluator, tableMetadata);
                }
                resultEventType = this.eventAdapterService.createAnonymousMapType(this.statementId + "_mapout_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes, true);
                return new EvalSelectStreamNoUnderlyingMap(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard);
            }
            if (this.isUsingWildcard) {
                resultEventType = this.eventAdapterService.createAnonymousWrapperType(this.statementId + "_wrapoutwild_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), eventType, selPropertyTypes);
                if (singleStreamWrapper) {
                    return new EvalSelectWildcardSSWrapper(selectExprContext, resultEventType);
                }
                if (joinWildcardProcessor == null) {
                    return new EvalSelectWildcard(selectExprContext, resultEventType);
                }
                return new EvalSelectWildcardJoin(selectExprContext, resultEventType, joinWildcardProcessor);
            }
            resultEventType = representation == EventUnderlyingType.OBJECTARRAY ? this.eventAdapterService.createAnonymousObjectArrayType(this.statementId + "_result_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes) : (representation == EventUnderlyingType.AVRO ? this.eventAdapterService.createAnonymousAvroType(this.statementId + "_result_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes, this.annotations, this.statementName, this.typeService.getEngineURIQualifier()) : this.eventAdapterService.createAnonymousMapType(this.statementId + "_result_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes, true));
            if (selectExprContext.getExpressionNodes().length == 0) {
                return new EvalSelectNoWildcardEmptyProps(selectExprContext, resultEventType);
            }
            if (representation == EventUnderlyingType.OBJECTARRAY) {
                return new EvalSelectNoWildcardObjectArray(selectExprContext, resultEventType);
            }
            if (representation == EventUnderlyingType.AVRO) {
                return this.eventAdapterService.getEventAdapterAvroHandler().getOutputFactory().makeSelectNoWildcard(selectExprContext, resultEventType, this.tableService, this.statementName, this.typeService.getEngineURIQualifier());
            }
            return new EvalSelectNoWildcardMap(selectExprContext, resultEventType);
        }
        EventType vaeInnerEventType = null;
        boolean singleColumnWrapOrBeanCoercion = false;
        boolean isRevisionEvent = false;
        try {
            if (!this.selectedStreams.isEmpty()) {
                if (insertIntoTargetType != null && this.selectedStreams.get(0).getExpressionSelectedAsStream() != null) {
                    WrapperEventType existing;
                    if (exprEvaluators.length != 0) {
                        throw new ExprValidationException("Cannot transpose additional properties in the select-clause to target event type '" + insertIntoTargetType.getName() + "' with underlying type '" + insertIntoTargetType.getUnderlyingType().getName() + "', the " + "transpose" + " function must occur alone in the select clause");
                    }
                    ExprNode expression = ((SelectExprStreamDesc)unnamedStreams.get(0)).getExpressionSelectedAsStream().getSelectExpression();
                    Class returnType = expression.getExprEvaluator().getType();
                    if (insertIntoTargetType instanceof ObjectArrayEventType && returnType == Object[].class) {
                        return new SelectExprInsertEventBeanFactory.SelectExprInsertNativeExpressionCoerceObjectArray(insertIntoTargetType, expression.getExprEvaluator(), this.eventAdapterService);
                    }
                    if (insertIntoTargetType instanceof MapEventType && JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
                        return new SelectExprInsertEventBeanFactory.SelectExprInsertNativeExpressionCoerceMap(insertIntoTargetType, expression.getExprEvaluator(), this.eventAdapterService);
                    }
                    if (insertIntoTargetType instanceof BeanEventType && JavaClassHelper.isSubclassOrImplementsInterface(returnType, insertIntoTargetType.getUnderlyingType())) {
                        return new SelectExprInsertEventBeanFactory.SelectExprInsertNativeExpressionCoerceNative(insertIntoTargetType, expression.getExprEvaluator(), this.eventAdapterService);
                    }
                    if (insertIntoTargetType instanceof AvroSchemaEventType && returnType.getName().equals("org.apache.avro.generic.GenericData$Record")) {
                        return new SelectExprInsertEventBeanFactory.SelectExprInsertNativeExpressionCoerceAvro(insertIntoTargetType, expression.getExprEvaluator(), this.eventAdapterService);
                    }
                    if (insertIntoTargetType instanceof WrapperEventType && (existing = (WrapperEventType)insertIntoTargetType).getUnderlyingEventType() instanceof BeanEventType) {
                        BeanEventType innerType = (BeanEventType)existing.getUnderlyingEventType();
                        ExprEvaluator evalExprEvaluator = ((SelectExprStreamDesc)unnamedStreams.get(0)).getExpressionSelectedAsStream().getSelectExpression().getExprEvaluator();
                        if (!JavaClassHelper.isSubclassOrImplementsInterface(evalExprEvaluator.getType(), innerType.getUnderlyingType())) {
                            throw new ExprValidationException("Invalid expression return type '" + evalExprEvaluator.getType() + "' for transpose function, expected '" + innerType.getUnderlyingType().getSimpleName() + "'");
                        }
                        EventType resultEventType = this.eventAdapterService.addWrapperType(insertIntoTargetType.getName(), existing.getUnderlyingEventType(), selPropertyTypes, false, true);
                        return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, false, false, n, null, evalExprEvaluator, null);
                    }
                    throw EvalInsertUtil.makeEventTypeCastException(returnType, insertIntoTargetType);
                }
                if (underlyingEventType != null) {
                    if (underlyingEventType instanceof MapEventType && insertIntoTargetType instanceof MapEventType) {
                        return EvalSelectStreamWUndRecastMapFactory.make(this.typeService.getEventTypes(), selectExprContext, this.selectedStreams.get(0).getStreamSelected().getStreamNumber(), insertIntoTargetType, exprNodes, this.engineImportService, this.statementName, this.typeService.getEngineURIQualifier());
                    }
                    if (underlyingEventType instanceof ObjectArrayEventType && insertIntoTargetType instanceof ObjectArrayEventType) {
                        return EvalSelectStreamWUndRecastObjectArrayFactory.make(this.typeService.getEventTypes(), selectExprContext, this.selectedStreams.get(0).getStreamSelected().getStreamNumber(), insertIntoTargetType, exprNodes, this.engineImportService, this.statementName, this.typeService.getEngineURIQualifier());
                    }
                    if (underlyingEventType instanceof AvroSchemaEventType && insertIntoTargetType instanceof AvroSchemaEventType) {
                        return this.eventAdapterService.getEventAdapterAvroHandler().getOutputFactory().makeRecast(this.typeService.getEventTypes(), selectExprContext, this.selectedStreams.get(0).getStreamSelected().getStreamNumber(), (AvroSchemaEventType)insertIntoTargetType, exprNodes, this.statementName, this.typeService.getEngineURIQualifier());
                    }
                    if (underlyingEventType instanceof BeanEventType && insertIntoTargetType instanceof BeanEventType) {
                        return new EvalInsertBeanRecast(insertIntoTargetType, this.eventAdapterService, this.selectedStreams.get(0).getStreamSelected().getStreamNumber(), this.typeService.getEventTypes());
                    }
                    TableMetadata tableMetadata = this.tableService.getTableMetadataFromEventType(underlyingEventType);
                    if (tableMetadata != null) {
                        underlyingEventType = tableMetadata.getPublicEventType();
                    }
                    EventType resultEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName(), underlyingEventType, selPropertyTypes, false, true);
                    return new EvalSelectStreamWUnderlying(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, unnamedStreams, singleStreamWrapper, underlyingIsFragmentEvent, n, underlyingPropertyEventGetter, underlyingExprEvaluator, tableMetadata);
                }
                if (insertIntoTargetType instanceof BeanEventType) {
                    String name = this.selectedStreams.get(0).getStreamSelected().getStreamName();
                    String alias = this.selectedStreams.get(0).getStreamSelected().getOptionalName();
                    String syntaxUsed = name + ".*" + (alias != null ? " as " + alias : "");
                    String syntaxInstead = name + (alias != null ? " as " + alias : "");
                    throw new ExprValidationException("The '" + syntaxUsed + "' syntax is not allowed when inserting into an existing bean event type, use the '" + syntaxInstead + "' syntax instead");
                }
                if (insertIntoTargetType == null || insertIntoTargetType instanceof MapEventType) {
                    EventType resultEventType = this.eventAdapterService.addNestableMapType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, false, false, true);
                    Set<String> propertiesToUnwrap = SelectExprProcessorHelper.getEventBeanToObjectProps(selPropertyTypes, resultEventType);
                    if (propertiesToUnwrap.isEmpty()) {
                        return new EvalSelectStreamNoUnderlyingMap(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard);
                    }
                    return new EvalSelectStreamNoUndWEventBeanToObj(selectExprContext, resultEventType, namedStreams, this.isUsingWildcard, propertiesToUnwrap);
                }
                if (insertIntoTargetType instanceof ObjectArrayEventType) {
                    Set<String> propertiesToUnwrap = SelectExprProcessorHelper.getEventBeanToObjectProps(selPropertyTypes, insertIntoTargetType);
                    if (propertiesToUnwrap.isEmpty()) {
                        return new EvalSelectStreamNoUnderlyingObjectArray(selectExprContext, insertIntoTargetType, namedStreams, this.isUsingWildcard);
                    }
                    return new EvalSelectStreamNoUndWEventBeanToObjObjArray(selectExprContext, insertIntoTargetType, namedStreams, this.isUsingWildcard, propertiesToUnwrap);
                }
                if (insertIntoTargetType instanceof AvroSchemaEventType) {
                    throw new ExprValidationException("Avro event type does not allow contained beans");
                }
                throw new IllegalStateException("Unrecognized event type " + insertIntoTargetType);
            }
            ValueAddEventProcessor vaeProcessor = this.valueAddEventService.getValueAddProcessor(this.insertIntoDesc.getEventTypeName());
            if (this.isUsingWildcard) {
                EventType resultEventType;
                if (vaeProcessor != null) {
                    resultEventType = vaeProcessor.getValueAddEventType();
                    isRevisionEvent = true;
                    vaeProcessor.validateEventType(eventType);
                } else {
                    if (insertIntoTargetType != null) {
                        SelectExprProcessor existingTypeProcessor;
                        if (selPropertyTypes.isEmpty()) {
                            WrapperEventType wrapperType;
                            if (insertIntoTargetType instanceof BeanEventType && eventType instanceof BeanEventType) {
                                return new EvalInsertBeanRecast(insertIntoTargetType, this.eventAdapterService, 0, this.typeService.getEventTypes());
                            }
                            if (insertIntoTargetType instanceof ObjectArrayEventType && eventType instanceof ObjectArrayEventType) {
                                ObjectArrayEventType target = (ObjectArrayEventType)insertIntoTargetType;
                                ObjectArrayEventType source = (ObjectArrayEventType)eventType;
                                String msg = BaseNestableEventType.isDeepEqualsProperties(eventType.getName(), source.getTypes(), target.getTypes());
                                if (msg == null) {
                                    return new EvalInsertCoercionObjectArray(insertIntoTargetType, this.eventAdapterService);
                                }
                            }
                            if (insertIntoTargetType instanceof MapEventType && eventType instanceof MapEventType) {
                                return new EvalInsertCoercionMap(insertIntoTargetType, this.eventAdapterService);
                            }
                            if (insertIntoTargetType instanceof AvroSchemaEventType && eventType instanceof AvroSchemaEventType) {
                                return new EvalInsertCoercionAvro(insertIntoTargetType, this.eventAdapterService);
                            }
                            if (insertIntoTargetType instanceof WrapperEventType && eventType instanceof BeanEventType && (wrapperType = (WrapperEventType)insertIntoTargetType).getUnderlyingEventType() instanceof BeanEventType) {
                                return new EvalInsertBeanWrapRecast(wrapperType, this.eventAdapterService, 0, this.typeService.getEventTypes());
                            }
                        }
                        if ((existingTypeProcessor = SelectExprInsertEventBeanFactory.getInsertUnderlyingNonJoin(this.eventAdapterService, insertIntoTargetType, this.isUsingWildcard, this.typeService, exprEvaluators, columnNames, expressionReturnTypes, this.engineImportService, this.insertIntoDesc, columnNamesAsProvided, true, this.statementName)) != null) {
                            return existingTypeProcessor;
                        }
                    }
                    if (selPropertyTypes.isEmpty() && eventType instanceof BeanEventType) {
                        BeanEventType beanEventType = (BeanEventType)eventType;
                        resultEventType = this.eventAdapterService.addBeanTypeByName(this.insertIntoDesc.getEventTypeName(), beanEventType.getUnderlyingType(), false);
                    } else {
                        resultEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName(), eventType, selPropertyTypes, false, true);
                    }
                }
                if (singleStreamWrapper) {
                    if (!isRevisionEvent) {
                        return new EvalInsertWildcardSSWrapper(selectExprContext, resultEventType);
                    }
                    return new EvalInsertWildcardSSWrapperRevision(selectExprContext, resultEventType, vaeProcessor);
                }
                if (joinWildcardProcessor == null) {
                    if (!isRevisionEvent) {
                        if (resultEventType instanceof WrapperEventType) {
                            return new EvalInsertWildcardWrapper(selectExprContext, resultEventType);
                        }
                        return new EvalInsertWildcardBean(selectExprContext, resultEventType);
                    }
                    if (exprEvaluators.length == 0) {
                        return new EvalInsertWildcardRevision(selectExprContext, resultEventType, vaeProcessor);
                    }
                    EventType wrappingEventType = this.eventAdapterService.addWrapperType(this.insertIntoDesc.getEventTypeName() + "_wrapped", eventType, selPropertyTypes, false, true);
                    return new EvalInsertWildcardRevisionWrapper(selectExprContext, resultEventType, vaeProcessor, wrappingEventType);
                }
                if (!isRevisionEvent) {
                    return new EvalInsertWildcardJoin(selectExprContext, resultEventType, joinWildcardProcessor);
                }
                return new EvalInsertWildcardJoinRevision(selectExprContext, resultEventType, joinWildcardProcessor, vaeProcessor);
            }
            EventType resultEventType = null;
            if (columnNames.length == 1 && this.insertIntoDesc.getColumnNames().size() == 0 && insertIntoTargetType != null) {
                BeanEventType beanType;
                WrapperEventType wrapperType;
                Object columnOneType = expressionReturnTypes[0];
                if (insertIntoTargetType instanceof WrapperEventType && (wrapperType = (WrapperEventType)insertIntoTargetType).getUnderlyingEventType().getUnderlyingType() == columnOneType) {
                    singleColumnWrapOrBeanCoercion = true;
                    resultEventType = insertIntoTargetType;
                }
                if (insertIntoTargetType instanceof BeanEventType && columnOneType instanceof Class && JavaClassHelper.isSubclassOrImplementsInterface((Class)columnOneType, (beanType = (BeanEventType)insertIntoTargetType).getUnderlyingType())) {
                    singleColumnWrapOrBeanCoercion = true;
                    resultEventType = insertIntoTargetType;
                }
            }
            if (singleColumnWrapOrBeanCoercion) {
                if (!isRevisionEvent) {
                    if (resultEventType instanceof WrapperEventType) {
                        WrapperEventType wrapper = (WrapperEventType)resultEventType;
                        if (wrapper.getUnderlyingEventType() instanceof MapEventType) {
                            return new EvalInsertNoWildcardSingleColCoercionMapWrap(selectExprContext, wrapper);
                        }
                        if (wrapper.getUnderlyingEventType() instanceof ObjectArrayEventType) {
                            return new EvalInsertNoWildcardSingleColCoercionObjectArrayWrap(selectExprContext, wrapper);
                        }
                        if (wrapper.getUnderlyingEventType() instanceof AvroSchemaEventType) {
                            return new EvalInsertNoWildcardSingleColCoercionAvroWrap(selectExprContext, wrapper);
                        }
                        if (wrapper.getUnderlyingEventType() instanceof VariantEventType) {
                            VariantEventType variantEventType = (VariantEventType)wrapper.getUnderlyingEventType();
                            vaeProcessor = this.valueAddEventService.getValueAddProcessor(variantEventType.getName());
                            return new EvalInsertNoWildcardSingleColCoercionBeanWrapVariant(selectExprContext, wrapper, vaeProcessor);
                        }
                        return new EvalInsertNoWildcardSingleColCoercionBeanWrap(selectExprContext, wrapper);
                    }
                    if (resultEventType instanceof BeanEventType) {
                        return new EvalInsertNoWildcardSingleColCoercionBean(selectExprContext, resultEventType);
                    }
                } else {
                    if (resultEventType instanceof BeanEventType) {
                        return new EvalInsertNoWildcardSingleColCoercionRevisionBean(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
                    }
                    TriFunction<EventAdapterService, Object, EventType, EventBean> func = resultEventType instanceof MapEventType ? new TriFunction<EventAdapterService, Object, EventType, EventBean>(){

                        @Override
                        public EventBean apply(EventAdapterService eventAdapterService, Object und, EventType type) {
                            return eventAdapterService.adapterForTypedMap((Map)und, type);
                        }
                    } : (resultEventType instanceof ObjectArrayEventType ? new TriFunction<EventAdapterService, Object, EventType, EventBean>(){

                        @Override
                        public EventBean apply(EventAdapterService eventAdapterService, Object und, EventType type) {
                            return eventAdapterService.adapterForTypedObjectArray((Object[])und, type);
                        }
                    } : (resultEventType instanceof AvroSchemaEventType ? new TriFunction<EventAdapterService, Object, EventType, EventBean>(){

                        @Override
                        public EventBean apply(EventAdapterService eventAdapterService, Object und, EventType type) {
                            return eventAdapterService.adapterForTypedAvro(und, type);
                        }
                    } : new TriFunction<EventAdapterService, Object, EventType, EventBean>(){

                        @Override
                        public EventBean apply(EventAdapterService eventAdapterService, Object und, EventType type) {
                            return eventAdapterService.adapterForTypedBean(und, type);
                        }
                    }));
                    return new EvalInsertNoWildcardSingleColCoercionRevisionFunc(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType, func);
                }
            }
            if (resultEventType == null) {
                if (vaeProcessor != null) {
                    if (this.valueAddEventService.getValueAddProcessor(this.insertIntoDesc.getEventTypeName()) == null) {
                        resultEventType = this.eventAdapterService.createAnonymousMapType(this.statementId + "_vae_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_"), selPropertyTypes, true);
                    } else {
                        String statementName = "stmt_" + this.statementId + "_insert";
                        resultEventType = this.eventAdapterService.addNestableMapType(statementName, selPropertyTypes, null, false, false, false, false, true);
                    }
                } else {
                    EventType existingType = insertIntoTargetType;
                    if (existingType == null) {
                        Class clazz = null;
                        try {
                            clazz = this.engineImportService.resolveClass(this.insertIntoDesc.getEventTypeName(), false);
                        }
                        catch (EngineImportException e) {
                            log.debug("Target stream name '" + this.insertIntoDesc.getEventTypeName() + "' is not resolved as a class name");
                        }
                        if (clazz != null) {
                            existingType = this.eventAdapterService.addBeanType(clazz.getName(), clazz, false, false, false);
                        }
                    }
                    SelectExprProcessor selectExprInsertEventBean = null;
                    if (existingType != null) {
                        selectExprInsertEventBean = SelectExprInsertEventBeanFactory.getInsertUnderlyingNonJoin(this.eventAdapterService, existingType, this.isUsingWildcard, this.typeService, exprEvaluators, columnNames, expressionReturnTypes, this.engineImportService, this.insertIntoDesc, columnNamesAsProvided, false, this.statementName);
                    }
                    if (selectExprInsertEventBean != null) {
                        return selectExprInsertEventBean;
                    }
                    if (this.optionalInsertIntoOverrideType != null) {
                        resultEventType = insertIntoTargetType;
                    } else if (existingType instanceof AvroSchemaEventType) {
                        this.eventAdapterService.getEventAdapterAvroHandler().avroCompat(existingType, selPropertyTypes);
                        resultEventType = existingType;
                    } else {
                        EventUnderlyingType out = EventRepresentationUtil.getRepresentation(this.annotations, this.configuration, CreateSchemaDesc.AssignedType.NONE);
                        if (out == EventUnderlyingType.MAP) {
                            resultEventType = this.eventAdapterService.addNestableMapType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, false, false, true);
                        } else if (out == EventUnderlyingType.OBJECTARRAY) {
                            resultEventType = this.eventAdapterService.addNestableObjectArrayType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, null, false, false, false, false, true, false, null);
                        } else if (out == EventUnderlyingType.AVRO) {
                            resultEventType = this.eventAdapterService.addAvroType(this.insertIntoDesc.getEventTypeName(), selPropertyTypes, false, false, false, false, true, this.annotations, null, this.statementName, this.typeService.getEngineURIQualifier());
                        } else {
                            throw new IllegalStateException("Unrecognized code " + (Object)((Object)out));
                        }
                    }
                }
            }
            if (vaeProcessor != null) {
                vaeProcessor.validateEventType(resultEventType);
                vaeInnerEventType = resultEventType;
                resultEventType = vaeProcessor.getValueAddEventType();
                isRevisionEvent = true;
            }
            if (!isRevisionEvent) {
                if (resultEventType instanceof MapEventType) {
                    return new EvalInsertNoWildcardMap(selectExprContext, resultEventType);
                }
                if (resultEventType instanceof ObjectArrayEventType) {
                    return this.makeObjectArrayConsiderReorder(selectExprContext, (ObjectArrayEventType)resultEventType, this.statementName, this.typeService.getEngineURIQualifier());
                }
                if (resultEventType instanceof AvroSchemaEventType) {
                    return this.eventAdapterService.getEventAdapterAvroHandler().getOutputFactory().makeSelectNoWildcard(selectExprContext, resultEventType, this.tableService, this.statementName, this.typeService.getEngineURIQualifier());
                }
                throw new IllegalStateException("Unrecognized output type " + resultEventType);
            }
            return new EvalInsertNoWildcardRevision(selectExprContext, resultEventType, vaeProcessor, vaeInnerEventType);
        }
        catch (EventAdapterException ex) {
            log.debug("Exception provided by event adapter: " + ex.getMessage(), (Throwable)ex);
            throw new ExprValidationException(ex.getMessage(), ex);
        }
    }

    private boolean isGroupByRollupNullableExpression(ExprNode expr, GroupByRollupInfo groupByRollupInfo) {
        for (AggregationGroupByRollupLevel level : groupByRollupInfo.getRollupDesc().getLevels()) {
            if (level.isAggregationTop()) {
                return true;
            }
            boolean found = false;
            for (int rollupKeyIndex : level.getRollupKeys()) {
                ExprNode groupExpression = groupByRollupInfo.getExprNodes()[rollupKeyIndex];
                if (!ExprNodeUtility.deepEquals(groupExpression, expr, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    private SelectExprProcessor makeObjectArrayConsiderReorder(SelectExprContext selectExprContext, ObjectArrayEventType resultEventType, String statementName, String engineURI) throws ExprValidationException {
        TypeWidener[] wideners = new TypeWidener[selectExprContext.getColumnNames().length];
        int[] remapped = new int[selectExprContext.getColumnNames().length];
        boolean needRemap = false;
        for (int i = 0; i < selectExprContext.getColumnNames().length; ++i) {
            String colName = selectExprContext.getColumnNames()[i];
            int index = CollectionUtil.findItem(resultEventType.getPropertyNames(), colName);
            if (index == -1) {
                throw new ExprValidationException("Could not find property '" + colName + "' in " + this.getTypeNameConsiderTable(resultEventType, this.tableService));
            }
            remapped[i] = index;
            if (index != i) {
                needRemap = true;
            }
            Class sourceColumnType = selectExprContext.getExpressionNodes()[i].getType();
            Class targetPropType = resultEventType.getPropertyType(colName);
            wideners[i] = TypeWidenerFactory.getCheckPropertyAssignType(colName, sourceColumnType, targetPropType, colName, false, this.eventAdapterService.getTypeWidenerCustomizer(resultEventType), statementName, engineURI);
        }
        if (!needRemap) {
            return new EvalInsertNoWildcardObjectArray(selectExprContext, resultEventType);
        }
        if (CollectionUtil.isAllNullArray(wideners)) {
            return new EvalInsertNoWildcardObjectArrayRemap(selectExprContext, resultEventType, remapped);
        }
        return new EvalInsertNoWildcardObjectArrayRemapWWiden(selectExprContext, resultEventType, remapped, wideners);
    }

    private String getTypeNameConsiderTable(ObjectArrayEventType resultEventType, TableService tableService) {
        TableMetadata metadata = tableService.getTableMetadataFromEventType(resultEventType);
        if (metadata != null) {
            return "table '" + metadata.getTableName() + "'";
        }
        return "type '" + resultEventType.getName() + "'";
    }

    private Pair<ExprEvaluator, Object> handleUnderlyingStreamInsert(ExprEvaluator exprEvaluator, NamedWindowMgmtService namedWindowMgmtService, EventAdapterService eventAdapterService) {
        ExprEvaluator evaluator;
        EventType eventTypeStream;
        if (!(exprEvaluator instanceof ExprStreamUnderlyingNode)) {
            return null;
        }
        ExprStreamUnderlyingNode undNode = (ExprStreamUnderlyingNode)((Object)exprEvaluator);
        int streamNum = undNode.getStreamId();
        Class returnType = undNode.getExprEvaluator().getType();
        EventType namedWindowAsType = this.getNamedWindowUnderlyingType(namedWindowMgmtService, eventAdapterService, this.typeService.getEventTypes()[streamNum]);
        TableMetadata tableMetadata = this.tableService.getTableMetadataFromEventType(this.typeService.getEventTypes()[streamNum]);
        if (tableMetadata != null) {
            eventTypeStream = tableMetadata.getPublicEventType();
            evaluator = new SelectExprProcessorEvalStreamInsertTable(streamNum, undNode, tableMetadata, returnType);
        } else if (namedWindowAsType == null) {
            eventTypeStream = this.typeService.getEventTypes()[streamNum];
            evaluator = new SelectExprProcessorEvalStreamInsertUnd(undNode, streamNum, returnType);
        } else {
            eventTypeStream = namedWindowAsType;
            evaluator = new SelectExprProcessorEvalStreamInsertNamedWindow(streamNum, namedWindowAsType, returnType, eventAdapterService);
        }
        return new Pair<ExprEvaluator, Object>(evaluator, eventTypeStream);
    }

    private EventType getNamedWindowUnderlyingType(NamedWindowMgmtService namedWindowMgmtService, EventAdapterService eventAdapterService, EventType eventType) {
        if (!namedWindowMgmtService.isNamedWindow(eventType.getName())) {
            return null;
        }
        NamedWindowProcessor processor = namedWindowMgmtService.getProcessor(eventType.getName());
        if (processor.getEventTypeAsName() == null) {
            return null;
        }
        return eventAdapterService.getExistsTypeByName(processor.getEventTypeAsName());
    }

    private static EPType[] determineInsertedEventTypeTargets(EventType targetType, List<SelectClauseExprCompiledSpec> selectionList) {
        EPType[] targets = new EPType[selectionList.size()];
        if (targetType == null) {
            return targets;
        }
        for (int i = 0; i < selectionList.size(); ++i) {
            FragmentEventType fragmentEventType;
            EventPropertyDescriptor desc;
            SelectClauseExprCompiledSpec expr = selectionList.get(i);
            if (expr.getProvidedName() == null || (desc = targetType.getPropertyDescriptor(expr.getProvidedName())) == null || !desc.isFragment() || (fragmentEventType = targetType.getFragmentType(expr.getProvidedName())) == null) continue;
            targets[i] = fragmentEventType.isIndexed() ? EPTypeHelper.collectionOfEvents(fragmentEventType.getFragmentType()) : EPTypeHelper.singleEvent(fragmentEventType.getFragmentType());
        }
        return targets;
    }

    private TypeAndFunctionPair handleTypableExpression(ExprEvaluator exprEvaluator, int expressionNum) throws ExprValidationException {
        if (!(exprEvaluator instanceof ExprEvaluatorTypableReturn)) {
            return null;
        }
        ExprEvaluatorTypableReturn typable = (ExprEvaluatorTypableReturn)exprEvaluator;
        LinkedHashMap<String, Object> eventTypeExpr = typable.getRowProperties();
        if (eventTypeExpr == null) {
            return null;
        }
        EventType mapType = this.eventAdapterService.createAnonymousMapType(this.statementId + "_innereval_" + CollectionUtil.toString(this.assignedTypeNumberStack, "_") + "_" + expressionNum, eventTypeExpr, true);
        SelectExprProcessorEvalTypableMap evaluatorFragment = new SelectExprProcessorEvalTypableMap(mapType, exprEvaluator, this.eventAdapterService);
        return new TypeAndFunctionPair(mapType, evaluatorFragment);
    }

    private TypeAndFunctionPair handleInsertIntoEnumeration(String insertIntoColName, EPType insertIntoTarget, ExprEvaluator exprEvaluator, EngineImportService engineImportService) throws ExprValidationException {
        EventType sourceType;
        if (!(exprEvaluator instanceof ExprEvaluatorEnumeration) || insertIntoTarget == null || !EPTypeHelper.isCarryEvent(insertIntoTarget)) {
            return null;
        }
        final ExprEvaluatorEnumeration enumeration = (ExprEvaluatorEnumeration)((Object)exprEvaluator);
        EventType eventTypeSingle = enumeration.getEventTypeSingle(this.eventAdapterService, this.statementId);
        EventType eventTypeColl = enumeration.getEventTypeCollection(this.eventAdapterService, this.statementId);
        EventType eventType = sourceType = eventTypeSingle != null ? eventTypeSingle : eventTypeColl;
        if (eventTypeColl == null && eventTypeSingle == null) {
            return null;
        }
        if (((EventTypeSPI)sourceType).getMetadata().getTypeClass() == EventTypeMetadata.TypeClass.ANONYMOUS) {
            return null;
        }
        final EventType targetType = EPTypeHelper.getEventType(insertIntoTarget);
        this.checkTypeCompatible(insertIntoColName, targetType, sourceType);
        if (insertIntoTarget instanceof EventMultiValuedEPType) {
            if (eventTypeColl != null) {
                ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        Collection<EventBean> events = enumeration.evaluateGetROCollectionEvents(eventsPerStream, isNewData, exprEvaluatorContext);
                        if (events == null) {
                            return null;
                        }
                        return events.toArray(new EventBean[events.size()]);
                    }

                    @Override
                    public Class getType() {
                        return JavaClassHelper.getArrayType(targetType.getUnderlyingType());
                    }
                };
                return new TypeAndFunctionPair(new EventType[]{targetType}, evaluatorFragment);
            }
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean event = enumeration.evaluateGetEventBean(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (event == null) {
                        return null;
                    }
                    return new EventBean[]{event};
                }

                @Override
                public Class getType() {
                    return JavaClassHelper.getArrayType(targetType.getUnderlyingType());
                }
            };
            return new TypeAndFunctionPair(new EventType[]{targetType}, evaluatorFragment);
        }
        if (eventTypeSingle != null) {
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    return enumeration.evaluateGetEventBean(eventsPerStream, isNewData, exprEvaluatorContext);
                }

                @Override
                public Class getType() {
                    return targetType.getUnderlyingType();
                }
            };
            return new TypeAndFunctionPair(targetType, evaluatorFragment);
        }
        ExprEvaluator evaluatorFragment = new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                Collection<EventBean> events = enumeration.evaluateGetROCollectionEvents(eventsPerStream, isNewData, exprEvaluatorContext);
                if (events == null || events.size() == 0) {
                    return null;
                }
                return EventBeanUtility.getNonemptyFirstEvent(events);
            }

            @Override
            public Class getType() {
                return targetType.getUnderlyingType();
            }
        };
        return new TypeAndFunctionPair(targetType, evaluatorFragment);
    }

    private void checkTypeCompatible(String insertIntoCol, EventType targetType, EventType selectedType) throws ExprValidationException {
        if (!EventTypeUtility.isTypeOrSubTypeOf(targetType, selectedType)) {
            throw new ExprValidationException("Incompatible type detected attempting to insert into column '" + insertIntoCol + "' type '" + targetType.getName() + "' compared to selected type '" + selectedType.getName() + "'");
        }
    }

    private TypeAndFunctionPair handleInsertIntoTypableExpression(EPType insertIntoTarget, ExprEvaluator exprEvaluator, EngineImportService engineImportService) throws ExprValidationException {
        EventBeanManufacturer manufacturer;
        if (!(exprEvaluator instanceof ExprEvaluatorTypableReturn) || insertIntoTarget == null || !EPTypeHelper.isCarryEvent(insertIntoTarget)) {
            return null;
        }
        final EventType targetType = EPTypeHelper.getEventType(insertIntoTarget);
        final ExprEvaluatorTypableReturn typable = (ExprEvaluatorTypableReturn)exprEvaluator;
        if (typable.isMultirow() == null) {
            return null;
        }
        LinkedHashMap<String, Object> eventTypeExpr = typable.getRowProperties();
        if (eventTypeExpr == null) {
            return null;
        }
        Set<WriteablePropertyDescriptor> writables = this.eventAdapterService.getWriteableProperties(targetType, false);
        ArrayList<WriteablePropertyDescriptor> written = new ArrayList<WriteablePropertyDescriptor>();
        ArrayList<Map.Entry<String, Object>> writtenOffered = new ArrayList<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> offeredProperty : eventTypeExpr.entrySet()) {
            WriteablePropertyDescriptor writable = EventTypeUtility.findWritable(offeredProperty.getKey(), writables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find property '" + offeredProperty.getKey() + "' among properties for target event type '" + targetType.getName() + "'");
            }
            written.add(writable);
            writtenOffered.add(offeredProperty);
        }
        final TypeWidener[] wideners = new TypeWidener[written.size()];
        TypeWidenerCustomizer typeWidenerCustomizer = this.eventAdapterService.getTypeWidenerCustomizer(targetType);
        for (int i = 0; i < written.size(); ++i) {
            Class expected = ((WriteablePropertyDescriptor)written.get(i)).getType();
            Map.Entry provided = (Map.Entry)writtenOffered.get(i);
            if (!(provided.getValue() instanceof Class)) continue;
            wideners[i] = TypeWidenerFactory.getCheckPropertyAssignType((String)provided.getKey(), (Class)provided.getValue(), expected, ((WriteablePropertyDescriptor)written.get(i)).getPropertyName(), false, typeWidenerCustomizer, this.statementName, this.typeService.getEngineURIQualifier());
        }
        final boolean hasWideners = !CollectionUtil.isAllNullArray(wideners);
        WriteablePropertyDescriptor[] writtenArray = written.toArray(new WriteablePropertyDescriptor[written.size()]);
        try {
            manufacturer = this.eventAdapterService.getManufacturer(targetType, writtenArray, engineImportService, false);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException("Failed to obtain eventbean factory: " + e.getMessage(), e);
        }
        final EventBeanManufacturer factory = manufacturer;
        if (insertIntoTarget instanceof EventMultiValuedEPType && typable.isMultirow().booleanValue()) {
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    Object[][] rows = typable.evaluateTypableMulti(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (rows == null) {
                        return null;
                    }
                    if (rows.length == 0) {
                        return new EventBean[0];
                    }
                    if (hasWideners) {
                        SelectExprProcessorHelper.this.applyWideners(rows, wideners);
                    }
                    EventBean[] events = new EventBean[rows.length];
                    for (int i = 0; i < events.length; ++i) {
                        events[i] = factory.make(rows[i]);
                    }
                    return events;
                }

                @Override
                public Class getType() {
                    return JavaClassHelper.getArrayType(targetType.getUnderlyingType());
                }
            };
            return new TypeAndFunctionPair(new EventType[]{targetType}, evaluatorFragment);
        }
        if (insertIntoTarget instanceof EventMultiValuedEPType && !typable.isMultirow().booleanValue()) {
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    Object[] row = typable.evaluateTypableSingle(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (row == null) {
                        return null;
                    }
                    if (hasWideners) {
                        SelectExprProcessorHelper.this.applyWideners(row, wideners);
                    }
                    return new EventBean[]{factory.make(row)};
                }

                @Override
                public Class getType() {
                    return JavaClassHelper.getArrayType(targetType.getUnderlyingType());
                }
            };
            return new TypeAndFunctionPair(new EventType[]{targetType}, evaluatorFragment);
        }
        if (insertIntoTarget instanceof EventEPType && !typable.isMultirow().booleanValue()) {
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    Object[] row = typable.evaluateTypableSingle(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (row == null) {
                        return null;
                    }
                    if (hasWideners) {
                        SelectExprProcessorHelper.this.applyWideners(row, wideners);
                    }
                    return factory.make(row);
                }

                @Override
                public Class getType() {
                    return JavaClassHelper.getArrayType(targetType.getUnderlyingType());
                }
            };
            return new TypeAndFunctionPair(targetType, evaluatorFragment);
        }
        ExprEvaluator evaluatorFragment = new ExprEvaluator(){

            @Override
            public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                Object[][] rows = typable.evaluateTypableMulti(eventsPerStream, isNewData, exprEvaluatorContext);
                if (rows == null) {
                    return null;
                }
                if (rows.length == 0) {
                    return new EventBean[0];
                }
                if (hasWideners) {
                    SelectExprProcessorHelper.this.applyWideners(rows[0], wideners);
                }
                return factory.make(rows[0]);
            }

            @Override
            public Class getType() {
                return JavaClassHelper.getArrayType(targetType.getUnderlyingType());
            }
        };
        return new TypeAndFunctionPair(targetType, evaluatorFragment);
    }

    private void applyWideners(Object[] row, TypeWidener[] wideners) {
        for (int i = 0; i < wideners.length; ++i) {
            if (wideners[i] == null) continue;
            row[i] = wideners[i].widen(row[i]);
        }
    }

    private void applyWideners(Object[][] rows, TypeWidener[] wideners) {
        for (Object[] row : rows) {
            this.applyWideners(row, wideners);
        }
    }

    private TypeAndFunctionPair handleAtEventbeanEnumeration(boolean isEventBeans, ExprEvaluator evaluator) throws ExprValidationException {
        if (!(evaluator instanceof ExprEvaluatorEnumeration) || !isEventBeans) {
            return null;
        }
        final ExprEvaluatorEnumeration enumEval = (ExprEvaluatorEnumeration)((Object)evaluator);
        final EventType eventTypeSingle = enumEval.getEventTypeSingle(this.eventAdapterService, this.statementId);
        if (eventTypeSingle != null) {
            final TableMetadata tableMetadata = this.tableService.getTableMetadataFromEventType(eventTypeSingle);
            if (tableMetadata == null) {
                ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        return enumEval.evaluateGetEventBean(eventsPerStream, isNewData, exprEvaluatorContext);
                    }

                    @Override
                    public Class getType() {
                        return eventTypeSingle.getUnderlyingType();
                    }
                };
                return new TypeAndFunctionPair(eventTypeSingle, evaluatorFragment);
            }
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    EventBean event = enumEval.evaluateGetEventBean(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (event == null) {
                        return null;
                    }
                    return tableMetadata.getEventToPublic().convert(event, eventsPerStream, isNewData, exprEvaluatorContext);
                }

                @Override
                public Class getType() {
                    return tableMetadata.getPublicEventType().getUnderlyingType();
                }
            };
            return new TypeAndFunctionPair(tableMetadata.getPublicEventType(), evaluatorFragment);
        }
        final EventType eventTypeColl = enumEval.getEventTypeCollection(this.eventAdapterService, this.statementId);
        if (eventTypeColl != null) {
            final TableMetadata tableMetadata = this.tableService.getTableMetadataFromEventType(eventTypeColl);
            if (tableMetadata == null) {
                ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                    @Override
                    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                        Collection<EventBean> result = enumEval.evaluateGetROCollectionEvents(eventsPerStream, isNewData, exprEvaluatorContext);
                        if (result != null && result instanceof Collection) {
                            Collection<EventBean> events = result;
                            return events.toArray(new EventBean[events.size()]);
                        }
                        return result;
                    }

                    @Override
                    public Class getType() {
                        return JavaClassHelper.getArrayType(eventTypeColl.getUnderlyingType());
                    }
                };
                return new TypeAndFunctionPair(new EventType[]{eventTypeColl}, evaluatorFragment);
            }
            ExprEvaluator evaluatorFragment = new ExprEvaluator(){

                @Override
                public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
                    Collection<EventBean> result = enumEval.evaluateGetROCollectionEvents(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (result == null) {
                        return null;
                    }
                    if (result instanceof Collection) {
                        Collection<EventBean> events = result;
                        EventBean[] out = new EventBean[events.size()];
                        int index = 0;
                        for (EventBean event : events) {
                            out[index++] = tableMetadata.getEventToPublic().convert(event, eventsPerStream, isNewData, exprEvaluatorContext);
                        }
                        return out;
                    }
                    EventBean[] events = (EventBean[])result;
                    for (int i = 0; i < events.length; ++i) {
                        events[i] = tableMetadata.getEventToPublic().convert(events[i], eventsPerStream, isNewData, exprEvaluatorContext);
                    }
                    return events;
                }

                @Override
                public Class getType() {
                    return JavaClassHelper.getArrayType(tableMetadata.getPublicEventType().getUnderlyingType());
                }
            };
            return new TypeAndFunctionPair(new EventType[]{tableMetadata.getPublicEventType()}, evaluatorFragment);
        }
        return null;
    }

    private static Set<String> getEventBeanToObjectProps(Map<String, Object> selPropertyTypes, EventType resultEventType) {
        if (!(resultEventType instanceof BaseNestableEventType)) {
            return Collections.emptySet();
        }
        BaseNestableEventType mapEventType = (BaseNestableEventType)resultEventType;
        HashSet<String> props = null;
        for (Map.Entry<String, Object> entry : selPropertyTypes.entrySet()) {
            if (!(entry.getValue() instanceof BeanEventType) || !(mapEventType.getTypes().get(entry.getKey()) instanceof Class)) continue;
            if (props == null) {
                props = new HashSet<String>();
            }
            props.add(entry.getKey());
        }
        if (props == null) {
            return Collections.emptySet();
        }
        return props;
    }

    private static void verifyInsertInto(InsertIntoDesc insertIntoDesc, List<SelectClauseExprCompiledSpec> selectionList) throws ExprValidationException {
        HashSet<String> names = new HashSet<String>();
        for (String element : insertIntoDesc.getColumnNames()) {
            if (names.contains(element)) {
                throw new ExprValidationException("Property name '" + element + "' appears more then once in insert-into clause");
            }
            names.add(element);
        }
        if (!insertIntoDesc.getColumnNames().isEmpty() && insertIntoDesc.getColumnNames().size() != selectionList.size()) {
            throw new ExprValidationException("Number of supplied values in the select or values clause does not match insert-into clause");
        }
    }

    private static class TypeAndFunctionPair {
        private final Object type;
        private final ExprEvaluator function;

        private TypeAndFunctionPair(Object type, ExprEvaluator function) {
            this.type = type;
            this.function = function;
        }

        public Object getType() {
            return this.type;
        }

        public ExprEvaluator getFunction() {
            return this.function;
        }
    }
}

