/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.eval.EvalInsertUtil;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.Collections;

public class EvalInsertBeanWrapRecast
implements SelectExprProcessor {
    private final WrapperEventType eventType;
    private final EventAdapterService eventAdapterService;
    private final int streamNumber;

    public EvalInsertBeanWrapRecast(WrapperEventType targetType, EventAdapterService eventAdapterService, int streamNumber, EventType[] typesPerStream) throws ExprValidationException {
        this.eventType = targetType;
        this.eventAdapterService = eventAdapterService;
        this.streamNumber = streamNumber;
        EventType sourceType = typesPerStream[streamNumber];
        Class sourceClass = sourceType.getUnderlyingType();
        Class targetClass = targetType.getUnderlyingEventType().getUnderlyingType();
        if (!JavaClassHelper.isSubclassOrImplementsInterface(sourceClass, targetClass)) {
            throw EvalInsertUtil.makeEventTypeCastException(sourceType, (EventType)targetType);
        }
    }

    @Override
    public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
        EventBean theEvent = eventsPerStream[this.streamNumber];
        EventBean recast = this.eventAdapterService.adapterForTypedBean(theEvent.getUnderlying(), this.eventType.getUnderlyingEventType());
        return this.eventAdapterService.adapterForTypedWrapper(recast, Collections.emptyMap(), this.eventType);
    }

    @Override
    public EventType getResultEventType() {
        return this.eventType;
    }
}

