/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.core.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.SelectExprProcessor;
import com.espertech.esper.epl.core.eval.SelectExprContext;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.BaseNestableEventUtil;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.ObjectArrayBackedEventBean;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.TypeWidener;
import com.espertech.esper.util.TypeWidenerFactory;
import java.util.ArrayList;
import java.util.Set;

public class EvalSelectStreamWUndRecastObjectArrayFactory {
    public static SelectExprProcessor make(EventType[] eventTypes, SelectExprContext selectExprContext, int streamNumber, EventType targetType, ExprNode[] exprNodes, EngineImportService engineImportService, String statementName, String engineURI) throws ExprValidationException {
        EventBeanManufacturer manufacturer;
        ObjectArrayEventType oaResultType = (ObjectArrayEventType)targetType;
        ObjectArrayEventType oaStreamType = (ObjectArrayEventType)eventTypes[streamNumber];
        if (oaResultType.isDeepEqualsConsiderOrder(oaStreamType) && selectExprContext.getExpressionNodes().length == 0) {
            return new OAInsertProcessorSimpleRepackage(selectExprContext, streamNumber, targetType);
        }
        Set<WriteablePropertyDescriptor> writables = selectExprContext.getEventAdapterService().getWriteableProperties(oaResultType, true);
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<WriteablePropertyDescriptor> written = new ArrayList<WriteablePropertyDescriptor>();
        for (WriteablePropertyDescriptor writeable : writables) {
            boolean setTwoTypeFound;
            Object setTwoType;
            String propertyName = writeable.getPropertyName();
            Integer indexSource = oaStreamType.getPropertiesIndexes().get(propertyName);
            Integer indexTarget = oaResultType.getPropertiesIndexes().get(propertyName);
            if (indexSource == null) continue;
            Object setOneType = oaStreamType.getTypes().get(propertyName);
            String message = BaseNestableEventUtil.comparePropType(propertyName, setOneType, setTwoType = oaResultType.getTypes().get(propertyName), setTwoTypeFound = oaResultType.getTypes().containsKey(propertyName), oaResultType.getName());
            if (message != null) {
                throw new ExprValidationException(message);
            }
            items.add(new Item(indexTarget, indexSource, null, null));
            written.add(writeable);
        }
        int count = written.size();
        for (int i = 0; i < selectExprContext.getExpressionNodes().length; ++i) {
            String columnName = selectExprContext.getColumnNames()[i];
            ExprEvaluator evaluator = selectExprContext.getExpressionNodes()[i];
            ExprNode exprNode = exprNodes[i];
            WriteablePropertyDescriptor writable = EvalSelectStreamWUndRecastObjectArrayFactory.findWritable(columnName, writables);
            if (writable == null) {
                throw new ExprValidationException("Failed to find column '" + columnName + "' in target type '" + oaResultType.getName() + "'");
            }
            TypeWidener widener = TypeWidenerFactory.getCheckPropertyAssignType(ExprNodeUtility.toExpressionStringMinPrecedenceSafe(exprNode), exprNode.getExprEvaluator().getType(), writable.getType(), columnName, false, null, statementName, engineURI);
            items.add(new Item(count, -1, evaluator, widener));
            written.add(writable);
            ++count;
        }
        Item[] itemsArr = items.toArray(new Item[items.size()]);
        try {
            manufacturer = selectExprContext.getEventAdapterService().getManufacturer(oaResultType, written.toArray(new WriteablePropertyDescriptor[written.size()]), engineImportService, true);
        }
        catch (EventBeanManufactureException e) {
            throw new ExprValidationException("Failed to write to type: " + e.getMessage(), e);
        }
        return new OAInsertProcessorAllocate(streamNumber, itemsArr, manufacturer, targetType);
    }

    private static WriteablePropertyDescriptor findWritable(String columnName, Set<WriteablePropertyDescriptor> writables) {
        for (WriteablePropertyDescriptor writable : writables) {
            if (!writable.getPropertyName().equals(columnName)) continue;
            return writable;
        }
        return null;
    }

    private static class Item {
        private final int toIndex;
        private final int optionalFromIndex;
        private final ExprEvaluator evaluator;
        private final TypeWidener optionalWidener;

        private Item(int toIndex, int optionalFromIndex, ExprEvaluator evaluator, TypeWidener optionalWidener) {
            this.toIndex = toIndex;
            this.optionalFromIndex = optionalFromIndex;
            this.evaluator = evaluator;
            this.optionalWidener = optionalWidener;
        }

        public int getToIndex() {
            return this.toIndex;
        }

        public int getOptionalFromIndex() {
            return this.optionalFromIndex;
        }

        public ExprEvaluator getEvaluator() {
            return this.evaluator;
        }

        public TypeWidener getOptionalWidener() {
            return this.optionalWidener;
        }
    }

    private static class OAInsertProcessorAllocate
    implements SelectExprProcessor {
        private final int underlyingStreamNumber;
        private final Item[] items;
        private final EventBeanManufacturer manufacturer;
        private final EventType resultType;

        private OAInsertProcessorAllocate(int underlyingStreamNumber, Item[] items, EventBeanManufacturer manufacturer, EventType resultType) {
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.items = items;
            this.manufacturer = manufacturer;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            ObjectArrayBackedEventBean theEvent = (ObjectArrayBackedEventBean)eventsPerStream[this.underlyingStreamNumber];
            Object[] props = new Object[this.items.length];
            for (Item item : this.items) {
                Object value;
                if (item.getOptionalFromIndex() != -1) {
                    value = theEvent.getProperties()[item.getOptionalFromIndex()];
                } else {
                    value = item.getEvaluator().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                    if (item.getOptionalWidener() != null) {
                        value = item.getOptionalWidener().widen(value);
                    }
                }
                props[item.getToIndex()] = value;
            }
            return this.manufacturer.make(props);
        }
    }

    private static class OAInsertProcessorSimpleRepackage
    implements SelectExprProcessor {
        private final SelectExprContext selectExprContext;
        private final int underlyingStreamNumber;
        private final EventType resultType;

        private OAInsertProcessorSimpleRepackage(SelectExprContext selectExprContext, int underlyingStreamNumber, EventType resultType) {
            this.selectExprContext = selectExprContext;
            this.underlyingStreamNumber = underlyingStreamNumber;
            this.resultType = resultType;
        }

        @Override
        public EventType getResultEventType() {
            return this.resultType;
        }

        @Override
        public EventBean process(EventBean[] eventsPerStream, boolean isNewData, boolean isSynthesize, ExprEvaluatorContext exprEvaluatorContext) {
            ObjectArrayBackedEventBean theEvent = (ObjectArrayBackedEventBean)eventsPerStream[this.underlyingStreamNumber];
            return this.selectExprContext.getEventAdapterService().adapterForTypedObjectArray(theEvent.getProperties(), this.resultType);
        }
    }
}

