/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.CalendarFieldEnum;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.rettype.ClassEPType;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.util.JavaClassHelper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;

public class CalendarOpUtil {
    protected static Integer getInt(ExprEvaluator expr, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = expr.evaluate(eventsPerStream, isNewData, context);
        if (result == null) {
            return null;
        }
        return (Integer)result;
    }

    public static CalendarFieldEnum getEnum(String methodName, ExprNode exprNode) throws ExprValidationException {
        String message = CalendarOpUtil.validateConstant(methodName, exprNode);
        if (message != null) {
            message = message + ", " + CalendarOpUtil.getValidFieldNamesMessage();
            throw new ExprValidationException(message);
        }
        String fieldname = (String)exprNode.getExprEvaluator().evaluate(null, true, null);
        CalendarFieldEnum fieldNum = CalendarFieldEnum.fromString(fieldname);
        if (fieldNum == null) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " datetime-field name '" + fieldname + "' is not recognized, " + CalendarOpUtil.getValidFieldNamesMessage());
        }
        return fieldNum;
    }

    public static Object getFormatter(EPType inputType, String methodName, ExprNode exprNode, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (!(inputType instanceof ClassEPType)) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " requires a datetime input value but received " + inputType);
        }
        ClassEPType input = (ClassEPType)inputType;
        Object format = ExprNodeUtility.evaluateValidationTimeNoStreams(exprNode.getExprEvaluator(), exprEvaluatorContext, "date format");
        if (format == null) {
            throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid null format object");
        }
        if (JavaClassHelper.getBoxedType(input.getType()) == Long.class || JavaClassHelper.isSubclassOrImplementsInterface(input.getType(), Date.class) || JavaClassHelper.isSubclassOrImplementsInterface(input.getType(), Calendar.class)) {
            if (format instanceof DateFormat) {
                return format;
            }
            if (format instanceof String) {
                try {
                    return new SimpleDateFormat((String)format);
                }
                catch (RuntimeException ex) {
                    throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid format string (SimpleDateFormat): " + ex.getMessage(), ex);
                }
            }
            throw CalendarOpUtil.getFailedExpected(methodName, DateFormat.class, format);
        }
        if (format instanceof DateTimeFormatter) {
            return format;
        }
        if (format instanceof String) {
            try {
                return DateTimeFormatter.ofPattern((String)format);
            }
            catch (RuntimeException ex) {
                throw new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid format string (DateTimeFormatter): " + ex.getMessage(), ex);
            }
        }
        throw CalendarOpUtil.getFailedExpected(methodName, DateTimeFormatter.class, format);
    }

    private static ExprValidationException getFailedExpected(String methodName, Class expected, Object received) {
        return new ExprValidationException(CalendarOpUtil.getMessage(methodName) + " invalid format, expected string-format or " + expected.getSimpleName() + " but received " + JavaClassHelper.getClassNameFullyQualPretty(received.getClass()));
    }

    private static String validateConstant(String methodName, ExprNode exprNode) {
        if (ExprNodeUtility.isConstantValueExpr(exprNode)) {
            return null;
        }
        return CalendarOpUtil.getMessage(methodName) + " requires a constant string-type parameter as its first parameter";
    }

    private static String getMessage(String methodName) {
        return "Date-time enumeration method '" + methodName + "'";
    }

    private static String getValidFieldNamesMessage() {
        return "valid field names are '" + CalendarFieldEnum.getValidList() + "'";
    }
}

