/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.calop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;

public class CalendarOpWithDate
implements CalendarOp {
    private ExprEvaluator year;
    private ExprEvaluator month;
    private ExprEvaluator day;

    public CalendarOpWithDate(ExprEvaluator year, ExprEvaluator month, ExprEvaluator day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarOpWithDate.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarOpWithDate.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarOpWithDate.getInt(this.day, eventsPerStream, isNewData, context);
        CalendarOpWithDate.action(cal, yearNum, monthNum, dayNum);
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarOpWithDate.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarOpWithDate.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarOpWithDate.getInt(this.day, eventsPerStream, isNewData, context);
        return CalendarOpWithDate.action(ldt, yearNum, monthNum, dayNum);
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer yearNum = CalendarOpWithDate.getInt(this.year, eventsPerStream, isNewData, context);
        Integer monthNum = CalendarOpWithDate.getInt(this.month, eventsPerStream, isNewData, context);
        Integer dayNum = CalendarOpWithDate.getInt(this.day, eventsPerStream, isNewData, context);
        return CalendarOpWithDate.action(zdt, yearNum, monthNum, dayNum);
    }

    protected static Integer getInt(ExprEvaluator expr, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object result = expr.evaluate(eventsPerStream, isNewData, context);
        if (result == null) {
            return null;
        }
        return (Integer)result;
    }

    private static void action(Calendar cal, Integer year, Integer month, Integer day) {
        if (year != null) {
            cal.set(1, year);
        }
        if (month != null) {
            cal.set(2, month);
        }
        if (day != null) {
            cal.set(5, day);
        }
    }

    private static LocalDateTime action(LocalDateTime ldt, Integer year, Integer month, Integer day) {
        if (year != null) {
            ldt = ldt.withYear(year);
        }
        if (month != null) {
            ldt = ldt.withMonth(month);
        }
        if (day != null) {
            ldt = ldt.withDayOfMonth(day);
        }
        return ldt;
    }

    private static ZonedDateTime action(ZonedDateTime zdt, Integer year, Integer month, Integer day) {
        if (year != null) {
            zdt = zdt.withYear(year);
        }
        if (month != null) {
            zdt = zdt.withMonth(month);
        }
        if (day != null) {
            zdt = zdt.withDayOfMonth(day);
        }
        return zdt;
    }
}

