/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.eval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.datetime.calop.CalendarOp;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotEvalVisitor;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.util.JavaClassHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ExprDotEvalDT
implements ExprDotEval {
    private final EPType returnType;
    private final DTLocalEvaluator evaluator;

    public ExprDotEvalDT(List<CalendarOp> calendarOps, TimeZone timeZone, TimeAbacus timeAbacus, ReformatOp reformatOp, IntervalOp intervalOp, Class inputType, EventType inputEventType) {
        this.evaluator = this.getEvaluator(calendarOps, timeZone, timeAbacus, inputType, inputEventType, reformatOp, intervalOp);
        this.returnType = intervalOp != null ? EPTypeHelper.singleValue(Boolean.class) : (reformatOp != null ? EPTypeHelper.singleValue(reformatOp.getReturnType()) : (inputEventType != null ? EPTypeHelper.singleValue(inputEventType.getPropertyType(inputEventType.getStartTimestampPropertyName())) : EPTypeHelper.singleValue(inputType)));
    }

    @Override
    public EPType getTypeInfo() {
        return this.returnType;
    }

    @Override
    public void visit(ExprDotEvalVisitor visitor) {
        visitor.visitDateTime();
    }

    public DTLocalEvaluator getEvaluator(List<CalendarOp> calendarOps, TimeZone timeZone, TimeAbacus timeAbacus, Class inputType, EventType inputEventType, ReformatOp reformatOp, IntervalOp intervalOp) {
        if (inputEventType == null) {
            if (reformatOp != null) {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorCalReformat(reformatOp);
                    }
                    return new DTLocalEvaluatorCalOpsReformat(calendarOps, reformatOp);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Date.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorDateReformat(reformatOp);
                    }
                    return new DTLocalEvaluatorDateOpsReformat(calendarOps, reformatOp, timeZone);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorLongReformat(reformatOp);
                    }
                    return new DTLocalEvaluatorLongOpsReformat(calendarOps, reformatOp, timeZone, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorLocalDateTimeReformat(reformatOp);
                    }
                    return new DTLocalEvaluatorLocalDateTimeOpsReformat(calendarOps, reformatOp);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorZonedDateTimeReformat(reformatOp);
                    }
                    return new DTLocalEvaluatorZonedDateTimeOpsReformat(calendarOps, reformatOp);
                }
            } else if (intervalOp != null) {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorCalInterval(intervalOp);
                    }
                    return new DTLocalEvaluatorCalOpsInterval(calendarOps, intervalOp, timeZone);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Date.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorDateInterval(intervalOp);
                    }
                    return new DTLocalEvaluatorDateOpsInterval(calendarOps, intervalOp, timeZone);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorLongInterval(intervalOp);
                    }
                    return new DTLocalEvaluatorLongOpsInterval(calendarOps, intervalOp, timeZone, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorLDTInterval(intervalOp, timeZone);
                    }
                    return new DTLocalEvaluatorLocalDateTimeOpsInterval(calendarOps, intervalOp, timeZone);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    if (calendarOps.isEmpty()) {
                        return new DTLocalEvaluatorZDTInterval(intervalOp);
                    }
                    return new DTLocalEvaluatorZonedDateTimeOpsInterval(calendarOps, intervalOp);
                }
            } else {
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Calendar.class)) {
                    return new DTLocalEvaluatorCalOpsCal(calendarOps);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, Date.class)) {
                    return new DTLocalEvaluatorCalOpsDate(calendarOps, timeZone);
                }
                if (JavaClassHelper.getBoxedType(inputType) == Long.class) {
                    return new DTLocalEvaluatorCalOpsLong(calendarOps, timeZone, timeAbacus);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, LocalDateTime.class)) {
                    return new DTLocalEvaluatorCalOpsLocalDateTime(calendarOps);
                }
                if (JavaClassHelper.isSubclassOrImplementsInterface(inputType, ZonedDateTime.class)) {
                    return new DTLocalEvaluatorCalOpsZonedDateTime(calendarOps);
                }
            }
            throw new IllegalArgumentException("Invalid input type '" + inputType + "'");
        }
        EventPropertyGetter getter = inputEventType.getGetter(inputEventType.getStartTimestampPropertyName());
        Class getterResultType = inputEventType.getPropertyType(inputEventType.getStartTimestampPropertyName());
        if (reformatOp != null) {
            DTLocalEvaluator inner = this.getEvaluator(calendarOps, timeZone, timeAbacus, getterResultType, null, reformatOp, null);
            return new DTLocalEvaluatorBeanReformat(getter, inner);
        }
        if (intervalOp == null) {
            DTLocalEvaluator inner = this.getEvaluator(calendarOps, timeZone, timeAbacus, getterResultType, null, null, null);
            return new DTLocalEvaluatorBeanCalOps(getter, inner);
        }
        if (inputEventType.getEndTimestampPropertyName() == null) {
            DTLocalEvaluator inner = this.getEvaluator(calendarOps, timeZone, timeAbacus, getterResultType, null, null, intervalOp);
            return new DTLocalEvaluatorBeanIntervalNoEndTS(getter, inner);
        }
        EventPropertyGetter getterEndTimestamp = inputEventType.getGetter(inputEventType.getEndTimestampPropertyName());
        DTLocalEvaluatorIntervalComp inner = (DTLocalEvaluatorIntervalComp)((Object)this.getEvaluator(calendarOps, timeZone, timeAbacus, getterResultType, null, null, intervalOp));
        return new DTLocalEvaluatorBeanIntervalWithEnd(getter, getterEndTimestamp, inner);
    }

    @Override
    public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (target == null) {
            return null;
        }
        return this.evaluator.evaluate(target, eventsPerStream, isNewData, exprEvaluatorContext);
    }

    protected static void evaluateCalOps(List<CalendarOp> calendarOps, Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (CalendarOp calendarOp : calendarOps) {
            calendarOp.evaluate(cal, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    protected static LocalDateTime evaluateCalOps(List<CalendarOp> calendarOps, LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (CalendarOp calendarOp : calendarOps) {
            ldt = calendarOp.evaluate(ldt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return ldt;
    }

    protected static ZonedDateTime evaluateCalOps(List<CalendarOp> calendarOps, ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        for (CalendarOp calendarOp : calendarOps) {
            zdt = calendarOp.evaluate(zdt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return zdt;
    }

    private static class DTLocalEvaluatorBeanCalOps
    implements DTLocalEvaluator {
        private final EventPropertyGetter getter;
        private final DTLocalEvaluator inner;

        private DTLocalEvaluatorBeanCalOps(EventPropertyGetter getter, DTLocalEvaluator inner) {
            this.getter = getter;
            this.inner = inner;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Object timestamp = this.getter.get((EventBean)target);
            if (timestamp == null) {
                return null;
            }
            return this.inner.evaluate(timestamp, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private class DTLocalEvaluatorCalOpsZonedDateTime
    extends DTLocalEvaluatorCalOpsCalBase
    implements DTLocalEvaluator {
        private DTLocalEvaluatorCalOpsZonedDateTime(List<CalendarOp> calendarOps) {
            super(calendarOps);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            ZonedDateTime zdt = (ZonedDateTime)target;
            return ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, zdt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private class DTLocalEvaluatorCalOpsLocalDateTime
    extends DTLocalEvaluatorCalOpsCalBase
    implements DTLocalEvaluator {
        public DTLocalEvaluatorCalOpsLocalDateTime(List<CalendarOp> calendarOps) {
            super(calendarOps);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            LocalDateTime ldt = (LocalDateTime)target;
            return ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, ldt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private class DTLocalEvaluatorCalOpsCal
    extends DTLocalEvaluatorCalOpsCalBase
    implements DTLocalEvaluator {
        private DTLocalEvaluatorCalOpsCal(List<CalendarOp> calendarOps) {
            super(calendarOps);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar calValue = (Calendar)target;
            Calendar cal = (Calendar)calValue.clone();
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            return cal;
        }
    }

    private class DTLocalEvaluatorCalOpsDate
    extends DTLocalEvaluatorCalOpsCalBase
    implements DTLocalEvaluator {
        private final TimeZone timeZone;

        private DTLocalEvaluatorCalOpsDate(List<CalendarOp> calendarOps, TimeZone timeZone) {
            super(calendarOps);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Date dateValue = (Date)target;
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTimeInMillis(dateValue.getTime());
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            return cal.getTime();
        }
    }

    private class DTLocalEvaluatorCalOpsLong
    extends DTLocalEvaluatorCalOpsCalBase
    implements DTLocalEvaluator {
        private final TimeZone timeZone;
        private final TimeAbacus timeAbacus;

        private DTLocalEvaluatorCalOpsLong(List<CalendarOp> calendarOps, TimeZone timeZone, TimeAbacus timeAbacus) {
            super(calendarOps);
            this.timeZone = timeZone;
            this.timeAbacus = timeAbacus;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Long longValue = (Long)target;
            Calendar cal = Calendar.getInstance(this.timeZone);
            long remainder = this.timeAbacus.calendarSet(longValue, cal);
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            return this.timeAbacus.calendarGet(cal, remainder);
        }
    }

    private abstract class DTLocalEvaluatorCalOpsCalBase {
        protected final List<CalendarOp> calendarOps;

        private DTLocalEvaluatorCalOpsCalBase(List<CalendarOp> calendarOps) {
            this.calendarOps = calendarOps;
        }
    }

    private static class DTLocalEvaluatorBeanIntervalWithEnd
    implements DTLocalEvaluator {
        private final EventPropertyGetter getterStartTimestamp;
        private final EventPropertyGetter getterEndTimestamp;
        private final DTLocalEvaluatorIntervalComp inner;

        private DTLocalEvaluatorBeanIntervalWithEnd(EventPropertyGetter getterStartTimestamp, EventPropertyGetter getterEndTimestamp, DTLocalEvaluatorIntervalComp inner) {
            this.getterStartTimestamp = getterStartTimestamp;
            this.getterEndTimestamp = getterEndTimestamp;
            this.inner = inner;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Object startTimestamp = this.getterStartTimestamp.get((EventBean)target);
            if (startTimestamp == null) {
                return null;
            }
            Object endTimestamp = this.getterEndTimestamp.get((EventBean)target);
            if (endTimestamp == null) {
                return null;
            }
            return this.inner.evaluate(startTimestamp, endTimestamp, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorBeanIntervalNoEndTS
    implements DTLocalEvaluator {
        private final EventPropertyGetter getter;
        private final DTLocalEvaluator inner;

        private DTLocalEvaluatorBeanIntervalNoEndTS(EventPropertyGetter getter, DTLocalEvaluator inner) {
            this.getter = getter;
            this.inner = inner;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Object timestamp = this.getter.get((EventBean)target);
            if (timestamp == null) {
                return null;
            }
            return this.inner.evaluate(timestamp, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorBeanReformat
    implements DTLocalEvaluator {
        private final EventPropertyGetter getter;
        private final DTLocalEvaluator inner;

        private DTLocalEvaluatorBeanReformat(EventPropertyGetter getter, DTLocalEvaluator inner) {
            this.getter = getter;
            this.inner = inner;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Object timestamp = this.getter.get((EventBean)target);
            if (timestamp == null) {
                return null;
            }
            return this.inner.evaluate(timestamp, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorZonedDateTimeOpsInterval
    extends DTLocalEvaluatorCalOpsIntervalBase {
        private DTLocalEvaluatorZonedDateTimeOpsInterval(List<CalendarOp> calendarOps, IntervalOp intervalOp) {
            super(calendarOps, intervalOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            ZonedDateTime zdt = (ZonedDateTime)target;
            zdt = ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, zdt, eventsPerStream, isNewData, exprEvaluatorContext);
            long time = DatetimeLongCoercerZonedDateTime.coerce(zdt);
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            ZonedDateTime start = (ZonedDateTime)startTimestamp;
            ZonedDateTime end = (ZonedDateTime)endTimestamp;
            long deltaMSec = DatetimeLongCoercerZonedDateTime.coerce(end) - DatetimeLongCoercerZonedDateTime.coerce(start);
            start = ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, start, eventsPerStream, isNewData, exprEvaluatorContext);
            long startLong = DatetimeLongCoercerZonedDateTime.coerce(start);
            long endTime = startLong + deltaMSec;
            return this.intervalOp.evaluate(startLong, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLocalDateTimeOpsInterval
    extends DTLocalEvaluatorCalOpsIntervalBase {
        private final TimeZone timeZone;

        private DTLocalEvaluatorLocalDateTimeOpsInterval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone) {
            super(calendarOps, intervalOp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            LocalDateTime ldt = (LocalDateTime)target;
            ldt = ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, ldt, eventsPerStream, isNewData, exprEvaluatorContext);
            long time = DatetimeLongCoercerLocalDateTime.coerce(ldt, this.timeZone);
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            LocalDateTime start = (LocalDateTime)startTimestamp;
            LocalDateTime end = (LocalDateTime)endTimestamp;
            long deltaMSec = DatetimeLongCoercerLocalDateTime.coerce(end, this.timeZone) - DatetimeLongCoercerLocalDateTime.coerce(start, this.timeZone);
            start = ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, start, eventsPerStream, isNewData, exprEvaluatorContext);
            long startLong = DatetimeLongCoercerLocalDateTime.coerce(start, this.timeZone);
            long endTime = startLong + deltaMSec;
            return this.intervalOp.evaluate(startLong, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLongOpsInterval
    extends DTLocalEvaluatorCalOpsIntervalBase {
        private final TimeZone timeZone;
        private final TimeAbacus timeAbacus;

        private DTLocalEvaluatorLongOpsInterval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone, TimeAbacus timeAbacus) {
            super(calendarOps, intervalOp);
            this.timeZone = timeZone;
            this.timeAbacus = timeAbacus;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar cal = Calendar.getInstance(this.timeZone);
            long startRemainder = this.timeAbacus.calendarSet((Long)target, cal);
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            long time = this.timeAbacus.calendarGet(cal, startRemainder);
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long startLong = (Long)startTimestamp;
            long endLong = (Long)endTimestamp;
            Calendar cal = Calendar.getInstance(this.timeZone);
            long startRemainder = this.timeAbacus.calendarSet(startLong, cal);
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            long startTime = this.timeAbacus.calendarGet(cal, startRemainder);
            long endTime = startTime + (endLong - startLong);
            return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLongInterval
    extends DTLocalEvaluatorIntervalBase {
        private DTLocalEvaluatorLongInterval(IntervalOp intervalOp) {
            super(intervalOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long time = (Long)target;
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long startTime = (Long)startTimestamp;
            long endTime = (Long)endTimestamp;
            return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorDateOpsInterval
    extends DTLocalEvaluatorCalOpsIntervalBase {
        private final TimeZone timeZone;

        private DTLocalEvaluatorDateOpsInterval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone) {
            super(calendarOps, intervalOp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTimeInMillis(((Date)target).getTime());
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            long time = cal.getTimeInMillis();
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long startLong = ((Date)startTimestamp).getTime();
            long endLong = ((Date)endTimestamp).getTime();
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTimeInMillis(startLong);
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            long startTime = cal.getTimeInMillis();
            long endTime = startTime + (endLong - startLong);
            return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorDateInterval
    extends DTLocalEvaluatorIntervalBase {
        private DTLocalEvaluatorDateInterval(IntervalOp intervalOp) {
            super(intervalOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long time = ((Date)target).getTime();
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long start = ((Date)startTimestamp).getTime();
            long end = ((Date)endTimestamp).getTime();
            return this.intervalOp.evaluate(start, end, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorCalOpsInterval
    extends DTLocalEvaluatorCalOpsIntervalBase {
        private final TimeZone timeZone;

        private DTLocalEvaluatorCalOpsInterval(List<CalendarOp> calendarOps, IntervalOp intervalOp, TimeZone timeZone) {
            super(calendarOps, intervalOp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar cal = (Calendar)((Calendar)target).clone();
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            long time = cal.getTimeInMillis();
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long startLong = ((Calendar)startTimestamp).getTimeInMillis();
            long endLong = ((Calendar)endTimestamp).getTimeInMillis();
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTimeInMillis(startLong);
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            long startTime = cal.getTimeInMillis();
            long endTime = startTime + (endLong - startLong);
            return this.intervalOp.evaluate(startTime, endTime, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorZDTInterval
    extends DTLocalEvaluatorIntervalBase {
        public DTLocalEvaluatorZDTInterval(IntervalOp intervalOp) {
            super(intervalOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long time = DatetimeLongCoercerZonedDateTime.coerce((ZonedDateTime)target);
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long start = DatetimeLongCoercerZonedDateTime.coerce((ZonedDateTime)startTimestamp);
            long end = DatetimeLongCoercerZonedDateTime.coerce((ZonedDateTime)endTimestamp);
            return this.intervalOp.evaluate(start, end, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLDTInterval
    extends DTLocalEvaluatorIntervalBase {
        private final TimeZone timeZone;

        public DTLocalEvaluatorLDTInterval(IntervalOp intervalOp, TimeZone timeZone) {
            super(intervalOp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long time = DatetimeLongCoercerLocalDateTime.coerce((LocalDateTime)target, this.timeZone);
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long start = DatetimeLongCoercerLocalDateTime.coerce((LocalDateTime)startTimestamp, this.timeZone);
            long end = DatetimeLongCoercerLocalDateTime.coerce((LocalDateTime)endTimestamp, this.timeZone);
            return this.intervalOp.evaluate(start, end, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorCalInterval
    extends DTLocalEvaluatorIntervalBase {
        private DTLocalEvaluatorCalInterval(IntervalOp intervalOp) {
            super(intervalOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long time = ((Calendar)target).getTimeInMillis();
            return this.intervalOp.evaluate(time, time, eventsPerStream, isNewData, exprEvaluatorContext);
        }

        @Override
        public Object evaluate(Object startTimestamp, Object endTimestamp, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            long start = ((Calendar)startTimestamp).getTimeInMillis();
            long end = ((Calendar)endTimestamp).getTimeInMillis();
            return this.intervalOp.evaluate(start, end, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static abstract class DTLocalEvaluatorCalOpsIntervalBase
    implements DTLocalEvaluator,
    DTLocalEvaluatorIntervalComp {
        protected final List<CalendarOp> calendarOps;
        protected final IntervalOp intervalOp;

        protected DTLocalEvaluatorCalOpsIntervalBase(List<CalendarOp> calendarOps, IntervalOp intervalOp) {
            this.calendarOps = calendarOps;
            this.intervalOp = intervalOp;
        }
    }

    private static abstract class DTLocalEvaluatorIntervalBase
    implements DTLocalEvaluator,
    DTLocalEvaluatorIntervalComp {
        protected final IntervalOp intervalOp;

        protected DTLocalEvaluatorIntervalBase(IntervalOp intervalOp) {
            this.intervalOp = intervalOp;
        }
    }

    private static interface DTLocalEvaluatorIntervalComp {
        public Object evaluate(Object var1, Object var2, EventBean[] var3, boolean var4, ExprEvaluatorContext var5);
    }

    private static class DTLocalEvaluatorZonedDateTimeOpsReformat
    extends DTLocalEvaluatorCalopReformatBase {
        private DTLocalEvaluatorZonedDateTimeOpsReformat(List<CalendarOp> calendarOps, ReformatOp reformatOp) {
            super(calendarOps, reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            ZonedDateTime zdt = (ZonedDateTime)target;
            zdt = ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, zdt, eventsPerStream, isNewData, exprEvaluatorContext);
            return this.reformatOp.evaluate(zdt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLocalDateTimeOpsReformat
    extends DTLocalEvaluatorCalopReformatBase {
        private DTLocalEvaluatorLocalDateTimeOpsReformat(List<CalendarOp> calendarOps, ReformatOp reformatOp) {
            super(calendarOps, reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            LocalDateTime ldt = (LocalDateTime)target;
            ldt = ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, ldt, eventsPerStream, isNewData, exprEvaluatorContext);
            return this.reformatOp.evaluate(ldt, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLongOpsReformat
    extends DTLocalEvaluatorCalopReformatBase {
        private final TimeZone timeZone;
        private final TimeAbacus timeAbacus;

        private DTLocalEvaluatorLongOpsReformat(List<CalendarOp> calendarOps, ReformatOp reformatOp, TimeZone timeZone, TimeAbacus timeAbacus) {
            super(calendarOps, reformatOp);
            this.timeZone = timeZone;
            this.timeAbacus = timeAbacus;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar cal = Calendar.getInstance(this.timeZone);
            this.timeAbacus.calendarSet((Long)target, cal);
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            return this.reformatOp.evaluate(cal, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLongReformat
    extends DTLocalEvaluatorReformatBase {
        private DTLocalEvaluatorLongReformat(ReformatOp reformatOp) {
            super(reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.reformatOp.evaluate((Long)target, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorDateOpsReformat
    extends DTLocalEvaluatorCalopReformatBase {
        private final TimeZone timeZone;

        private DTLocalEvaluatorDateOpsReformat(List<CalendarOp> calendarOps, ReformatOp reformatOp, TimeZone timeZone) {
            super(calendarOps, reformatOp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar cal = Calendar.getInstance(this.timeZone);
            cal.setTimeInMillis(((Date)target).getTime());
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            return this.reformatOp.evaluate(cal, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorZonedDateTimeReformat
    extends DTLocalEvaluatorReformatBase {
        private DTLocalEvaluatorZonedDateTimeReformat(ReformatOp reformatOp) {
            super(reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.reformatOp.evaluate((ZonedDateTime)target, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorLocalDateTimeReformat
    extends DTLocalEvaluatorReformatBase {
        private DTLocalEvaluatorLocalDateTimeReformat(ReformatOp reformatOp) {
            super(reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.reformatOp.evaluate((LocalDateTime)target, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorDateReformat
    extends DTLocalEvaluatorReformatBase {
        private DTLocalEvaluatorDateReformat(ReformatOp reformatOp) {
            super(reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.reformatOp.evaluate((Date)target, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorCalOpsReformat
    extends DTLocalEvaluatorCalopReformatBase {
        private DTLocalEvaluatorCalOpsReformat(List<CalendarOp> calendarOps, ReformatOp reformatOp) {
            super(calendarOps, reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Calendar cal = (Calendar)((Calendar)target).clone();
            ExprDotEvalDT.evaluateCalOps((List<CalendarOp>)this.calendarOps, cal, eventsPerStream, isNewData, exprEvaluatorContext);
            return this.reformatOp.evaluate(cal, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static class DTLocalEvaluatorCalReformat
    extends DTLocalEvaluatorReformatBase {
        private DTLocalEvaluatorCalReformat(ReformatOp reformatOp) {
            super(reformatOp);
        }

        @Override
        public Object evaluate(Object target, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            return this.reformatOp.evaluate((Calendar)target, eventsPerStream, isNewData, exprEvaluatorContext);
        }
    }

    private static abstract class DTLocalEvaluatorCalopReformatBase
    implements DTLocalEvaluator {
        protected final List<CalendarOp> calendarOps;
        protected final ReformatOp reformatOp;

        protected DTLocalEvaluatorCalopReformatBase(List<CalendarOp> calendarOps, ReformatOp reformatOp) {
            this.calendarOps = calendarOps;
            this.reformatOp = reformatOp;
        }
    }

    private static abstract class DTLocalEvaluatorReformatBase
    implements DTLocalEvaluator {
        protected final ReformatOp reformatOp;

        protected DTLocalEvaluatorReformatBase(ReformatOp reformatOp) {
            this.reformatOp = reformatOp;
        }
    }

    private static interface DTLocalEvaluator {
        public Object evaluate(Object var1, EventBean[] var2, boolean var3, ExprEvaluatorContext var4);
    }
}

