/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.interval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.interval.ExprOptionalConstant;
import com.espertech.esper.epl.datetime.interval.IntervalComputer;
import com.espertech.esper.epl.datetime.interval.IntervalComputerConstantBase;
import com.espertech.esper.epl.datetime.interval.IntervalDeltaExprEvaluator;
import com.espertech.esper.epl.datetime.interval.IntervalStartEndParameterPair;
import com.espertech.esper.epl.expression.core.ExprConstantNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.time.ExprTimePeriod;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaConst;
import com.espertech.esper.epl.expression.time.ExprTimePeriodEvalDeltaNonConst;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntervalComputerFactory {
    public static IntervalComputer make(DatetimeMethodEnum method, List<ExprNode> expressions, TimeAbacus timeAbacus) throws ExprValidationException {
        ExprOptionalConstant[] parameters = IntervalComputerFactory.getParameters(expressions, timeAbacus);
        if (method == DatetimeMethodEnum.BEFORE) {
            if (parameters.length == 0) {
                return new IntervalComputerBeforeNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithLongMaxEnd(parameters);
            if (pair.isConstant()) {
                return new IntervalComputerConstantBefore(pair);
            }
            return new IntervalComputerBeforeWithDeltaExpr(pair);
        }
        if (method == DatetimeMethodEnum.AFTER) {
            if (parameters.length == 0) {
                return new IntervalComputerAfterNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithLongMaxEnd(parameters);
            if (pair.isConstant()) {
                return new IntervalComputerConstantAfter(pair);
            }
            return new IntervalComputerAfterWithDeltaExpr(pair);
        }
        if (method == DatetimeMethodEnum.COINCIDES) {
            if (parameters.length == 0) {
                return new IntervalComputerCoincidesNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithSameEnd(parameters);
            if (pair.isConstant()) {
                return new IntervalComputerConstantCoincides(pair);
            }
            return new IntervalComputerCoincidesWithDeltaExpr(pair);
        }
        if (method == DatetimeMethodEnum.DURING || method == DatetimeMethodEnum.INCLUDES) {
            if (parameters.length == 0) {
                if (method == DatetimeMethodEnum.DURING) {
                    return new IntervalComputerDuringNoParam();
                }
                return new IntervalComputerIncludesNoParam();
            }
            IntervalStartEndParameterPair pair = IntervalStartEndParameterPair.fromParamsWithSameEnd(parameters);
            if (parameters.length == 1) {
                return new IntervalComputerDuringAndIncludesThreshold(method == DatetimeMethodEnum.DURING, pair.getStart().getEvaluator());
            }
            if (parameters.length == 2) {
                return new IntervalComputerDuringAndIncludesMinMax(method == DatetimeMethodEnum.DURING, pair.getStart().getEvaluator(), pair.getEnd().getEvaluator());
            }
            return new IntervalComputerDuringMinMaxStartEnd(method == DatetimeMethodEnum.DURING, IntervalComputerFactory.getEvaluators(expressions, timeAbacus));
        }
        if (method == DatetimeMethodEnum.FINISHES) {
            if (parameters.length == 0) {
                return new IntervalComputerFinishesNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("finishes", parameters[0]);
            return new IntervalComputerFinishesThreshold(parameters[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.FINISHEDBY) {
            if (parameters.length == 0) {
                return new IntervalComputerFinishedByNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("finishedby", parameters[0]);
            return new IntervalComputerFinishedByThreshold(parameters[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.MEETS) {
            if (parameters.length == 0) {
                return new IntervalComputerMeetsNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("meets", parameters[0]);
            return new IntervalComputerMeetsThreshold(parameters[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.METBY) {
            if (parameters.length == 0) {
                return new IntervalComputerMetByNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("metBy", parameters[0]);
            return new IntervalComputerMetByThreshold(parameters[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.OVERLAPS || method == DatetimeMethodEnum.OVERLAPPEDBY) {
            if (parameters.length == 0) {
                if (method == DatetimeMethodEnum.OVERLAPS) {
                    return new IntervalComputerOverlapsNoParam();
                }
                return new IntervalComputerOverlappedByNoParam();
            }
            if (parameters.length == 1) {
                return new IntervalComputerOverlapsAndByThreshold(method == DatetimeMethodEnum.OVERLAPS, parameters[0].getEvaluator());
            }
            return new IntervalComputerOverlapsAndByMinMax(method == DatetimeMethodEnum.OVERLAPS, parameters[0].getEvaluator(), parameters[1].getEvaluator());
        }
        if (method == DatetimeMethodEnum.STARTS) {
            if (parameters.length == 0) {
                return new IntervalComputerStartsNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("starts", parameters[0]);
            return new IntervalComputerStartsThreshold(parameters[0].getEvaluator());
        }
        if (method == DatetimeMethodEnum.STARTEDBY) {
            if (parameters.length == 0) {
                return new IntervalComputerStartedByNoParam();
            }
            IntervalComputerFactory.validateConstantThreshold("startedBy", parameters[0]);
            return new IntervalComputerStartedByThreshold(parameters[0].getEvaluator());
        }
        throw new IllegalArgumentException("Unknown datetime method '" + (Object)((Object)method) + "'");
    }

    private static void validateConstantThreshold(String method, ExprOptionalConstant param) throws ExprValidationException {
        if (param.getOptionalConstant() != null && param.getOptionalConstant() < 0L) {
            throw new ExprValidationException("The " + method + " date-time method does not allow negative threshold value");
        }
    }

    private static ExprOptionalConstant[] getParameters(List<ExprNode> expressions, TimeAbacus timeAbacus) {
        ExprOptionalConstant[] parameters = new ExprOptionalConstant[expressions.size() - 1];
        for (int i = 1; i < expressions.size(); ++i) {
            parameters[i - 1] = IntervalComputerFactory.getExprOrConstant(expressions.get(i), timeAbacus);
        }
        return parameters;
    }

    private static IntervalDeltaExprEvaluator[] getEvaluators(List<ExprNode> expressions, TimeAbacus timeAbacus) {
        IntervalDeltaExprEvaluator[] parameters = new IntervalDeltaExprEvaluator[expressions.size() - 1];
        for (int i = 1; i < expressions.size(); ++i) {
            parameters[i - 1] = IntervalComputerFactory.getExprOrConstant(expressions.get(i), timeAbacus).getEvaluator();
        }
        return parameters;
    }

    private static ExprOptionalConstant getExprOrConstant(ExprNode exprNode, final TimeAbacus timeAbacus) {
        if (exprNode instanceof ExprTimePeriod) {
            final ExprTimePeriod timePeriod = (ExprTimePeriod)exprNode;
            if (!timePeriod.isHasMonth() && !timePeriod.isHasYear()) {
                if (exprNode.isConstantResult()) {
                    double sec = timePeriod.evaluateAsSeconds(null, true, null);
                    final long l = timeAbacus.deltaForSecondsDouble(sec);
                    IntervalDeltaExprEvaluator eval = new IntervalDeltaExprEvaluator(){

                        @Override
                        public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                            return l;
                        }
                    };
                    return new ExprOptionalConstant(eval, l);
                }
                IntervalDeltaExprEvaluator eval = new IntervalDeltaExprEvaluator(){

                    @Override
                    public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                        double sec = timePeriod.evaluateAsSeconds(eventsPerStream, isNewData, context);
                        return timeAbacus.deltaForSecondsDouble(sec);
                    }
                };
                return new ExprOptionalConstant(eval, null);
            }
            if (exprNode.isConstantResult()) {
                final ExprTimePeriodEvalDeltaConst timerPeriodConst = timePeriod.constEvaluator(null);
                IntervalDeltaExprEvaluator eval = new IntervalDeltaExprEvaluator(){

                    @Override
                    public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                        return timerPeriodConst.deltaAdd(reference);
                    }
                };
                return new ExprOptionalConstant(eval, null);
            }
            final ExprTimePeriodEvalDeltaNonConst timerPeriodNonConst = timePeriod.nonconstEvaluator();
            IntervalDeltaExprEvaluator eval = new IntervalDeltaExprEvaluator(){

                @Override
                public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return timerPeriodNonConst.deltaAdd(reference, eventsPerStream, isNewData, context);
                }
            };
            return new ExprOptionalConstant(eval, null);
        }
        if (ExprNodeUtility.isConstantValueExpr(exprNode)) {
            ExprConstantNode constantNode = (ExprConstantNode)exprNode;
            final long l = ((Number)constantNode.getConstantValue(null)).longValue();
            IntervalDeltaExprEvaluator eval = new IntervalDeltaExprEvaluator(){

                @Override
                public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                    return l;
                }
            };
            return new ExprOptionalConstant(eval, l);
        }
        final ExprEvaluator evaluator = exprNode.getExprEvaluator();
        IntervalDeltaExprEvaluator eval = new IntervalDeltaExprEvaluator(){

            @Override
            public long evaluate(long reference, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
                return ((Number)evaluator.evaluate(eventsPerStream, isNewData, context)).longValue();
            }
        };
        return new ExprOptionalConstant(eval, null);
    }

    public static class IntervalComputerStartedByThreshold
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerStartedByThreshold.class);
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerStartedByThreshold(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftStart, rightStart), eventsPerStream, newData, context);
            if (threshold < 0L) {
                log.warn("The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(leftStart - rightStart);
            return delta <= threshold && leftEnd > rightEnd;
        }
    }

    public static class IntervalComputerStartedByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd > rightEnd;
        }
    }

    public static class IntervalComputerStartsThreshold
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerStartsThreshold.class);
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerStartsThreshold(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftStart, rightStart), eventsPerStream, newData, context);
            if (threshold < 0L) {
                log.warn("The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(leftStart - rightStart);
            return delta <= threshold && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerStartsNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerOverlappedByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftStart < rightEnd && rightEnd < leftEnd;
        }
    }

    public static class IntervalComputerOverlapsAndByMinMax
    implements IntervalComputer {
        private final boolean overlaps;
        private final IntervalDeltaExprEvaluator minEval;
        private final IntervalDeltaExprEvaluator maxEval;

        public IntervalComputerOverlapsAndByMinMax(boolean overlaps, IntervalDeltaExprEvaluator minEval, IntervalDeltaExprEvaluator maxEval) {
            this.overlaps = overlaps;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            if (this.overlaps) {
                long minThreshold = this.minEval.evaluate(leftStart, eventsPerStream, newData, context);
                long maxThreshold = this.maxEval.evaluate(leftEnd, eventsPerStream, newData, context);
                return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(leftStart, leftEnd, rightStart, rightEnd, minThreshold, maxThreshold);
            }
            long minThreshold = this.minEval.evaluate(rightStart, eventsPerStream, newData, context);
            long maxThreshold = this.maxEval.evaluate(rightEnd, eventsPerStream, newData, context);
            return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(rightStart, rightEnd, leftStart, leftEnd, minThreshold, maxThreshold);
        }
    }

    public static class IntervalComputerOverlapsAndByThreshold
    implements IntervalComputer {
        private final boolean overlaps;
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerOverlapsAndByThreshold(boolean overlaps, IntervalDeltaExprEvaluator thresholdExpr) {
            this.overlaps = overlaps;
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            if (this.overlaps) {
                long threshold = this.thresholdExpr.evaluate(leftStart, eventsPerStream, newData, context);
                return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(leftStart, leftEnd, rightStart, rightEnd, 0L, threshold);
            }
            long threshold = this.thresholdExpr.evaluate(rightStart, eventsPerStream, newData, context);
            return IntervalComputerOverlapsAndByThreshold.computeInternalOverlaps(rightStart, rightEnd, leftStart, leftEnd, 0L, threshold);
        }

        public static boolean computeInternalOverlaps(long left, long leftEnd, long right, long rightEnd, long min, long max) {
            boolean match;
            boolean bl = match = left < right && right < leftEnd && leftEnd < rightEnd;
            if (!match) {
                return false;
            }
            long delta = leftEnd - right;
            return min <= delta && delta <= max;
        }
    }

    public static class IntervalComputerOverlapsNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && rightStart < leftEnd && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerMetByThreshold
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerMetByThreshold.class);
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerMetByThreshold(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftStart, rightEnd), eventsPerStream, newData, context);
            if (threshold < 0L) {
                log.warn("The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(leftStart - rightEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerMetByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightEnd == leftStart;
        }
    }

    public static class IntervalComputerMeetsThreshold
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerMeetsThreshold.class);
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerMeetsThreshold(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftEnd, rightStart), eventsPerStream, newData, context);
            if (threshold < 0L) {
                log.warn("The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            long delta = Math.abs(rightStart - leftEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerMeetsNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftEnd == rightStart;
        }
    }

    public static class IntervalComputerFinishedByThreshold
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerFinishedByThreshold.class);
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerFinishedByThreshold(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(rightEnd, leftEnd), eventsPerStream, newData, context);
            if (threshold < 0L) {
                log.warn("The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            if (leftStart >= rightStart) {
                return false;
            }
            long delta = Math.abs(leftEnd - rightEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerFinishedByNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerFinishesThreshold
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerFinishesThreshold.class);
        private final IntervalDeltaExprEvaluator thresholdExpr;

        public IntervalComputerFinishesThreshold(IntervalDeltaExprEvaluator thresholdExpr) {
            this.thresholdExpr = thresholdExpr;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long threshold = this.thresholdExpr.evaluate(Math.min(leftEnd, rightEnd), eventsPerStream, newData, context);
            if (threshold < 0L) {
                log.warn("The 'finishes' date-time method does not allow negative threshold");
                return null;
            }
            if (rightStart >= leftStart) {
                return false;
            }
            long delta = Math.abs(leftEnd - rightEnd);
            return delta <= threshold;
        }
    }

    public static class IntervalComputerFinishesNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerDuringMinMaxStartEnd
    implements IntervalComputer {
        private final boolean during;
        private final IntervalDeltaExprEvaluator minStartEval;
        private final IntervalDeltaExprEvaluator maxStartEval;
        private final IntervalDeltaExprEvaluator minEndEval;
        private final IntervalDeltaExprEvaluator maxEndEval;

        public IntervalComputerDuringMinMaxStartEnd(boolean during, IntervalDeltaExprEvaluator[] parameters) {
            this.during = during;
            this.minStartEval = parameters[0];
            this.maxStartEval = parameters[1];
            this.minEndEval = parameters[2];
            this.maxEndEval = parameters[3];
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long minStart = this.minStartEval.evaluate(rightStart, eventsPerStream, newData, context);
            long maxStart = this.maxStartEval.evaluate(rightStart, eventsPerStream, newData, context);
            long minEnd = this.minEndEval.evaluate(rightEnd, eventsPerStream, newData, context);
            long maxEnd = this.maxEndEval.evaluate(rightEnd, eventsPerStream, newData, context);
            if (this.during) {
                return IntervalComputerDuringAndIncludesMinMax.computeInternalDuring(leftStart, leftEnd, rightStart, rightEnd, minStart, maxStart, minEnd, maxEnd);
            }
            return IntervalComputerDuringAndIncludesMinMax.computeInternalIncludes(leftStart, leftEnd, rightStart, rightEnd, minStart, maxStart, minEnd, maxEnd);
        }
    }

    public static class IntervalComputerDuringAndIncludesMinMax
    implements IntervalComputer {
        private final boolean during;
        private final IntervalDeltaExprEvaluator minEval;
        private final IntervalDeltaExprEvaluator maxEval;

        public IntervalComputerDuringAndIncludesMinMax(boolean during, IntervalDeltaExprEvaluator minEval, IntervalDeltaExprEvaluator maxEval) {
            this.during = during;
            this.minEval = minEval;
            this.maxEval = maxEval;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long min = this.minEval.evaluate(leftStart, eventsPerStream, newData, context);
            long max = this.maxEval.evaluate(rightEnd, eventsPerStream, newData, context);
            if (this.during) {
                return IntervalComputerDuringAndIncludesMinMax.computeInternalDuring(leftStart, leftEnd, rightStart, rightEnd, min, max, min, max);
            }
            return IntervalComputerDuringAndIncludesMinMax.computeInternalIncludes(leftStart, leftEnd, rightStart, rightEnd, min, max, min, max);
        }

        public static boolean computeInternalDuring(long left, long leftEnd, long right, long rightEnd, long startMin, long startMax, long endMin, long endMax) {
            long deltaStart;
            if (startMin <= 0L) {
                startMin = 1L;
            }
            if ((deltaStart = left - right) < startMin || deltaStart > startMax) {
                return false;
            }
            long deltaEnd = rightEnd - leftEnd;
            return deltaEnd >= endMin && deltaEnd <= endMax;
        }

        public static boolean computeInternalIncludes(long left, long leftEnd, long right, long rightEnd, long startMin, long startMax, long endMin, long endMax) {
            long deltaStart;
            if (startMin <= 0L) {
                startMin = 1L;
            }
            if ((deltaStart = right - left) < startMin || deltaStart > startMax) {
                return false;
            }
            long deltaEnd = leftEnd - rightEnd;
            return deltaEnd >= endMin && deltaEnd <= endMax;
        }
    }

    public static class IntervalComputerDuringAndIncludesThreshold
    implements IntervalComputer {
        private final boolean during;
        private final IntervalDeltaExprEvaluator threshold;

        public IntervalComputerDuringAndIncludesThreshold(boolean during, IntervalDeltaExprEvaluator threshold) {
            this.during = during;
            this.threshold = threshold;
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long thresholdValue = this.threshold.evaluate(leftStart, eventsPerStream, newData, context);
            if (this.during) {
                long deltaStart = leftStart - rightStart;
                if (deltaStart <= 0L || deltaStart > thresholdValue) {
                    return false;
                }
                long deltaEnd = rightEnd - leftEnd;
                return deltaEnd > 0L && deltaEnd <= thresholdValue;
            }
            long deltaStart = rightStart - leftStart;
            if (deltaStart <= 0L || deltaStart > thresholdValue) {
                return false;
            }
            long deltaEnd = leftEnd - rightEnd;
            return deltaEnd > 0L && deltaEnd <= thresholdValue;
        }
    }

    public static class IntervalComputerIncludesNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart < rightStart && rightEnd < leftEnd;
        }
    }

    public static class IntervalComputerDuringNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return rightStart < leftStart && leftEnd < rightEnd;
        }
    }

    public static class IntervalComputerCoincidesNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart == rightStart && leftEnd == rightEnd;
        }
    }

    public static class IntervalComputerCoincidesWithDeltaExpr
    implements IntervalComputer {
        private static final Logger log = LoggerFactory.getLogger(IntervalComputerCoincidesWithDeltaExpr.class);
        private final IntervalDeltaExprEvaluator start;
        private final IntervalDeltaExprEvaluator finish;

        public IntervalComputerCoincidesWithDeltaExpr(IntervalStartEndParameterPair pair) {
            this.start = pair.getStart().getEvaluator();
            this.finish = pair.getEnd().getEvaluator();
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long startValue = this.start.evaluate(Math.min(leftStart, rightStart), eventsPerStream, newData, context);
            long endValue = this.finish.evaluate(Math.min(leftEnd, rightEnd), eventsPerStream, newData, context);
            if (startValue < 0L || endValue < 0L) {
                log.warn("The coincides date-time method does not allow negative start and end values");
                return null;
            }
            return IntervalComputerConstantCoincides.computeInternal(leftStart, leftEnd, rightStart, rightEnd, startValue, endValue);
        }
    }

    public static class IntervalComputerConstantCoincides
    implements IntervalComputer {
        protected final long start;
        protected final long end;

        public IntervalComputerConstantCoincides(IntervalStartEndParameterPair pair) throws ExprValidationException {
            this.start = pair.getStart().getOptionalConstant();
            this.end = pair.getEnd().getOptionalConstant();
            if (this.start < 0L || this.end < 0L) {
                throw new ExprValidationException("The coincides date-time method does not allow negative start and end values");
            }
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantCoincides.computeInternal(leftStart, leftEnd, rightStart, rightEnd, this.start, this.end);
        }

        public static Boolean computeInternal(long left, long leftEnd, long right, long rightEnd, long startThreshold, long endThreshold) {
            return Math.abs(left - right) <= startThreshold && Math.abs(leftEnd - rightEnd) <= endThreshold;
        }
    }

    public static class IntervalComputerBeforeNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftEnd < rightStart;
        }
    }

    public static class IntervalComputerBeforeWithDeltaExpr
    implements IntervalComputer {
        private final IntervalDeltaExprEvaluator start;
        private final IntervalDeltaExprEvaluator finish;

        public IntervalComputerBeforeWithDeltaExpr(IntervalStartEndParameterPair pair) {
            this.start = pair.getStart().getEvaluator();
            this.finish = pair.getEnd().getEvaluator();
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long rangeEndDelta;
            long rangeStartDelta = this.start.evaluate(leftEnd, eventsPerStream, newData, context);
            if (rangeStartDelta > (rangeEndDelta = this.finish.evaluate(leftEnd, eventsPerStream, newData, context))) {
                return IntervalComputerConstantBefore.computeInternal(leftStart, leftEnd, rightStart, rangeEndDelta, rangeStartDelta);
            }
            return IntervalComputerConstantBefore.computeInternal(leftStart, leftEnd, rightStart, rangeStartDelta, rangeEndDelta);
        }
    }

    public static class IntervalComputerConstantBefore
    extends IntervalComputerConstantBase
    implements IntervalComputer {
        public IntervalComputerConstantBefore(IntervalStartEndParameterPair pair) {
            super(pair, true);
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantBefore.computeInternal(leftStart, leftEnd, rightStart, this.start, this.end);
        }

        public static Boolean computeInternal(long left, long leftEnd, long right, long start, long end) {
            long delta = right - leftEnd;
            return start <= delta && delta <= end;
        }
    }

    public static class IntervalComputerAfterNoParam
    implements IntervalComputer {
        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return leftStart > rightEnd;
        }
    }

    public static class IntervalComputerAfterWithDeltaExpr
    implements IntervalComputer {
        private final IntervalDeltaExprEvaluator start;
        private final IntervalDeltaExprEvaluator finish;

        public IntervalComputerAfterWithDeltaExpr(IntervalStartEndParameterPair pair) {
            this.start = pair.getStart().getEvaluator();
            this.finish = pair.getEnd().getEvaluator();
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            long rangeEndDelta;
            long rangeStartDelta = this.start.evaluate(rightStart, eventsPerStream, newData, context);
            if (rangeStartDelta > (rangeEndDelta = this.finish.evaluate(rightStart, eventsPerStream, newData, context))) {
                return IntervalComputerConstantAfter.computeInternal(leftStart, leftEnd, rightStart, rightEnd, rangeEndDelta, rangeStartDelta);
            }
            return IntervalComputerConstantAfter.computeInternal(leftStart, leftEnd, rightStart, rightEnd, rangeStartDelta, rangeEndDelta);
        }
    }

    public static class IntervalComputerConstantAfter
    extends IntervalComputerConstantBase
    implements IntervalComputer {
        public IntervalComputerConstantAfter(IntervalStartEndParameterPair pair) {
            super(pair, true);
        }

        @Override
        public Boolean compute(long leftStart, long leftEnd, long rightStart, long rightEnd, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext context) {
            return IntervalComputerConstantAfter.computeInternal(leftStart, leftEnd, rightStart, rightEnd, this.start, this.end);
        }

        public static Boolean computeInternal(long leftStart, long leftEnd, long rightStart, long rightEnd, long start, long end) {
            long delta = leftStart - rightEnd;
            return start <= delta && delta <= end;
        }
    }
}

