/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.interval;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.PropertyResolutionDescriptor;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.FilterExprAnalyzerDTIntervalAffector;
import com.espertech.esper.epl.datetime.interval.ExprEvaluatorStreamLongProp;
import com.espertech.esper.epl.datetime.interval.ExprEvaluatorStreamLongPropFragment;
import com.espertech.esper.epl.datetime.interval.IntervalComputer;
import com.espertech.esper.epl.datetime.interval.IntervalComputerFactory;
import com.espertech.esper.epl.datetime.interval.IntervalOp;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprIdentNodeUtil;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.util.JavaClassHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class IntervalOpImpl
implements IntervalOp {
    private ExprEvaluator evaluatorTimestamp;
    private Integer parameterStreamNum;
    private String parameterPropertyStart;
    private String parameterPropertyEnd;
    private final IntervalOpEval intervalOpEval;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IntervalOpImpl(DatetimeMethodEnum method, String methodNameUse, StreamTypeService streamTypeService, List<ExprNode> expressions, TimeZone timeZone, TimeAbacus timeAbacus) throws ExprValidationException {
        void var7_12;
        Class timestampType;
        Object var7_7 = null;
        if (expressions.get(0) instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)expressions.get(0);
            this.parameterStreamNum = und.getStreamId();
            EventType type = streamTypeService.getEventTypes()[this.parameterStreamNum];
            this.parameterPropertyStart = type.getStartTimestampPropertyName();
            if (this.parameterPropertyStart == null) {
                throw new ExprValidationException("For date-time method '" + methodNameUse + "' the first parameter is event type '" + type.getName() + "', however no timestamp property has been defined for this event type");
            }
            timestampType = type.getPropertyType(this.parameterPropertyStart);
            EventPropertyGetter getter = type.getGetter(this.parameterPropertyStart);
            this.evaluatorTimestamp = new ExprEvaluatorStreamLongProp(this.parameterStreamNum, getter);
            if (type.getEndTimestampPropertyName() != null) {
                this.parameterPropertyEnd = type.getEndTimestampPropertyName();
                EventPropertyGetter getterEndTimestamp = type.getGetter(type.getEndTimestampPropertyName());
                ExprEvaluatorStreamLongProp exprEvaluatorStreamLongProp = new ExprEvaluatorStreamLongProp(this.parameterStreamNum, getterEndTimestamp);
            } else {
                this.parameterPropertyEnd = this.parameterPropertyStart;
            }
        } else {
            this.evaluatorTimestamp = expressions.get(0).getExprEvaluator();
            timestampType = this.evaluatorTimestamp.getType();
            String unresolvedPropertyName = null;
            if (expressions.get(0) instanceof ExprIdentNode) {
                ExprIdentNode identNode = (ExprIdentNode)expressions.get(0);
                this.parameterStreamNum = identNode.getStreamId();
                this.parameterPropertyEnd = this.parameterPropertyStart = identNode.getResolvedPropertyName();
                unresolvedPropertyName = identNode.getUnresolvedPropertyName();
            }
            if (!JavaClassHelper.isDatetimeClass(this.evaluatorTimestamp.getType())) {
                if (unresolvedPropertyName == null) throw new ExprValidationException("For date-time method '" + methodNameUse + "' the first parameter expression returns '" + this.evaluatorTimestamp.getType() + "', however requires a Date, Calendar, Long-type return value or event (with timestamp)");
                Pair<PropertyResolutionDescriptor, String> propertyDesc = ExprIdentNodeUtil.getTypeFromStream(streamTypeService, unresolvedPropertyName, false, true);
                if (propertyDesc.getFirst().getFragmentEventType() != null) {
                    EventType type = propertyDesc.getFirst().getFragmentEventType().getFragmentType();
                    this.parameterPropertyStart = type.getStartTimestampPropertyName();
                    if (this.parameterPropertyStart == null) {
                        throw new ExprValidationException("For date-time method '" + methodNameUse + "' the first parameter is event type '" + type.getName() + "', however no timestamp property has been defined for this event type");
                    }
                    timestampType = type.getPropertyType(this.parameterPropertyStart);
                    EventPropertyGetter getterFragment = streamTypeService.getEventTypes()[this.parameterStreamNum].getGetter(unresolvedPropertyName);
                    EventPropertyGetter getterStartTimestamp = type.getGetter(this.parameterPropertyStart);
                    this.evaluatorTimestamp = new ExprEvaluatorStreamLongPropFragment(this.parameterStreamNum, getterFragment, getterStartTimestamp);
                    if (type.getEndTimestampPropertyName() != null) {
                        this.parameterPropertyEnd = type.getEndTimestampPropertyName();
                        EventPropertyGetter getterEndTimestamp = type.getGetter(type.getEndTimestampPropertyName());
                        ExprEvaluatorStreamLongPropFragment exprEvaluatorStreamLongPropFragment = new ExprEvaluatorStreamLongPropFragment(this.parameterStreamNum, getterFragment, getterEndTimestamp);
                    } else {
                        this.parameterPropertyEnd = this.parameterPropertyStart;
                    }
                }
            }
        }
        IntervalComputer intervalComputer = IntervalComputerFactory.make(method, expressions, timeAbacus);
        if (var7_12 == null) {
            if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Calendar.class)) {
                this.intervalOpEval = new IntervalOpEvalCal(intervalComputer);
                return;
            } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Date.class)) {
                this.intervalOpEval = new IntervalOpEvalDate(intervalComputer);
                return;
            } else if (JavaClassHelper.getBoxedType(timestampType) == Long.class) {
                this.intervalOpEval = new IntervalOpEvalLong(intervalComputer);
                return;
            } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, LocalDateTime.class)) {
                this.intervalOpEval = new IntervalOpEvalLocalDateTime(intervalComputer, timeZone);
                return;
            } else {
                if (!JavaClassHelper.isSubclassOrImplementsInterface(timestampType, ZonedDateTime.class)) throw new IllegalArgumentException("Invalid interval first parameter type '" + timestampType + "'");
                this.intervalOpEval = new IntervalOpEvalZonedDateTime(intervalComputer);
            }
            return;
        } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Calendar.class)) {
            this.intervalOpEval = new IntervalOpEvalCalWithEnd(intervalComputer, (ExprEvaluator)var7_12);
            return;
        } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, Date.class)) {
            this.intervalOpEval = new IntervalOpEvalDateWithEnd(intervalComputer, (ExprEvaluator)var7_12);
            return;
        } else if (JavaClassHelper.getBoxedType(timestampType) == Long.class) {
            this.intervalOpEval = new IntervalOpEvalLongWithEnd(intervalComputer, (ExprEvaluator)var7_12);
            return;
        } else if (JavaClassHelper.isSubclassOrImplementsInterface(timestampType, LocalDateTime.class)) {
            this.intervalOpEval = new IntervalOpEvalLocalDateTimeWithEnd(intervalComputer, (ExprEvaluator)var7_12, timeZone);
            return;
        } else {
            if (!JavaClassHelper.isSubclassOrImplementsInterface(timestampType, ZonedDateTime.class)) throw new IllegalArgumentException("Invalid interval first parameter type '" + timestampType + "'");
            this.intervalOpEval = new IntervalOpEvalZonedDateTimeWithEnd(intervalComputer, (ExprEvaluator)var7_12);
        }
    }

    @Override
    public FilterExprAnalyzerDTIntervalAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        String targetPropertyEnd;
        String targetPropertyStart;
        int targetStreamNum;
        if (currentParameters.size() > 1) {
            return null;
        }
        if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputStream) {
            ExprDotNodeFilterAnalyzerInputStream targetStream = (ExprDotNodeFilterAnalyzerInputStream)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            EventType targetType = typesPerStream[targetStreamNum];
            targetPropertyStart = targetType.getStartTimestampPropertyName();
            targetPropertyEnd = targetType.getEndTimestampPropertyName() != null ? targetType.getEndTimestampPropertyName() : targetPropertyStart;
        } else if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputProp) {
            ExprDotNodeFilterAnalyzerInputProp targetStream = (ExprDotNodeFilterAnalyzerInputProp)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            targetPropertyStart = targetStream.getPropertyName();
            targetPropertyEnd = targetStream.getPropertyName();
        } else {
            return null;
        }
        if (this.parameterPropertyStart == null) {
            return null;
        }
        return new FilterExprAnalyzerDTIntervalAffector(currentMethod, typesPerStream, targetStreamNum, targetPropertyStart, targetPropertyEnd, this.parameterStreamNum, this.parameterPropertyStart, this.parameterPropertyEnd);
    }

    @Override
    public Object evaluate(long startTs, long endTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Object parameter = this.evaluatorTimestamp.evaluate(eventsPerStream, isNewData, context);
        if (parameter == null) {
            return parameter;
        }
        return this.intervalOpEval.evaluate(startTs, endTs, parameter, eventsPerStream, isNewData, context);
    }

    public static class IntervalOpEvalZonedDateTimeWithEnd
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpEvalZonedDateTimeWithEnd(IntervalComputer intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, DatetimeLongCoercerZonedDateTime.coerce((ZonedDateTime)parameterStartTs), DatetimeLongCoercerZonedDateTime.coerce((ZonedDateTime)parameterEndTs), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalLocalDateTimeWithEnd
    extends IntervalOpEvalDateWithEndBase {
        private final TimeZone timeZone;

        public IntervalOpEvalLocalDateTimeWithEnd(IntervalComputer intervalComputer, ExprEvaluator evaluatorEndTimestamp, TimeZone timeZone) {
            super(intervalComputer, evaluatorEndTimestamp);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, DatetimeLongCoercerLocalDateTime.coerce((LocalDateTime)parameterStartTs, this.timeZone), DatetimeLongCoercerLocalDateTime.coerce((LocalDateTime)parameterEndTs, this.timeZone), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalCalWithEnd
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpEvalCalWithEnd(IntervalComputer intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, ((Calendar)parameterStartTs).getTimeInMillis(), ((Calendar)parameterEndTs).getTimeInMillis(), eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalLongWithEnd
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpEvalLongWithEnd(IntervalComputer intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, (Long)parameterStartTs, (Long)parameterEndTs, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalDateWithEnd
    extends IntervalOpEvalDateWithEndBase {
        public IntervalOpEvalDateWithEnd(IntervalComputer intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            super(intervalComputer, evaluatorEndTimestamp);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, Object parameterEndTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            return this.intervalComputer.compute(startTs, endTs, ((Date)parameterStartTs).getTime(), ((Date)parameterEndTs).getTime(), eventsPerStream, isNewData, context);
        }
    }

    public static abstract class IntervalOpEvalDateWithEndBase
    implements IntervalOpEval {
        protected final IntervalComputer intervalComputer;
        private final ExprEvaluator evaluatorEndTimestamp;

        protected IntervalOpEvalDateWithEndBase(IntervalComputer intervalComputer, ExprEvaluator evaluatorEndTimestamp) {
            this.intervalComputer = intervalComputer;
            this.evaluatorEndTimestamp = evaluatorEndTimestamp;
        }

        public abstract Object evaluate(long var1, long var3, Object var5, Object var6, EventBean[] var7, boolean var8, ExprEvaluatorContext var9);

        @Override
        public Object evaluate(long startTs, long endTs, Object parameterStartTs, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            Object paramEndTs = this.evaluatorEndTimestamp.evaluate(eventsPerStream, isNewData, context);
            if (paramEndTs == null) {
                return null;
            }
            return this.evaluate(startTs, endTs, parameterStartTs, paramEndTs, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalZonedDateTime
    extends IntervalOpEvalDateBase {
        public IntervalOpEvalZonedDateTime(IntervalComputer intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = DatetimeLongCoercerZonedDateTime.coerce((ZonedDateTime)parameter);
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalLocalDateTime
    extends IntervalOpEvalDateBase {
        private final TimeZone timeZone;

        public IntervalOpEvalLocalDateTime(IntervalComputer intervalComputer, TimeZone timeZone) {
            super(intervalComputer);
            this.timeZone = timeZone;
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = DatetimeLongCoercerLocalDateTime.coerce((LocalDateTime)parameter, this.timeZone);
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalCal
    extends IntervalOpEvalDateBase {
        public IntervalOpEvalCal(IntervalComputer intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = ((Calendar)parameter).getTimeInMillis();
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalLong
    extends IntervalOpEvalDateBase {
        public IntervalOpEvalLong(IntervalComputer intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = (Long)parameter;
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }
    }

    public static class IntervalOpEvalDate
    extends IntervalOpEvalDateBase {
        public IntervalOpEvalDate(IntervalComputer intervalComputer) {
            super(intervalComputer);
        }

        @Override
        public Object evaluate(long startTs, long endTs, Object parameter, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
            long time = ((Date)parameter).getTime();
            return this.intervalComputer.compute(startTs, endTs, time, time, eventsPerStream, isNewData, context);
        }
    }

    public static abstract class IntervalOpEvalDateBase
    implements IntervalOpEval {
        protected final IntervalComputer intervalComputer;

        public IntervalOpEvalDateBase(IntervalComputer intervalComputer) {
            this.intervalComputer = intervalComputer;
        }
    }

    public static interface IntervalOpEval {
        public Object evaluate(long var1, long var3, Object var5, EventBean[] var6, boolean var7, ExprEvaluatorContext var8);
    }
}

