/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercer;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerFactory;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerLocalDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeLongCoercerZonedDateTime;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.FilterExprAnalyzerDTBetweenAffector;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputProp;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInputStream;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class ReformatOpBetweenNonConstantParams
implements ReformatOp {
    private final ExprNode start;
    private final ExprEvaluator startEval;
    private final DatetimeLongCoercer startCoercer;
    private final ExprNode end;
    private final ExprEvaluator endEval;
    private final DatetimeLongCoercer secondCoercer;
    private final TimeZone timeZone;
    private boolean includeBoth;
    private Boolean includeLow;
    private Boolean includeHigh;
    private ExprEvaluator evalIncludeLow;
    private ExprEvaluator evalIncludeHigh;

    public ReformatOpBetweenNonConstantParams(List<ExprNode> parameters, TimeZone timeZone) throws ExprValidationException {
        this.timeZone = timeZone;
        this.start = parameters.get(0);
        this.startEval = this.start.getExprEvaluator();
        this.startCoercer = DatetimeLongCoercerFactory.getCoercer(this.startEval.getType(), timeZone);
        this.end = parameters.get(1);
        this.endEval = this.end.getExprEvaluator();
        this.secondCoercer = DatetimeLongCoercerFactory.getCoercer(this.endEval.getType(), timeZone);
        if (parameters.size() == 2) {
            this.includeBoth = true;
            this.includeLow = true;
            this.includeHigh = true;
        } else {
            if (parameters.get(2).isConstantResult()) {
                this.includeLow = this.getBooleanValue(parameters.get(2));
            } else {
                this.evalIncludeLow = parameters.get(2).getExprEvaluator();
            }
            if (parameters.get(3).isConstantResult()) {
                this.includeHigh = this.getBooleanValue(parameters.get(3));
            } else {
                this.evalIncludeHigh = parameters.get(3).getExprEvaluator();
            }
            if (this.includeLow != null && this.includeHigh != null && this.includeLow.booleanValue() && this.includeHigh.booleanValue()) {
                this.includeBoth = true;
            }
        }
    }

    private boolean getBooleanValue(ExprNode exprNode) throws ExprValidationException {
        Object value = exprNode.getExprEvaluator().evaluate(null, true, null);
        if (value == null) {
            throw new ExprValidationException("Date-time method 'between' requires non-null parameter values");
        }
        return (Boolean)value;
    }

    @Override
    public Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (ts == null) {
            return null;
        }
        return this.evaluateInternal(ts, eventsPerStream, newData, exprEvaluatorContext);
    }

    @Override
    public Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (d == null) {
            return null;
        }
        return this.evaluateInternal(d.getTime(), eventsPerStream, newData, exprEvaluatorContext);
    }

    @Override
    public Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (cal == null) {
            return null;
        }
        return this.evaluateInternal(cal.getTimeInMillis(), eventsPerStream, newData, exprEvaluatorContext);
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(DatetimeLongCoercerLocalDateTime.coerce(ldt, this.timeZone), eventsPerStream, newData, exprEvaluatorContext);
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.evaluateInternal(DatetimeLongCoercerZonedDateTime.coerce(zdt), eventsPerStream, newData, exprEvaluatorContext);
    }

    @Override
    public Class getReturnType() {
        return Boolean.class;
    }

    public Object evaluateInternal(long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        boolean includeHighEndpoint;
        boolean includeLowEndpoint;
        Object firstObj = this.startEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
        if (firstObj == null) {
            return null;
        }
        Object secondObj = this.endEval.evaluate(eventsPerStream, newData, exprEvaluatorContext);
        if (secondObj == null) {
            return null;
        }
        long first = this.startCoercer.coerce(firstObj);
        long second = this.secondCoercer.coerce(secondObj);
        if (this.includeBoth) {
            if (first <= second) {
                return first <= ts && ts <= second;
            }
            return second <= ts && ts <= first;
        }
        if (this.includeLow != null) {
            includeLowEndpoint = this.includeLow;
        } else {
            Object value = this.evalIncludeLow.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (value == null) {
                return null;
            }
            includeLowEndpoint = (Boolean)value;
        }
        if (this.includeHigh != null) {
            includeHighEndpoint = this.includeHigh;
        } else {
            Object value = this.evalIncludeHigh.evaluate(eventsPerStream, newData, exprEvaluatorContext);
            if (value == null) {
                return null;
            }
            includeHighEndpoint = (Boolean)value;
        }
        if (includeLowEndpoint ? ts < first : ts <= first) {
            return false;
        }
        if (includeHighEndpoint ? ts > second : ts >= second) {
            return false;
        }
        return true;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        String targetProperty;
        int targetStreamNum;
        if (this.includeLow == null || this.includeHigh == null) {
            return null;
        }
        if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputStream) {
            ExprDotNodeFilterAnalyzerInputStream targetStream = (ExprDotNodeFilterAnalyzerInputStream)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            EventType targetType = typesPerStream[targetStreamNum];
            targetProperty = targetType.getStartTimestampPropertyName();
        } else if (inputDesc instanceof ExprDotNodeFilterAnalyzerInputProp) {
            ExprDotNodeFilterAnalyzerInputProp targetStream = (ExprDotNodeFilterAnalyzerInputProp)inputDesc;
            targetStreamNum = targetStream.getStreamNum();
            targetProperty = targetStream.getPropertyName();
        } else {
            return null;
        }
        return new FilterExprAnalyzerDTBetweenAffector(typesPerStream, targetStreamNum, targetProperty, this.start, this.end, this.includeLow, this.includeHigh);
    }
}

