/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.datetime.reformatop;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.reformatop.ReformatOp;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.time.TimeAbacus;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class ReformatOpFormat
implements ReformatOp {
    private final DateFormat dateForma;
    private final DateTimeFormatter dateTimeFormatter;
    private final TimeAbacus timeAbacus;

    public ReformatOpFormat(Object formatter, TimeAbacus timeAbacus) {
        if (formatter instanceof DateFormat) {
            this.dateForma = (DateFormat)formatter;
            this.dateTimeFormatter = null;
        } else {
            this.dateForma = null;
            this.dateTimeFormatter = (DateTimeFormatter)formatter;
        }
        this.timeAbacus = timeAbacus;
    }

    @Override
    public synchronized Object evaluate(Long ts, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.timeAbacus.getOneSecond() == 1000L) {
            this.dateForma.format(ts);
        }
        return this.dateForma.format(this.timeAbacus.toDate(ts));
    }

    @Override
    public synchronized Object evaluate(Date d, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.dateForma.format(d);
    }

    @Override
    public synchronized Object evaluate(Calendar cal, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return this.dateForma.format(cal.getTime());
    }

    @Override
    public Object evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return ldt.format(this.dateTimeFormatter);
    }

    @Override
    public Object evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        return zdt.format(this.dateTimeFormatter);
    }

    @Override
    public Class getReturnType() {
        return String.class;
    }

    @Override
    public FilterExprAnalyzerAffector getFilterDesc(EventType[] typesPerStream, DatetimeMethodEnum currentMethod, List<ExprNode> currentParameters, ExprDotNodeFilterAnalyzerInput inputDesc) {
        return null;
    }
}

