/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationStateKey;
import com.espertech.esper.epl.agg.access.AggregationStateType;
import com.espertech.esper.epl.agg.aggregator.AggregationMethod;
import com.espertech.esper.epl.agg.factory.AggregationMethodFactoryUtil;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.AggregationValidationUtil;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionLinearAccessNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.methodagg.ExprMethodAggUtil;

public class AggregationMethodFactoryFirstLastUnbound
implements AggregationMethodFactory {
    protected final ExprAggMultiFunctionLinearAccessNode parent;
    private final EventType collectionEventType;
    private final Class resultType;
    private final int streamNum;
    protected final boolean hasFilter;

    public AggregationMethodFactoryFirstLastUnbound(ExprAggMultiFunctionLinearAccessNode parent, EventType collectionEventType, Class resultType, int streamNum, boolean hasFilter) {
        this.parent = parent;
        this.collectionEventType = collectionEventType;
        this.resultType = resultType;
        this.streamNum = streamNum;
        this.hasFilter = hasFilter;
    }

    @Override
    public Class getResultType() {
        return this.resultType;
    }

    @Override
    public AggregationStateKey getAggregationStateKey(boolean isMatchRecognize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAccessAggregation() {
        return false;
    }

    @Override
    public AggregationStateFactory getAggregationStateFactory(boolean isMatchRecognize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregationAccessor getAccessor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public AggregationMethod make() {
        if (this.parent.getStateType() == AggregationStateType.FIRST) {
            return AggregationMethodFactoryUtil.makeFirstEver(this.hasFilter);
        }
        if (this.parent.getStateType() == AggregationStateType.LAST) {
            return AggregationMethodFactoryUtil.makeLastEver(this.hasFilter);
        }
        throw new RuntimeException("Window aggregation function is not available");
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public void validateIntoTableCompatible(AggregationMethodFactory intoTableAgg) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, intoTableAgg);
        AggregationMethodFactoryFirstLastUnbound that = (AggregationMethodFactoryFirstLastUnbound)intoTableAgg;
        AggregationValidationUtil.validateStreamNumZero(that.streamNum);
        if (this.collectionEventType != null) {
            AggregationValidationUtil.validateEventType(this.collectionEventType, that.collectionEventType);
        } else {
            AggregationValidationUtil.validateAggregationInputType(this.resultType, that.resultType);
        }
    }

    @Override
    public AggregationAgent getAggregationStateAgent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExprEvaluator getMethodAggregationEvaluator(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultEvaluator(this.parent.getPositionalParams(), join, typesPerStream);
    }
}

