/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.epl.agg.access.AggregationAccessor;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstLastIndexNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstLastIndexWEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorFirstWEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorLastNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorLastWEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorWindowNoEval;
import com.espertech.esper.epl.agg.access.AggregationAccessorWindowWEval;
import com.espertech.esper.epl.agg.access.AggregationAgent;
import com.espertech.esper.epl.agg.access.AggregationAgentDefault;
import com.espertech.esper.epl.agg.access.AggregationStateType;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.agg.service.AggregationStateKeyWStream;
import com.espertech.esper.epl.agg.service.AggregationStateTypeWStream;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.accessagg.ExprAggAggregationAgentFactory;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionLinearAccessNodeFactoryAccess;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionUtil;
import com.espertech.esper.epl.expression.accessagg.ExprAggregateAccessMultiValueNode;
import com.espertech.esper.epl.expression.accessagg.LinearAggregationFactoryDesc;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprStreamUnderlyingNode;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.core.ExprWildcard;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.epl.table.mgmt.TableMetadataColumnAggregation;
import com.espertech.esper.epl.table.mgmt.TableServiceUtil;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class ExprAggMultiFunctionLinearAccessNode
extends ExprAggregateNodeBase
implements ExprEvaluatorEnumeration,
ExprAggregateAccessMultiValueNode {
    private static final long serialVersionUID = -6088874732989061687L;
    private final AggregationStateType stateType;
    private transient EventType containedType;
    private transient Class scalarCollectionComponentType;

    public ExprAggMultiFunctionLinearAccessNode(AggregationStateType stateType) {
        super(false);
        this.stateType = stateType;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, null);
    }

    @Override
    public AggregationMethodFactory validateAggregationParamsWBinding(ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccessColumn) throws ExprValidationException {
        return this.validateAggregationInternal(validationContext, tableAccessColumn);
    }

    private AggregationMethodFactory validateAggregationInternal(ExprValidationContext validationContext, TableMetadataColumnAggregation optionalBinding) throws ExprValidationException {
        LinearAggregationFactoryDesc desc = optionalBinding != null ? this.handleTableAccess(this.positionalParams, this.stateType, validationContext, optionalBinding) : (validationContext.getExprEvaluatorContext().getStatementType() == StatementType.CREATE_TABLE ? this.handleCreateTable(this.positionalParams, this.stateType, validationContext) : (validationContext.getIntoTableName() != null ? this.handleIntoTable(this.positionalParams, this.stateType, validationContext) : this.handleNonIntoTable(this.positionalParams, this.stateType, validationContext)));
        this.containedType = desc.getEnumerationEventType();
        this.scalarCollectionComponentType = desc.getScalarCollectionType();
        return desc.getFactory();
    }

    private LinearAggregationFactoryDesc handleNonIntoTable(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        AggregationAccessor accessor;
        boolean istreamOnly;
        ExprEvaluator evaluator;
        Class resultType;
        EventType containedType;
        int streamNum;
        boolean isWildcard;
        StreamTypeService streamTypeService = validationContext.getStreamTypeService();
        ExprNode evaluatorIndex = null;
        Class scalarCollectionComponentType = null;
        boolean bl = isWildcard = childNodes.length == 0 || childNodes.length > 0 && childNodes[0] instanceof ExprWildcard;
        if (isWildcard) {
            ExprAggMultiFunctionUtil.validateWildcardStreamNumbers(validationContext.getStreamTypeService(), stateType.toString().toLowerCase(Locale.ENGLISH));
            streamNum = 0;
            containedType = streamTypeService.getEventTypes()[0];
            resultType = containedType.getUnderlyingType();
            TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(containedType);
            evaluator = ExprNodeUtility.makeUnderlyingEvaluator(0, resultType, tableMetadata);
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, 0);
            if (stateType == AggregationStateType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
        } else if (childNodes.length > 0 && childNodes[0] instanceof ExprStreamUnderlyingNode) {
            EventType type;
            streamNum = ExprAggMultiFunctionUtil.validateStreamWildcardGetStreamNum(childNodes[0]);
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, streamNum);
            if (stateType == AggregationStateType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
            containedType = type = streamTypeService.getEventTypes()[streamNum];
            resultType = type.getUnderlyingType();
            TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(type);
            evaluator = ExprNodeUtility.makeUnderlyingEvaluator(streamNum, resultType, tableMetadata);
        } else {
            ExprNode child = childNodes[0];
            Set<Integer> streams = ExprNodeUtility.getIdentStreamNumbers(child);
            if (streams.isEmpty() || streams.size() > 1) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that any child expressions evaluate properties of the same stream; Use 'firstever' or 'lastever' or 'nth' instead");
            }
            streamNum = streams.iterator().next();
            istreamOnly = ExprAggMultiFunctionLinearAccessNode.getIstreamOnly(streamTypeService, streamNum);
            if (stateType == AggregationStateType.WINDOW && istreamOnly && !streamTypeService.isOnDemandStreams()) {
                throw ExprAggMultiFunctionLinearAccessNode.makeUnboundValidationEx(stateType);
            }
            resultType = childNodes[0].getExprEvaluator().getType();
            evaluator = childNodes[0].getExprEvaluator();
            containedType = streamNum >= streamTypeService.getEventTypes().length ? streamTypeService.getEventTypes()[0] : streamTypeService.getEventTypes()[streamNum];
            scalarCollectionComponentType = resultType;
        }
        if (childNodes.length > 1) {
            if (stateType == AggregationStateType.WINDOW) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " does not accept an index expression; Use 'first' or 'last' instead");
            }
            evaluatorIndex = childNodes[1];
            if (evaluatorIndex.getExprEvaluator().getType() != Integer.class) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires an index expression that returns an integer value");
            }
        }
        if (evaluatorIndex != null) {
            boolean isFirst = stateType == AggregationStateType.FIRST;
            int constant = -1;
            if (evaluatorIndex.isConstantResult()) {
                constant = (Integer)evaluatorIndex.getExprEvaluator().evaluate(null, true, null);
            }
            accessor = new AggregationAccessorFirstLastIndexWEval(streamNum, evaluator, evaluatorIndex.getExprEvaluator(), constant, isFirst);
        } else if (stateType == AggregationStateType.FIRST) {
            accessor = new AggregationAccessorFirstWEval(streamNum, evaluator);
        } else if (stateType == AggregationStateType.LAST) {
            accessor = new AggregationAccessorLastWEval(streamNum, evaluator);
        } else if (stateType == AggregationStateType.WINDOW) {
            accessor = new AggregationAccessorWindowWEval(streamNum, evaluator, resultType);
        } else {
            throw new IllegalStateException("Access type is undefined or not known as code '" + (Object)((Object)stateType) + "'");
        }
        Class accessorResultType = resultType;
        if (stateType == AggregationStateType.WINDOW) {
            accessorResultType = JavaClassHelper.getArrayType(resultType);
        }
        boolean isFafWindow = streamTypeService.isOnDemandStreams() && stateType == AggregationStateType.WINDOW;
        TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(containedType);
        if (tableMetadata == null && !isFafWindow && (istreamOnly || streamTypeService.isOnDemandStreams())) {
            if (this.optionalFilter != null) {
                this.positionalParams = ExprNodeUtility.addExpression(this.positionalParams, this.optionalFilter);
            }
            AggregationMethodFactory factory = validationContext.getEngineImportService().getAggregationFactoryFactory().makeLinearUnbounded(validationContext.getStatementExtensionSvcContext(), this, containedType, accessorResultType, streamNum, this.optionalFilter != null);
            return new LinearAggregationFactoryDesc(factory, containedType, scalarCollectionComponentType);
        }
        AggregationStateKeyWStream stateKey = new AggregationStateKeyWStream(streamNum, containedType, AggregationStateTypeWStream.DATAWINDOWACCESS_LINEAR, new ExprNode[0], this.optionalFilter);
        ExprEvaluator optionalFilterEval = this.optionalFilter == null ? null : this.optionalFilter.getExprEvaluator();
        AggregationStateFactory stateFactory = validationContext.getEngineImportService().getAggregationFactoryFactory().makeLinear(validationContext.getStatementExtensionSvcContext(), this, streamNum, optionalFilterEval);
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, accessorResultType, containedType, stateKey, stateFactory, AggregationAgentDefault.INSTANCE);
        EventType enumerationType = scalarCollectionComponentType == null ? containedType : null;
        return new LinearAggregationFactoryDesc(factory, enumerationType, scalarCollectionComponentType);
    }

    private LinearAggregationFactoryDesc handleCreateTable(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        String message = "For tables columns, the " + stateType.name().toLowerCase(Locale.ENGLISH) + " aggregation function requires the 'window(*)' declaration";
        if (stateType != AggregationStateType.WINDOW) {
            throw new ExprValidationException(message);
        }
        if (childNodes.length == 0 || childNodes.length > 1 || !(childNodes[0] instanceof ExprWildcard)) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that the event type is provided");
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[0];
        Class componentType = containedType.getUnderlyingType();
        AggregationAccessorWindowNoEval accessor = new AggregationAccessorWindowNoEval(componentType);
        AggregationStateFactory stateFactory = validationContext.getEngineImportService().getAggregationFactoryFactory().makeLinear(validationContext.getStatementExtensionSvcContext(), this, 0, null);
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, JavaClassHelper.getArrayType(componentType), containedType, null, stateFactory, null);
        return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
    }

    private LinearAggregationFactoryDesc handleIntoTable(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext) throws ExprValidationException {
        int streamNum;
        String message = "For into-table use 'window(*)' or ''window(stream.*)' instead";
        if (stateType != AggregationStateType.WINDOW) {
            throw new ExprValidationException(message);
        }
        if (childNodes.length == 0 || childNodes.length > 1) {
            throw new ExprValidationException(message);
        }
        if (validationContext.getStreamTypeService().getStreamNames().length == 0) {
            throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that at least one stream is provided");
        }
        if (childNodes[0] instanceof ExprWildcard) {
            if (validationContext.getStreamTypeService().getStreamNames().length != 1) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " with wildcard requires a single stream");
            }
            streamNum = 0;
        } else if (childNodes[0] instanceof ExprStreamUnderlyingNode) {
            ExprStreamUnderlyingNode und = (ExprStreamUnderlyingNode)childNodes[0];
            streamNum = und.getStreamId();
        } else {
            throw new ExprValidationException(message);
        }
        EventType containedType = validationContext.getStreamTypeService().getEventTypes()[streamNum];
        Class componentType = containedType.getUnderlyingType();
        AggregationAccessorWindowNoEval accessor = new AggregationAccessorWindowNoEval(componentType);
        AggregationAgent agent = ExprAggAggregationAgentFactory.make(streamNum, this.optionalFilter);
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, JavaClassHelper.getArrayType(componentType), containedType, null, null, agent);
        return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
    }

    private LinearAggregationFactoryDesc handleTableAccess(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccess) throws ExprValidationException {
        if (stateType == AggregationStateType.FIRST || stateType == AggregationStateType.LAST) {
            return this.handleTableAccessFirstLast(childNodes, stateType, validationContext, tableAccess);
        }
        if (stateType == AggregationStateType.WINDOW) {
            return this.handleTableAccessWindow(childNodes, stateType, validationContext, tableAccess);
        }
        throw new IllegalStateException("Unrecognized type " + (Object)((Object)stateType));
    }

    private LinearAggregationFactoryDesc handleTableAccessFirstLast(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccess) throws ExprValidationException {
        AggregationAccessor defaultAccessor;
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess original = (ExprAggMultiFunctionLinearAccessNodeFactoryAccess)tableAccess.getFactory();
        Class resultType = original.getContainedEventType().getUnderlyingType();
        AggregationAccessor aggregationAccessor = defaultAccessor = stateType == AggregationStateType.FIRST ? AggregationAccessorFirstNoEval.INSTANCE : AggregationAccessorLastNoEval.INSTANCE;
        if (childNodes.length == 0) {
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factoryAccess = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, defaultAccessor, resultType, original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factoryAccess, factoryAccess.getContainedEventType(), null);
        }
        if (childNodes.length == 1) {
            if (childNodes[0] instanceof ExprWildcard) {
                ExprAggMultiFunctionLinearAccessNodeFactoryAccess factoryAccess = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, defaultAccessor, resultType, original.getContainedEventType(), null, null, null);
                return new LinearAggregationFactoryDesc(factoryAccess, factoryAccess.getContainedEventType(), null);
            }
            if (childNodes[0] instanceof ExprStreamUnderlyingNode) {
                throw new ExprValidationException("Stream-wildcard is not allowed for table column access");
            }
            ExprNode paramNode = childNodes[0];
            StreamTypeServiceImpl streams = TableServiceUtil.streamTypeFromTableColumn(tableAccess, validationContext.getStreamTypeService().getEngineURIQualifier());
            ExprValidationContext localValidationContext = new ExprValidationContext(streams, validationContext);
            paramNode = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, paramNode, localValidationContext);
            ExprEvaluator paramNodeEval = paramNode.getExprEvaluator();
            AggregationAccessor accessor = stateType == AggregationStateType.FIRST ? new AggregationAccessorFirstWEval(0, paramNodeEval) : new AggregationAccessorLastWEval(0, paramNodeEval);
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, paramNodeEval.getType(), original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
        }
        if (childNodes.length == 2) {
            ExprEvaluator evaluatorIndex;
            boolean isFirst = stateType == AggregationStateType.FIRST;
            int constant = -1;
            ExprNode indexEvalNode = childNodes[1];
            if (indexEvalNode.isConstantResult()) {
                constant = (Integer)indexEvalNode.getExprEvaluator().evaluate(null, true, null);
            }
            if ((evaluatorIndex = indexEvalNode.getExprEvaluator()).getType() != Integer.class) {
                throw new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires a constant index expression that returns an integer value");
            }
            AggregationAccessorFirstLastIndexNoEval accessor = new AggregationAccessorFirstLastIndexNoEval(evaluatorIndex, constant, isFirst);
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, resultType, original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
        }
        throw new ExprValidationException("Invalid number of parameters");
    }

    private LinearAggregationFactoryDesc handleTableAccessWindow(ExprNode[] childNodes, AggregationStateType stateType, ExprValidationContext validationContext, TableMetadataColumnAggregation tableAccess) throws ExprValidationException {
        ExprAggMultiFunctionLinearAccessNodeFactoryAccess original = (ExprAggMultiFunctionLinearAccessNodeFactoryAccess)tableAccess.getFactory();
        if (childNodes.length == 0 || childNodes.length == 1 && childNodes[0] instanceof ExprWildcard) {
            Class componentType = original.getContainedEventType().getUnderlyingType();
            AggregationAccessorWindowNoEval accessor = new AggregationAccessorWindowNoEval(componentType);
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, accessor, JavaClassHelper.getArrayType(componentType), original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, factory.getContainedEventType(), null);
        }
        if (childNodes.length == 1) {
            ExprNode paramNode = childNodes[0];
            StreamTypeServiceImpl streams = TableServiceUtil.streamTypeFromTableColumn(tableAccess, validationContext.getStreamTypeService().getEngineURIQualifier());
            ExprValidationContext localValidationContext = new ExprValidationContext(streams, validationContext);
            paramNode = ExprNodeUtility.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, paramNode, localValidationContext);
            ExprEvaluator paramNodeEval = paramNode.getExprEvaluator();
            ExprAggMultiFunctionLinearAccessNodeFactoryAccess factory = new ExprAggMultiFunctionLinearAccessNodeFactoryAccess(this, new AggregationAccessorWindowWEval(0, paramNodeEval, paramNodeEval.getType()), JavaClassHelper.getArrayType(paramNodeEval.getType()), original.getContainedEventType(), null, null, null);
            return new LinearAggregationFactoryDesc(factory, null, paramNodeEval.getType());
        }
        throw new ExprValidationException("Invalid number of parameters");
    }

    protected static boolean getIstreamOnly(StreamTypeService streamTypeService, int streamNum) {
        if (streamNum < streamTypeService.getEventTypes().length) {
            return streamTypeService.getIStreamOnly()[streamNum];
        }
        return streamTypeService.getIStreamOnly()[0];
    }

    @Override
    public String getAggregationFunctionName() {
        return this.stateType.toString().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.stateType.toString().toLowerCase(Locale.ENGLISH));
        ExprNodeUtility.toExpressionStringParams(writer, this.getChildNodes());
    }

    public AggregationStateType getStateType() {
        return this.stateType;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollectionOfEvents(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getCollectionScalar(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) {
        if (this.stateType == AggregationStateType.FIRST || this.stateType == AggregationStateType.LAST) {
            return null;
        }
        return this.containedType;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.scalarCollectionComponentType;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        if (this.stateType == AggregationStateType.FIRST || this.stateType == AggregationStateType.LAST) {
            return this.containedType;
        }
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return this.aggregationResultFuture.getEventBean(this.column, eventsPerStream, isNewData, context);
    }

    @Override
    protected boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return false;
    }

    private static ExprValidationException makeUnboundValidationEx(AggregationStateType stateType) {
        return new ExprValidationException(ExprAggMultiFunctionLinearAccessNode.getErrorPrefix(stateType) + " requires that the aggregated events provide a remove stream; Please define a data window onto the stream or use 'firstever', 'lastever' or 'nth' instead");
    }

    private static String getErrorPrefix(AggregationStateType stateType) {
        return ExprAggMultiFunctionUtil.getErrorPrefix(stateType.toString().toLowerCase(Locale.ENGLISH));
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

