/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.accessagg;

import com.espertech.esper.core.service.StatementExtensionSvcContext;
import com.espertech.esper.epl.agg.access.AggregationStateMinMaxByEverSpec;
import com.espertech.esper.epl.agg.access.AggregationStateSortedSpec;
import com.espertech.esper.epl.agg.service.AggregationStateFactory;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.accessagg.ExprAggMultiFunctionSortedMinMaxByNode;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.util.CollectionUtil;
import java.util.Comparator;

public class SortedAggregationStateFactoryFactory {
    private final EngineImportService engineImportService;
    private final StatementExtensionSvcContext statementExtensionSvcContext;
    private final ExprEvaluator[] evaluators;
    private final boolean[] sortDescending;
    private final boolean ever;
    private final int streamNum;
    private final ExprAggMultiFunctionSortedMinMaxByNode parent;
    private final ExprEvaluator optionalFilter;

    public SortedAggregationStateFactoryFactory(EngineImportService engineImportService, StatementExtensionSvcContext statementExtensionSvcContext, ExprEvaluator[] evaluators, boolean[] sortDescending, boolean ever, int streamNum, ExprAggMultiFunctionSortedMinMaxByNode parent, ExprEvaluator optionalFilter) {
        this.engineImportService = engineImportService;
        this.statementExtensionSvcContext = statementExtensionSvcContext;
        this.evaluators = evaluators;
        this.sortDescending = sortDescending;
        this.ever = ever;
        this.streamNum = streamNum;
        this.parent = parent;
        this.optionalFilter = optionalFilter;
    }

    public AggregationStateFactory makeFactory() {
        boolean sortUsingCollator = this.engineImportService.isSortUsingCollator();
        Comparator<Object> comparator = CollectionUtil.getComparator(this.evaluators, sortUsingCollator, this.sortDescending);
        if (this.ever) {
            AggregationStateMinMaxByEverSpec spec = new AggregationStateMinMaxByEverSpec(this.streamNum, this.evaluators, this.parent.isMax(), comparator, null, this.optionalFilter);
            return this.engineImportService.getAggregationFactoryFactory().makeMinMaxEver(this.statementExtensionSvcContext, this.parent, spec);
        }
        AggregationStateSortedSpec spec = new AggregationStateSortedSpec(this.streamNum, this.evaluators, comparator, null, this.optionalFilter);
        return this.engineImportService.getAggregationFactoryFactory().makeSorted(this.statementExtensionSvcContext, this.parent, spec);
    }
}

