/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetterIndexed;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.dot.ExprDotEvalPropertyExprBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprDotEvalPropertyExprIndexed
extends ExprDotEvalPropertyExprBase {
    private static final Logger log = LoggerFactory.getLogger(ExprDotEvalPropertyExprIndexed.class);
    private final EventPropertyGetterIndexed indexedGetter;

    public ExprDotEvalPropertyExprIndexed(String statementName, String propertyName, int streamNum, ExprEvaluator exprEvaluator, Class propertyType, EventPropertyGetterIndexed indexedGetter) {
        super(statementName, propertyName, streamNum, exprEvaluator, propertyType);
        this.indexedGetter = indexedGetter;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        EventBean eventInQuestion = eventsPerStream[this.streamNum];
        if (eventInQuestion == null) {
            return null;
        }
        Object index = this.exprEvaluator.evaluate(eventsPerStream, isNewData, context);
        if (index == null || !(index instanceof Integer)) {
            log.warn(super.getWarningText("integer", index));
            return null;
        }
        return this.indexedGetter.get(eventInQuestion, (Integer)index);
    }
}

