/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotNodeUtility;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExprDotEvalStaticMethod
implements ExprEvaluator,
EventPropertyGetter {
    private static final Logger log = LoggerFactory.getLogger(ExprDotEvalStaticMethod.class);
    private final String statementName;
    private final String classOrPropertyName;
    private final FastMethod staticMethod;
    private final ExprEvaluator[] childEvals;
    private final boolean isConstantParameters;
    private final ExprDotEval[] chainEval;
    private final ExprDotStaticMethodWrap resultWrapLambda;
    private final boolean rethrowExceptions;
    private final Object targetObject;
    private boolean isCachedResult;
    private Object cachedResult;

    public ExprDotEvalStaticMethod(String statementName, String classOrPropertyName, FastMethod staticMethod, ExprEvaluator[] childEvals, boolean constantParameters, ExprDotStaticMethodWrap resultWrapLambda, ExprDotEval[] chainEval, boolean rethrowExceptions, Object targetObject) {
        this.statementName = statementName;
        this.classOrPropertyName = classOrPropertyName;
        this.staticMethod = staticMethod;
        this.childEvals = childEvals;
        this.targetObject = targetObject;
        this.isConstantParameters = chainEval.length > 0 ? false : constantParameters;
        this.resultWrapLambda = resultWrapLambda;
        this.chainEval = chainEval;
        this.rethrowExceptions = rethrowExceptions;
    }

    @Override
    public Class getType() {
        if (this.chainEval.length == 0) {
            return this.staticMethod.getReturnType();
        }
        return EPTypeHelper.getNormalizedClass(this.chainEval[this.chainEval.length - 1].getTypeInfo());
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.isConstantParameters && this.isCachedResult) {
            return this.cachedResult;
        }
        Object[] args = new Object[this.childEvals.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.childEvals[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        try {
            Object result = this.staticMethod.invoke(this.targetObject, args);
            result = ExprDotNodeUtility.evaluateChainWithWrap(this.resultWrapLambda, result, null, this.staticMethod.getReturnType(), this.chainEval, eventsPerStream, isNewData, exprEvaluatorContext);
            if (this.isConstantParameters) {
                this.cachedResult = result;
                this.isCachedResult = true;
            }
            return result;
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, this.staticMethod.getJavaMethod(), this.classOrPropertyName, args, e);
            log.error(message, e.getTargetException());
            if (this.rethrowExceptions) {
                throw new EPException(message, e.getTargetException());
            }
            return null;
        }
    }

    @Override
    public Object get(EventBean eventBean) throws PropertyAccessException {
        Object[] args = new Object[this.childEvals.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.childEvals[i].evaluate(new EventBean[]{eventBean}, false, null);
        }
        try {
            return this.staticMethod.invoke(this.targetObject, args);
        }
        catch (InvocationTargetException e) {
            String message = JavaClassHelper.getMessageInvocationTarget(this.statementName, this.staticMethod.getJavaMethod(), this.classOrPropertyName, args, e);
            log.error(message, e.getTargetException());
            if (this.rethrowExceptions) {
                throw new EPException(message, e.getTargetException());
            }
            return null;
        }
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return false;
    }

    @Override
    public Object getFragment(EventBean eventBean) throws PropertyAccessException {
        return null;
    }
}

