/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.dot;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.datetime.eval.DatetimeMethodEnum;
import com.espertech.esper.epl.datetime.eval.ExprDotEvalDTFactory;
import com.espertech.esper.epl.datetime.eval.ExprDotEvalDTMethodDesc;
import com.espertech.esper.epl.enummethod.dot.EnumMethodEnum;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalEnumMethod;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalProperty;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalUnpackBean;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalUnpackBeanTable;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalUnpackCollEventBean;
import com.espertech.esper.epl.enummethod.dot.ExprDotEvalUnpackCollEventBeanTable;
import com.espertech.esper.epl.enummethod.dot.ExprDotStaticMethodWrap;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorEventCollection;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorEventSingle;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarArray;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarCollection;
import com.espertech.esper.epl.enummethod.dot.PropertyExprEvaluatorScalarIterable;
import com.espertech.esper.epl.expression.core.ExprChainedSpec;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumerationGivenEvent;
import com.espertech.esper.epl.expression.core.ExprIdentNode;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtilMethodDesc;
import com.espertech.esper.epl.expression.core.ExprNodeUtilResolveExceptionHandler;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.dot.ExprDotEnumerationSource;
import com.espertech.esper.epl.expression.dot.ExprDotEnumerationSourceForProps;
import com.espertech.esper.epl.expression.dot.ExprDotEval;
import com.espertech.esper.epl.expression.dot.ExprDotEvalArrayGet;
import com.espertech.esper.epl.expression.dot.ExprDotEvalArraySize;
import com.espertech.esper.epl.expression.dot.ExprDotMethodEvalDuck;
import com.espertech.esper.epl.expression.dot.ExprDotMethodEvalNoDuck;
import com.espertech.esper.epl.expression.dot.ExprDotMethodEvalNoDuckUnderlying;
import com.espertech.esper.epl.expression.dot.ExprDotMethodEvalNoDuckWrapArray;
import com.espertech.esper.epl.expression.dot.ExprDotNodeFilterAnalyzerInput;
import com.espertech.esper.epl.expression.dot.ExprDotNodeRealizedChain;
import com.espertech.esper.epl.join.plan.FilterExprAnalyzerAffector;
import com.espertech.esper.epl.rettype.ClassEPType;
import com.espertech.esper.epl.rettype.ClassMultiValuedEPType;
import com.espertech.esper.epl.rettype.EPType;
import com.espertech.esper.epl.rettype.EPTypeHelper;
import com.espertech.esper.epl.rettype.EventEPType;
import com.espertech.esper.epl.rettype.EventMultiValuedEPType;
import com.espertech.esper.epl.table.mgmt.TableMetadata;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeUtility;
import com.espertech.esper.event.arr.ObjectArrayEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.sf.cglib.reflect.FastMethod;

public class ExprDotNodeUtility {
    public static boolean isDatetimeOrEnumMethod(String name) {
        return EnumMethodEnum.isEnumerationMethod(name) || DatetimeMethodEnum.isDateTimeMethod(name);
    }

    public static ExprDotNodeRealizedChain getChainEvaluators(Integer streamOfProviderIfApplicable, EPType inputType, List<ExprChainedSpec> chainSpec, ExprValidationContext validationContext, boolean isDuckTyping, ExprDotNodeFilterAnalyzerInput inputDesc) throws ExprValidationException {
        ArrayList<ExprDotEval> methodEvals = new ArrayList<ExprDotEval>();
        EPType currentInputType = inputType;
        EnumMethodEnum lastLambdaFunc = null;
        ExprChainedSpec lastElement = chainSpec.isEmpty() ? null : chainSpec.get(chainSpec.size() - 1);
        FilterExprAnalyzerAffector filterAnalyzerDesc = null;
        ArrayDeque<ExprChainedSpec> chainSpecStack = new ArrayDeque<ExprChainedSpec>(chainSpec);
        while (!chainSpecStack.isEmpty()) {
            ExprChainedSpec chainElement = (ExprChainedSpec)chainSpecStack.removeFirst();
            lastLambdaFunc = null;
            ExprEvaluator[] paramEvals = new ExprEvaluator[chainElement.getParameters().size()];
            Class[] paramTypes = new Class[chainElement.getParameters().size()];
            for (int i = 0; i < chainElement.getParameters().size(); ++i) {
                paramEvals[i] = chainElement.getParameters().get(i).getExprEvaluator();
                paramTypes[i] = paramEvals[i].getType();
            }
            if (currentInputType instanceof ClassMultiValuedEPType) {
                ClassMultiValuedEPType type = (ClassMultiValuedEPType)currentInputType;
                if (chainElement.getName().toLowerCase(Locale.ENGLISH).equals("size") && paramTypes.length == 0 && lastElement == chainElement) {
                    ExprDotEvalArraySize sizeExpr = new ExprDotEvalArraySize();
                    methodEvals.add(sizeExpr);
                    currentInputType = sizeExpr.getTypeInfo();
                    continue;
                }
                if (chainElement.getName().toLowerCase(Locale.ENGLISH).equals("get") && paramTypes.length == 1 && JavaClassHelper.getBoxedType(paramTypes[0]) == Integer.class) {
                    Class componentType = type.getComponent();
                    ExprDotEvalArrayGet get = new ExprDotEvalArrayGet(paramEvals[0], componentType);
                    methodEvals.add(get);
                    currentInputType = get.getTypeInfo();
                    continue;
                }
            }
            boolean matchingMethod = false;
            Class methodTarget = ExprDotNodeUtility.getMethodTarget(currentInputType);
            if (methodTarget != null) {
                try {
                    ExprDotNodeUtility.getValidateMethodDescriptor(methodTarget, chainElement.getName(), chainElement.getParameters(), validationContext);
                    matchingMethod = true;
                }
                catch (ExprValidationException get) {
                    // empty catch block
                }
            }
            if (EnumMethodEnum.isEnumerationMethod(chainElement.getName()) && (!matchingMethod || methodTarget.isArray() || JavaClassHelper.isImplementsInterface(methodTarget, Collection.class))) {
                EnumMethodEnum enumerationMethod = EnumMethodEnum.fromName(chainElement.getName());
                ExprDotEvalEnumMethod eval = (ExprDotEvalEnumMethod)JavaClassHelper.instantiate(ExprDotEvalEnumMethod.class, enumerationMethod.getImplementation());
                eval.init(streamOfProviderIfApplicable, enumerationMethod, chainElement.getName(), currentInputType, chainElement.getParameters(), validationContext);
                currentInputType = eval.getTypeInfo();
                if (currentInputType == null) {
                    throw new IllegalStateException("Enumeration method '" + chainElement.getName() + "' has not returned type information");
                }
                methodEvals.add(eval);
                lastLambdaFunc = enumerationMethod;
                continue;
            }
            if (DatetimeMethodEnum.isDateTimeMethod(chainElement.getName()) && (!matchingMethod || methodTarget == Calendar.class || methodTarget == Date.class)) {
                DatetimeMethodEnum datetimeMethod = DatetimeMethodEnum.fromName(chainElement.getName());
                ExprDotEvalDTMethodDesc datetimeImpl = ExprDotEvalDTFactory.validateMake(validationContext.getStreamTypeService(), chainSpecStack, datetimeMethod, chainElement.getName(), currentInputType, chainElement.getParameters(), inputDesc, validationContext.getEngineImportService().getTimeZone(), validationContext.getEngineImportService().getTimeAbacus(), validationContext.getExprEvaluatorContext());
                currentInputType = datetimeImpl.getReturnType();
                if (currentInputType == null) {
                    throw new IllegalStateException("Date-time method '" + chainElement.getName() + "' has not returned type information");
                }
                methodEvals.add(datetimeImpl.getEval());
                filterAnalyzerDesc = datetimeImpl.getIntervalFilterDesc();
                continue;
            }
            if (currentInputType instanceof EventEPType) {
                EventType inputEventType = ((EventEPType)currentInputType).getType();
                Class type = inputEventType.getPropertyType(chainElement.getName());
                EventPropertyGetter getter = inputEventType.getGetter(chainElement.getName());
                if (type != null && getter != null) {
                    ExprDotEvalProperty noduck = new ExprDotEvalProperty(getter, EPTypeHelper.singleValue(JavaClassHelper.getBoxedType(type)));
                    methodEvals.add(noduck);
                    currentInputType = EPTypeHelper.singleValue(EPTypeHelper.getClassSingleValued(noduck.getTypeInfo()));
                    continue;
                }
            }
            if (methodTarget != null) {
                try {
                    ExprNodeUtilMethodDesc desc = ExprDotNodeUtility.getValidateMethodDescriptor(methodTarget, chainElement.getName(), chainElement.getParameters(), validationContext);
                    FastMethod fastMethod = desc.getFastMethod();
                    paramEvals = desc.getChildEvals();
                    ExprDotMethodEvalNoDuck eval = currentInputType instanceof ClassEPType ? (fastMethod.getReturnType().isArray() && !chainSpecStack.isEmpty() && EnumMethodEnum.isEnumerationMethod(((ExprChainedSpec)chainSpecStack.getFirst()).getName()) ? new ExprDotMethodEvalNoDuckWrapArray(validationContext.getStatementName(), fastMethod, paramEvals) : new ExprDotMethodEvalNoDuck(validationContext.getStatementName(), fastMethod, paramEvals)) : new ExprDotMethodEvalNoDuckUnderlying(validationContext.getStatementName(), fastMethod, paramEvals);
                    methodEvals.add(eval);
                    currentInputType = eval.getTypeInfo();
                }
                catch (Exception e) {
                    if (!isDuckTyping) {
                        throw new ExprValidationException(e.getMessage(), e);
                    }
                    ExprDotMethodEvalDuck duck = new ExprDotMethodEvalDuck(validationContext.getStatementName(), validationContext.getEngineImportService(), chainElement.getName(), paramTypes, paramEvals);
                    methodEvals.add(duck);
                    currentInputType = duck.getTypeInfo();
                }
                continue;
            }
            String message = "Could not find event property, enumeration method or instance method named '" + chainElement.getName() + "' in " + EPTypeHelper.toTypeDescriptive(currentInputType);
            throw new ExprValidationException(message);
        }
        ExprDotEval[] intermediateEvals = methodEvals.toArray(new ExprDotEval[methodEvals.size()]);
        if (lastLambdaFunc != null) {
            ExprDotEval finalEval = null;
            if (currentInputType instanceof EventMultiValuedEPType) {
                EventMultiValuedEPType mvType = (EventMultiValuedEPType)currentInputType;
                TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(mvType.getComponent());
                finalEval = tableMetadata != null ? new ExprDotEvalUnpackCollEventBeanTable(mvType.getComponent(), tableMetadata) : new ExprDotEvalUnpackCollEventBean(mvType.getComponent());
            } else if (currentInputType instanceof EventEPType) {
                EventEPType epType = (EventEPType)currentInputType;
                TableMetadata tableMetadata = validationContext.getTableService().getTableMetadataFromEventType(epType.getType());
                finalEval = tableMetadata != null ? new ExprDotEvalUnpackBeanTable(epType.getType(), tableMetadata) : new ExprDotEvalUnpackBean(epType.getType());
            }
            if (finalEval != null) {
                methodEvals.add(finalEval);
            }
        }
        ExprDotEval[] unpackingEvals = methodEvals.toArray(new ExprDotEval[methodEvals.size()]);
        return new ExprDotNodeRealizedChain(intermediateEvals, unpackingEvals, filterAnalyzerDesc);
    }

    private static Class getMethodTarget(EPType currentInputType) {
        if (currentInputType instanceof ClassEPType) {
            return ((ClassEPType)currentInputType).getType();
        }
        if (currentInputType instanceof EventEPType) {
            return ((EventEPType)currentInputType).getType().getUnderlyingType();
        }
        return null;
    }

    public static ObjectArrayEventType makeTransientOAType(String enumMethod, String propertyName, Class type, EventAdapterService eventAdapterService) {
        HashMap<String, Object> propsResult = new HashMap<String, Object>();
        propsResult.put(propertyName, type);
        String typeName = enumMethod + "__" + propertyName;
        return new ObjectArrayEventType(EventTypeMetadata.createAnonymous(typeName, EventTypeMetadata.ApplicationType.OBJECTARR), typeName, 0, eventAdapterService, propsResult, null, null, null);
    }

    public static EventType[] getSingleLambdaParamEventType(String enumMethodUsedName, List<String> goesToNames, EventType inputEventType, Class collectionComponentType, EventAdapterService eventAdapterService) {
        if (inputEventType != null) {
            return new EventType[]{inputEventType};
        }
        return new EventType[]{ExprDotNodeUtility.makeTransientOAType(enumMethodUsedName, goesToNames.get(0), collectionComponentType, eventAdapterService)};
    }

    public static Object evaluateChain(ExprDotEval[] evaluators, Object inner, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        ExprDotEval methodEval;
        ExprDotEval[] exprDotEvalArray = evaluators;
        int n = exprDotEvalArray.length;
        for (int i = 0; i < n && (inner = (methodEval = exprDotEvalArray[i]).evaluate(inner, eventsPerStream, isNewData, context)) != null; ++i) {
        }
        return inner;
    }

    public static Object evaluateChainWithWrap(ExprDotStaticMethodWrap resultWrapLambda, Object result, EventType optionalResultSingleEventType, Class resultType, ExprDotEval[] chainEval, EventBean[] eventsPerStream, boolean newData, ExprEvaluatorContext exprEvaluatorContext) {
        if (result == null) {
            return null;
        }
        if (resultWrapLambda != null) {
            result = resultWrapLambda.convert(result);
        }
        for (ExprDotEval aChainEval : chainEval) {
            if ((result = aChainEval.evaluate(result, eventsPerStream, newData, exprEvaluatorContext)) != null) continue;
            return result;
        }
        return result;
    }

    public static ExprDotEnumerationSource getEnumerationSource(ExprNode inputExpression, StreamTypeService streamTypeService, EventAdapterService eventAdapterService, int statementId, boolean hasEnumerationMethod, boolean disablePropertyExpressionEventCollCache) throws ExprValidationException {
        ExprEvaluator rootNodeEvaluator = inputExpression.getExprEvaluator();
        ExprEvaluatorEnumeration rootLambdaEvaluator = null;
        EPType info = null;
        if (rootNodeEvaluator instanceof ExprEvaluatorEnumeration) {
            rootLambdaEvaluator = (ExprEvaluatorEnumeration)((Object)rootNodeEvaluator);
            if (rootLambdaEvaluator.getEventTypeCollection(eventAdapterService, statementId) != null) {
                info = EPTypeHelper.collectionOfEvents(rootLambdaEvaluator.getEventTypeCollection(eventAdapterService, statementId));
            } else if (rootLambdaEvaluator.getEventTypeSingle(eventAdapterService, statementId) != null) {
                info = EPTypeHelper.singleEvent(rootLambdaEvaluator.getEventTypeSingle(eventAdapterService, statementId));
            } else if (rootLambdaEvaluator.getComponentTypeCollection() != null) {
                info = EPTypeHelper.collectionOfSingleValue(rootLambdaEvaluator.getComponentTypeCollection());
            } else {
                rootLambdaEvaluator = null;
            }
        } else if (inputExpression instanceof ExprIdentNode) {
            ExprIdentNode identNode = (ExprIdentNode)inputExpression;
            int streamId = identNode.getStreamId();
            EventType streamType = streamTypeService.getEventTypes()[streamId];
            return ExprDotNodeUtility.getPropertyEnumerationSource(identNode.getResolvedPropertyName(), streamId, streamType, hasEnumerationMethod, disablePropertyExpressionEventCollCache);
        }
        return new ExprDotEnumerationSource(info, null, rootLambdaEvaluator);
    }

    public static ExprDotEnumerationSourceForProps getPropertyEnumerationSource(String propertyName, int streamId, EventType streamType, boolean allowEnumType, boolean disablePropertyExpressionEventCollCache) {
        Class propertyType = streamType.getPropertyType(propertyName);
        EPType typeInfo = EPTypeHelper.singleValue(propertyType);
        if (!allowEnumType) {
            return new ExprDotEnumerationSourceForProps(null, typeInfo, streamId, null);
        }
        FragmentEventType fragmentEventType = streamType.getFragmentType(propertyName);
        EventPropertyGetter getter = streamType.getGetter(propertyName);
        ExprEvaluatorEnumeration enumEvaluator = null;
        if (getter != null && fragmentEventType != null) {
            if (fragmentEventType.isIndexed()) {
                enumEvaluator = new PropertyExprEvaluatorEventCollection(propertyName, streamId, fragmentEventType.getFragmentType(), getter, disablePropertyExpressionEventCollCache);
                typeInfo = EPTypeHelper.collectionOfEvents(fragmentEventType.getFragmentType());
            } else {
                enumEvaluator = new PropertyExprEvaluatorEventSingle(streamId, fragmentEventType.getFragmentType(), getter);
                typeInfo = EPTypeHelper.singleEvent(fragmentEventType.getFragmentType());
            }
        } else {
            EventPropertyDescriptor desc = EventTypeUtility.getNestablePropertyDescriptor(streamType, propertyName);
            if (desc != null && desc.isIndexed() && !desc.isRequiresIndex() && desc.getPropertyComponentType() != null) {
                if (JavaClassHelper.isImplementsInterface(propertyType, Collection.class)) {
                    enumEvaluator = new PropertyExprEvaluatorScalarCollection(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (JavaClassHelper.isImplementsInterface(propertyType, Iterable.class)) {
                    enumEvaluator = new PropertyExprEvaluatorScalarIterable(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else if (propertyType.isArray()) {
                    enumEvaluator = new PropertyExprEvaluatorScalarArray(propertyName, streamId, getter, desc.getPropertyComponentType());
                } else {
                    throw new IllegalStateException("Property indicated indexed-type but failed to find proper collection adapter for use with enumeration methods");
                }
                typeInfo = EPTypeHelper.collectionOfSingleValue(desc.getPropertyComponentType());
            }
        }
        ExprEvaluatorEnumerationGivenEvent enumEvaluatorGivenEvent = enumEvaluator;
        return new ExprDotEnumerationSourceForProps(enumEvaluator, typeInfo, streamId, enumEvaluatorGivenEvent);
    }

    private static ExprNodeUtilMethodDesc getValidateMethodDescriptor(Class methodTarget, final String methodName, List<ExprNode> parameters, ExprValidationContext validationContext) throws ExprValidationException {
        ExprNodeUtilResolveExceptionHandler exceptionHandler = new ExprNodeUtilResolveExceptionHandler(){

            @Override
            public ExprValidationException handle(Exception e) {
                return new ExprValidationException("Failed to resolve method '" + methodName + "': " + e.getMessage(), e);
            }
        };
        EventType wildcardType = validationContext.getStreamTypeService().getEventTypes().length != 1 ? null : validationContext.getStreamTypeService().getEventTypes()[0];
        return ExprNodeUtility.resolveMethodAllowWildcardAndStream(methodTarget.getName(), methodTarget, methodName, parameters, validationContext.getEngineImportService(), validationContext.getEventAdapterService(), validationContext.getStatementId(), wildcardType != null, wildcardType, exceptionHandler, methodName, validationContext.getTableService(), validationContext.getStreamTypeService().getEngineURIQualifier());
    }
}

