/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorTypableReturn;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExprCaseNode
extends ExprNodeBase
implements ExprEvaluator,
ExprEvaluatorTypableReturn {
    private static final long serialVersionUID = 792538321520346459L;
    private final boolean isCase2;
    private Class resultType;
    private transient LinkedHashMap<String, Object> mapResultType;
    private boolean isNumericResult;
    private boolean mustCoerce;
    private transient SimpleNumberCoercer coercer;
    private transient List<UniformPair<ExprEvaluator>> whenThenNodeList;
    private transient ExprEvaluator optionalCompareExprNode;
    private transient ExprEvaluator optionalElseExprNode;

    public ExprCaseNode(boolean isCase2) {
        this.isCase2 = isCase2;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public boolean isCase2() {
        return this.isCase2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        CaseAnalysis analysis = this.analyzeCase();
        this.whenThenNodeList = new ArrayList<UniformPair<ExprEvaluator>>();
        for (UniformPair<ExprNode> pair : analysis.getWhenThenNodeList()) {
            if (!this.isCase2 && pair.getFirst().getExprEvaluator().getType() != Boolean.class) {
                throw new ExprValidationException("Case node 'when' expressions must return a boolean value");
            }
            this.whenThenNodeList.add(new UniformPair<ExprEvaluator>(pair.getFirst().getExprEvaluator(), pair.getSecond().getExprEvaluator()));
        }
        if (analysis.getOptionalCompareExprNode() != null) {
            this.optionalCompareExprNode = analysis.getOptionalCompareExprNode().getExprEvaluator();
        }
        if (analysis.getOptionalElseExprNode() != null) {
            this.optionalElseExprNode = analysis.getOptionalElseExprNode().getExprEvaluator();
        }
        if (this.isCase2) {
            this.validateCaseTwo();
        }
        LinkedList<Class> childTypes = new LinkedList<Class>();
        LinkedList<LinkedHashMap<String, Object>> childMapTypes = new LinkedList<LinkedHashMap<String, Object>>();
        for (UniformPair<ExprEvaluator> pair : this.whenThenNodeList) {
            ExprEvaluatorTypableReturn typableReturn;
            LinkedHashMap<String, Object> rowProps;
            if (pair.getSecond() instanceof ExprEvaluatorTypableReturn && (rowProps = (typableReturn = (ExprEvaluatorTypableReturn)pair.getSecond()).getRowProperties()) != null) {
                childMapTypes.add(rowProps);
                continue;
            }
            childTypes.add(pair.getSecond().getType());
        }
        if (this.optionalElseExprNode != null) {
            if (this.optionalElseExprNode instanceof ExprEvaluatorTypableReturn) {
                ExprEvaluatorTypableReturn typableReturn = (ExprEvaluatorTypableReturn)this.optionalElseExprNode;
                LinkedHashMap<String, Object> rowProps = typableReturn.getRowProperties();
                if (rowProps != null) {
                    childMapTypes.add(rowProps);
                } else {
                    childTypes.add(this.optionalElseExprNode.getType());
                }
            } else {
                childTypes.add(this.optionalElseExprNode.getType());
            }
        }
        if (!childMapTypes.isEmpty() && !childTypes.isEmpty()) {
            String check;
            String message = "Case node 'when' expressions require that all results either return a single value or a Map-type (new-operator) value";
            int count = -1;
            for (UniformPair<ExprEvaluator> pair : this.whenThenNodeList) {
                ++count;
                if (pair.getSecond().getType() == Map.class || pair.getSecond().getType() == null) continue;
                check = ", check when-condition number " + count;
                throw new ExprValidationException(message + check);
            }
            if (this.optionalElseExprNode == null || this.optionalElseExprNode.getType() == Map.class || this.optionalElseExprNode.getType() == null) throw new ExprValidationException(message);
            check = ", check the else-condition";
            throw new ExprValidationException(message + check);
        }
        if (childMapTypes.isEmpty()) {
            try {
                this.resultType = JavaClassHelper.getCommonCoercionType(childTypes.toArray(new Class[childTypes.size()]));
                if (!JavaClassHelper.isNumeric(this.resultType)) return null;
                this.isNumericResult = true;
                return null;
            }
            catch (CoercionException ex) {
                throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
            }
        } else {
            this.mapResultType = (LinkedHashMap)childMapTypes.get(0);
            for (int i = 1; i < childMapTypes.size(); ++i) {
                Map other = (Map)childMapTypes.get(i);
                String messageEquals = MapEventType.isDeepEqualsProperties("Case-when number " + i, this.mapResultType, other);
                if (messageEquals == null) continue;
                throw new ExprValidationException("Incompatible case-when return types by new-operator in case-when number " + i + ": " + messageEquals);
            }
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public LinkedHashMap<String, Object> getRowProperties() throws ExprValidationException {
        return this.mapResultType;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (!this.isCase2) {
            return this.evaluateCaseSyntax1(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        return this.evaluateCaseSyntax2(eventsPerStream, isNewData, exprEvaluatorContext);
    }

    @Override
    public Boolean isMultirow() {
        return this.mapResultType == null ? null : Boolean.valueOf(false);
    }

    @Override
    public Object[] evaluateTypableSingle(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Map map = (Map)this.evaluate(eventsPerStream, isNewData, context);
        Object[] row = new Object[map.size()];
        int index = -1;
        for (Map.Entry<String, Object> entry : this.mapResultType.entrySet()) {
            row[++index] = map.get(entry.getKey());
        }
        return row;
    }

    @Override
    public Object[][] evaluateTypableMulti(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprCaseNode)) {
            return false;
        }
        ExprCaseNode otherExprCaseNode = (ExprCaseNode)node;
        return this.isCase2 == otherExprCaseNode.isCase2;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        CaseAnalysis analysis;
        try {
            analysis = this.analyzeCase();
        }
        catch (ExprValidationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        writer.append("case");
        if (this.isCase2) {
            writer.append(' ');
            analysis.getOptionalCompareExprNode().toEPL(writer, this.getPrecedence());
        }
        for (UniformPair<ExprNode> p : analysis.getWhenThenNodeList()) {
            writer.append(" when ");
            p.getFirst().toEPL(writer, this.getPrecedence());
            writer.append(" then ");
            p.getSecond().toEPL(writer, this.getPrecedence());
        }
        if (analysis.getOptionalElseExprNode() != null) {
            writer.append(" else ");
            analysis.getOptionalElseExprNode().toEPL(writer, this.getPrecedence());
        }
        writer.append(" end");
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.CASE;
    }

    private CaseAnalysis analyzeCaseOne() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes();
        if (children.length < 2) {
            throw new ExprValidationException("Case node must have at least 2 parameters");
        }
        LinkedList<UniformPair<ExprNode>> whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = children.length >> 1;
        for (int i = 0; i < numWhenThen; ++i) {
            ExprNode whenExpr = children[i << 1];
            ExprNode thenExpr = children[(i << 1) + 1];
            whenThenNodeList.add(new UniformPair<ExprNode>(whenExpr, thenExpr));
        }
        ExprNode optionalElseExprNode = null;
        if (children.length % 2 != 0) {
            optionalElseExprNode = children[children.length - 1];
        }
        return new CaseAnalysis(whenThenNodeList, null, optionalElseExprNode);
    }

    private CaseAnalysis analyzeCaseTwo() throws ExprValidationException {
        ExprNode[] children = this.getChildNodes();
        if (children.length < 3) {
            throw new ExprValidationException("Case node must have at least 3 parameters");
        }
        ExprNode optionalCompareExprNode = children[0];
        LinkedList<UniformPair<ExprNode>> whenThenNodeList = new LinkedList<UniformPair<ExprNode>>();
        int numWhenThen = (children.length - 1) / 2;
        for (int i = 0; i < numWhenThen; ++i) {
            whenThenNodeList.add(new UniformPair<ExprNode>(children[i * 2 + 1], children[i * 2 + 2]));
        }
        ExprNode optionalElseExprNode = null;
        if (numWhenThen * 2 + 1 < children.length) {
            optionalElseExprNode = children[children.length - 1];
        }
        return new CaseAnalysis(whenThenNodeList, optionalCompareExprNode, optionalElseExprNode);
    }

    private void validateCaseTwo() throws ExprValidationException {
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        comparedTypes.add(this.optionalCompareExprNode.getType());
        for (UniformPair<ExprEvaluator> pair : this.whenThenNodeList) {
            comparedTypes.add(pair.getFirst().getType());
        }
        try {
            Class coercionType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
            if (JavaClassHelper.isNumeric(coercionType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == coercionType) continue;
                    this.mustCoerce = true;
                }
                if (this.mustCoerce) {
                    this.coercer = SimpleNumberCoercerFactory.getCoercer(null, coercionType);
                }
            }
        }
        catch (CoercionException ex) {
            throw new ExprValidationException("Implicit conversion not allowed: " + ex.getMessage());
        }
    }

    private Object evaluateCaseSyntax1(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprEvaluator> p : this.whenThenNodeList) {
            Boolean whenResult = (Boolean)p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (whenResult == null || !whenResult.booleanValue()) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.resultType && this.isNumericResult) {
            return JavaClassHelper.coerceBoxed((Number)caseResult, this.resultType);
        }
        return caseResult;
    }

    private Object evaluateCaseSyntax2(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Object checkResult = this.optionalCompareExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        Object caseResult = null;
        boolean matched = false;
        for (UniformPair<ExprEvaluator> p : this.whenThenNodeList) {
            Object whenResult = p.getFirst().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (!this.compare(checkResult, whenResult)) continue;
            caseResult = p.getSecond().evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            matched = true;
            break;
        }
        if (!matched && this.optionalElseExprNode != null) {
            caseResult = this.optionalElseExprNode.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
        }
        if (caseResult == null) {
            return null;
        }
        if (caseResult.getClass() != this.resultType && this.isNumericResult) {
            return JavaClassHelper.coerceBoxed((Number)caseResult, this.resultType);
        }
        return caseResult;
    }

    private boolean compare(Object leftResult, Object rightResult) {
        if (leftResult == null) {
            return rightResult == null;
        }
        if (rightResult == null) {
            return false;
        }
        if (!this.mustCoerce) {
            return leftResult.equals(rightResult);
        }
        Number left = this.coercer.coerceBoxed((Number)leftResult);
        Number right = this.coercer.coerceBoxed((Number)rightResult);
        return left.equals(right);
    }

    private CaseAnalysis analyzeCase() throws ExprValidationException {
        if (this.isCase2) {
            return this.analyzeCaseTwo();
        }
        return this.analyzeCaseOne();
    }

    public static class CaseAnalysis {
        private List<UniformPair<ExprNode>> whenThenNodeList;
        private ExprNode optionalCompareExprNode;
        private ExprNode optionalElseExprNode;

        public CaseAnalysis(List<UniformPair<ExprNode>> whenThenNodeList, ExprNode optionalCompareExprNode, ExprNode optionalElseExprNode) {
            this.whenThenNodeList = whenThenNodeList;
            this.optionalCompareExprNode = optionalCompareExprNode;
            this.optionalElseExprNode = optionalElseExprNode;
        }

        public List<UniformPair<ExprNode>> getWhenThenNodeList() {
            return this.whenThenNodeList;
        }

        public ExprNode getOptionalCompareExprNode() {
            return this.optionalCompareExprNode;
        }

        public ExprNode getOptionalElseExprNode() {
            return this.optionalElseExprNode;
        }
    }
}

