/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.funcs;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ExprMinMaxRowNode
extends ExprNodeBase
implements ExprEvaluator {
    private MinMaxTypeEnum minMaxTypeEnum;
    private Class resultType;
    private transient MinMaxTypeEnum.Computer computer;
    private transient ExprEvaluator[] evaluators;
    private static final long serialVersionUID = -5244192656164983580L;

    public ExprMinMaxRowNode(MinMaxTypeEnum minMaxTypeEnum) {
        this.minMaxTypeEnum = minMaxTypeEnum;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        Object[] convertors;
        if (this.getChildNodes().length < 2) {
            throw new ExprValidationException("MinMax node must have at least 2 parameters");
        }
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class childType = child.getType();
            if (JavaClassHelper.isNumeric(childType)) continue;
            throw new ExprValidationException("Implicit conversion from datatype '" + childType.getSimpleName() + "' to numeric is not allowed");
        }
        Class childTypeOne = this.evaluators[0].getType();
        Class childTypeTwo = this.evaluators[1].getType();
        this.resultType = JavaClassHelper.getArithmaticCoercionType(childTypeOne, childTypeTwo);
        for (int i = 2; i < this.getChildNodes().length; ++i) {
            this.resultType = JavaClassHelper.getArithmaticCoercionType(this.resultType, this.evaluators[i].getType());
        }
        ExprNode[] childNodes = this.getChildNodes();
        if (this.resultType == BigInteger.class) {
            convertors = new SimpleNumberBigIntegerCoercer[childNodes.length];
            for (int i = 0; i < childNodes.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigInteger(this.evaluators[i].getType());
            }
            this.computer = new MinMaxTypeEnum.ComputerBigIntCoerce(this.evaluators, (SimpleNumberBigIntegerCoercer[])convertors, this.minMaxTypeEnum == MinMaxTypeEnum.MAX);
        } else if (this.resultType == BigDecimal.class) {
            convertors = new SimpleNumberBigDecimalCoercer[childNodes.length];
            for (int i = 0; i < childNodes.length; ++i) {
                convertors[i] = SimpleNumberCoercerFactory.getCoercerBigDecimal(this.evaluators[i].getType());
            }
            this.computer = new MinMaxTypeEnum.ComputerBigDecCoerce(this.evaluators, (SimpleNumberBigDecimalCoercer[])convertors, this.minMaxTypeEnum == MinMaxTypeEnum.MAX);
        } else {
            this.computer = this.minMaxTypeEnum == MinMaxTypeEnum.MAX ? new MinMaxTypeEnum.MaxComputerDoubleCoerce(this.evaluators) : new MinMaxTypeEnum.MinComputerDoubleCoerce(this.evaluators);
        }
        return null;
    }

    @Override
    public Class getType() {
        return this.resultType;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Number result = this.computer.execute(eventsPerStream, isNewData, exprEvaluatorContext);
        if (result == null) {
            return null;
        }
        return JavaClassHelper.coerceBoxed(result, this.resultType);
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        writer.append(this.minMaxTypeEnum.getExpressionText());
        writer.append('(');
        this.getChildNodes()[0].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        writer.append(',');
        this.getChildNodes()[1].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        for (int i = 2; i < this.getChildNodes().length; ++i) {
            writer.append(',');
            this.getChildNodes()[i].toEPL(writer, ExprPrecedenceEnum.MINIMUM);
        }
        writer.append(')');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        if (!(node instanceof ExprMinMaxRowNode)) {
            return false;
        }
        ExprMinMaxRowNode other = (ExprMinMaxRowNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum;
    }
}

