/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.core.service.StatementType;
import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.type.MinMaxTypeEnum;

public class ExprMinMaxAggrNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = -7828413362615586145L;
    private final MinMaxTypeEnum minMaxTypeEnum;
    private final boolean isFFunc;
    private final boolean isEver;
    private boolean hasFilter;

    public ExprMinMaxAggrNode(boolean distinct, MinMaxTypeEnum minMaxTypeEnum, boolean isFFunc, boolean isEver) {
        super(distinct);
        this.minMaxTypeEnum = minMaxTypeEnum;
        this.isFFunc = isFFunc;
        this.isEver = isEver;
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        if (this.positionalParams.length == 0 || this.positionalParams.length > 2) {
            throw new ExprValidationException(this.minMaxTypeEnum.toString() + " node must have either 1 or 2 parameters");
        }
        ExprNode child = this.positionalParams[0];
        boolean hasDataWindows = this.isEver ? false : (validationContext.getExprEvaluatorContext().getStatementType() == StatementType.CREATE_TABLE ? true : ExprNodeUtility.hasRemoveStreamForAggregations(child, validationContext.getStreamTypeService(), validationContext.isResettingAggregations()));
        if (this.isFFunc) {
            if (this.positionalParams.length < 2) {
                throw new ExprValidationException(this.minMaxTypeEnum.toString() + "-filtered aggregation function must have a filter expression as a second parameter");
            }
            super.validateFilter(this.positionalParams[1].getExprEvaluator());
        }
        this.hasFilter = this.positionalParams.length == 2;
        return validationContext.getEngineImportService().getAggregationFactoryFactory().makeMinMax(validationContext.getStatementExtensionSvcContext(), this, child.getExprEvaluator().getType(), hasDataWindows);
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        if (!(node instanceof ExprMinMaxAggrNode)) {
            return false;
        }
        ExprMinMaxAggrNode other = (ExprMinMaxAggrNode)node;
        return other.minMaxTypeEnum == this.minMaxTypeEnum && other.isEver == this.isEver;
    }

    public MinMaxTypeEnum getMinMaxTypeEnum() {
        return this.minMaxTypeEnum;
    }

    public boolean isHasFilter() {
        return this.hasFilter;
    }

    @Override
    public String getAggregationFunctionName() {
        return this.minMaxTypeEnum.getExpressionText();
    }

    public boolean isEver() {
        return this.isEver;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return true;
    }
}

