/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.methodagg;

import com.espertech.esper.epl.agg.service.AggregationMethodFactory;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNode;
import com.espertech.esper.epl.expression.baseagg.ExprAggregateNodeBase;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;

public class ExprNthAggNode
extends ExprAggregateNodeBase {
    private static final long serialVersionUID = -843689785630260527L;

    public ExprNthAggNode(boolean distinct) {
        super(distinct);
    }

    @Override
    public AggregationMethodFactory validateAggregationChild(ExprValidationContext validationContext) throws ExprValidationException {
        String message = "The nth aggregation function requires two parameters, an expression returning aggregation values and a numeric index constant";
        if (this.positionalParams.length != 2) {
            throw new ExprValidationException(message);
        }
        ExprNode first = this.positionalParams[0];
        ExprNode second = this.positionalParams[1];
        if (!second.isConstantResult()) {
            throw new ExprValidationException(message);
        }
        Number num = (Number)second.getExprEvaluator().evaluate(null, true, validationContext.getExprEvaluatorContext());
        int size = num.intValue();
        if (this.optionalFilter != null) {
            this.positionalParams = ExprNodeUtility.addExpression(this.positionalParams, this.optionalFilter);
        }
        return validationContext.getEngineImportService().getAggregationFactoryFactory().makeNth(validationContext.getStatementExtensionSvcContext(), this, first.getExprEvaluator().getType(), size);
    }

    @Override
    public String getAggregationFunctionName() {
        return "nth";
    }

    @Override
    public final boolean equalsNodeAggregateMethodOnly(ExprAggregateNode node) {
        return node instanceof ExprNthAggNode;
    }

    @Override
    protected boolean isFilterExpressionAsLastParameter() {
        return false;
    }
}

