/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.epl.expression.ops.ExprAndNode;
import com.espertech.esper.util.JavaClassHelper;
import java.io.StringWriter;

public class ExprAndNodeImpl
extends ExprNodeBase
implements ExprEvaluator,
ExprAndNode {
    private static final long serialVersionUID = 8105121208330622813L;
    private transient ExprEvaluator[] evaluators;

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        for (ExprEvaluator child : this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes())) {
            Class childType = child.getType();
            if (JavaClassHelper.isBoolean(childType)) continue;
            throw new ExprValidationException("Incorrect use of AND clause, sub-expressions do not return boolean");
        }
        if (this.getChildNodes().length <= 1) {
            throw new ExprValidationException("The AND operator requires at least 2 child expressions");
        }
        return null;
    }

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public boolean isConstantResult() {
        return false;
    }

    @Override
    public Class getType() {
        return Boolean.class;
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        Boolean result = true;
        for (ExprEvaluator child : this.evaluators) {
            Boolean evaluated = (Boolean)child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (evaluated == null) {
                result = null;
                continue;
            }
            if (evaluated.booleanValue()) continue;
            return false;
        }
        return result;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String appendStr = "";
        for (ExprNode child : this.getChildNodes()) {
            writer.append(appendStr);
            child.toEPL(writer, this.getPrecedence());
            appendStr = " and ";
        }
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.AND;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprAndNodeImpl;
    }
}

