/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.expression.ops;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.core.ExprEvaluator;
import com.espertech.esper.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.core.ExprEvaluatorEnumeration;
import com.espertech.esper.epl.expression.core.ExprNode;
import com.espertech.esper.epl.expression.core.ExprNodeBase;
import com.espertech.esper.epl.expression.core.ExprNodeUtility;
import com.espertech.esper.epl.expression.core.ExprPrecedenceEnum;
import com.espertech.esper.epl.expression.core.ExprValidationContext;
import com.espertech.esper.epl.expression.core.ExprValidationException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleNumberCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class ExprArrayNode
extends ExprNodeBase
implements ExprEvaluator,
ExprEvaluatorEnumeration {
    private Class arrayReturnType;
    private boolean mustCoerce;
    private int length;
    private transient SimpleNumberCoercer coercer;
    private transient Object constantResult;
    private transient ExprEvaluator[] evaluators;
    private volatile transient Collection constantResultList;
    private static final long serialVersionUID = 5533223915923867651L;

    @Override
    public ExprEvaluator getExprEvaluator() {
        return this;
    }

    @Override
    public ExprNode validate(ExprValidationContext validationContext) throws ExprValidationException {
        this.length = this.getChildNodes().length;
        this.evaluators = ExprNodeUtility.getEvaluators(this.getChildNodes());
        if (this.getChildNodes().length == 0) {
            this.arrayReturnType = Object.class;
            this.constantResult = new Object[0];
            return null;
        }
        LinkedList<Class> comparedTypes = new LinkedList<Class>();
        for (int i = 0; i < this.length; ++i) {
            comparedTypes.add(this.evaluators[i].getType());
        }
        try {
            this.arrayReturnType = JavaClassHelper.getCommonCoercionType(comparedTypes.toArray(new Class[comparedTypes.size()]));
            if (JavaClassHelper.isNumeric(this.arrayReturnType)) {
                this.mustCoerce = false;
                for (Class comparedType : comparedTypes) {
                    if (comparedType == this.arrayReturnType) continue;
                    this.mustCoerce = true;
                }
                if (this.mustCoerce) {
                    this.coercer = SimpleNumberCoercerFactory.getCoercer(null, this.arrayReturnType);
                }
            }
        }
        catch (CoercionException i) {
            // empty catch block
        }
        if (this.arrayReturnType == null) {
            this.arrayReturnType = Object.class;
        }
        Object[] results = new Object[this.length];
        int index = 0;
        for (ExprNode child : this.getChildNodes()) {
            if (!child.isConstantResult()) {
                results = null;
                break;
            }
            results[index] = this.evaluators[index].evaluate(null, false, validationContext.getExprEvaluatorContext());
            ++index;
        }
        if (results != null) {
            this.constantResult = Array.newInstance(this.arrayReturnType, this.length);
            for (int i = 0; i < this.length; ++i) {
                if (this.mustCoerce) {
                    Number boxed = (Number)results[i];
                    if (boxed == null) continue;
                    Number coercedResult = this.coercer.coerceBoxed(boxed);
                    Array.set(this.constantResult, i, coercedResult);
                    continue;
                }
                Array.set(this.constantResult, i, results[i]);
            }
        }
        return null;
    }

    @Override
    public boolean isConstantResult() {
        return this.constantResult != null;
    }

    @Override
    public Class getType() {
        return Array.newInstance(this.arrayReturnType, 0).getClass();
    }

    @Override
    public Object evaluate(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.constantResult != null) {
            return this.constantResult;
        }
        Object array = Array.newInstance(this.arrayReturnType, this.length);
        if (this.length == 0) {
            return array;
        }
        int index = 0;
        for (ExprEvaluator child : this.evaluators) {
            Object result = child.evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (result != null) {
                if (this.mustCoerce) {
                    Number boxed = (Number)result;
                    Number coercedResult = this.coercer.coerceBoxed(boxed);
                    Array.set(array, index, coercedResult);
                } else {
                    Array.set(array, index, result);
                }
            }
            ++index;
        }
        return array;
    }

    @Override
    public void toPrecedenceFreeEPL(StringWriter writer) {
        String delimiter = "";
        writer.append("{");
        for (ExprNode expr : this.getChildNodes()) {
            writer.append(delimiter);
            expr.toEPL(writer, ExprPrecedenceEnum.MINIMUM);
            delimiter = ",";
        }
        writer.append('}');
    }

    @Override
    public ExprPrecedenceEnum getPrecedence() {
        return ExprPrecedenceEnum.UNARY;
    }

    @Override
    public Class getComponentTypeCollection() throws ExprValidationException {
        return this.arrayReturnType;
    }

    @Override
    public Collection evaluateGetROCollectionScalar(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        if (this.constantResult != null) {
            if (this.constantResultList != null) {
                return this.constantResultList;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < this.length; ++i) {
                list.add(Array.get(this.constantResult, i));
            }
            this.constantResultList = list;
            return list;
        }
        if (this.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>();
        int index = 0;
        for (ExprEvaluator child : this.evaluators) {
            Object result = child.evaluate(eventsPerStream, isNewData, context);
            if (result != null) {
                if (this.mustCoerce) {
                    Number boxed = (Number)result;
                    Number coercedResult = this.coercer.coerceBoxed(boxed);
                    resultList.add(coercedResult);
                } else {
                    resultList.add(result);
                }
            }
            ++index;
        }
        return resultList;
    }

    @Override
    public EventType getEventTypeCollection(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public Collection<EventBean> evaluateGetROCollectionEvents(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public EventType getEventTypeSingle(EventAdapterService eventAdapterService, int statementId) throws ExprValidationException {
        return null;
    }

    @Override
    public EventBean evaluateGetEventBean(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        return null;
    }

    @Override
    public boolean equalsNode(ExprNode node, boolean ignoreStreamPrefix) {
        return node instanceof ExprArrayNode;
    }
}

